/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.scrap.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.scrap.command.RollerScrapCommand;
import com.els.base.mould.roller.scrap.command.SaveFileCommand;
import com.els.base.mould.roller.scrap.command.ScrapModifyCommand;
import com.els.base.mould.roller.scrap.entity.RollerScrap;
import com.els.base.mould.roller.scrap.entity.RollerScrapExample;
import com.els.base.mould.roller.scrap.service.RollerScrapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7248\u8f8a\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
@Controller
@RequestMapping(value={"rollerScrap"})
public class RollerScrapController {
    @Resource
    protected RollerScrapService rollerScrapService;
    @Resource
    protected MouldInvorker mouldInvorker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7248\u8f8a\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u7248\u8f8a\u4e3b\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        RollerScrapCommand command = new RollerScrapCommand(ids);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser(SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u7248\u8f8a\u7ba1\u7406-\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody RollerScrap scrap) {
        Assert.isNotNull((Object)scrap, (String)"\u62a5\u5e9f\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        ScrapModifyCommand command = new ScrapModifyCommand(scrap);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser(SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u9001\u7248\u8f8a\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/sendToPur"})
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u53d1\u9001\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.rollerScrapService.sendToPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5220\u9664\u7248\u8f8a\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.rollerScrapService.deleteByIds(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u786e\u8ba4\u7248\u8f8a\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/confirmToPur"})
    @ResponseBody
    public ResponseResult<String> confirmToPur(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u786e\u8ba4\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.rollerScrapService.confirmToPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u7248\u8f8a\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RollerScrap", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<RollerScrap>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerScrapExample example = new RollerScrapExample();
        example.setPageView((PageView<RollerScrap>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        RollerScrapExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N").andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerScrapService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u7248\u8f8a\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RollerScrap", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/purfindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RollerScrap>> purfindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RollerScrapExample example = new RollerScrapExample();
        example.setPageView((PageView<RollerScrap>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        RollerScrapExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N").andSendStatusEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.rollerScrapService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u62a5\u5e9f\u5355\u2014\u786e\u8ba4\u5b8c\u6210\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/saveFile"})
    @ResponseBody
    public ResponseResult<String> saveFile(@RequestBody RollerScrap scrap) {
        Assert.isNotNull((Object)scrap, (String)"\u62a5\u5e9f\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        SaveFileCommand command = new SaveFileCommand(scrap);
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }
}

