package com.els.base.mq.common;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

import com.els.base.utils.json.JsonUtils;

public class CustomMessageConverter implements MessageConverter {

	private static Logger logger = LoggerFactory.getLogger(CustomMessageConverter.class);
	
	@Override
	public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
		EventMessage message = (EventMessage) object;
		return session.createObjectMessage(message);
	}

	@Override
	public Object fromMessage(Message message) throws JMSException, MessageConversionException {
		TextMessage objectMessage = (TextMessage) message;
		String objJson = objectMessage.getText();
		
		EventMessage eventMessage = null;
		try {
			eventMessage = JsonUtils.convertValue(objJson, EventMessage.class);
		} catch (Exception e) {
			logger.error("通过activemq接受事件失败", e);
		}
		
		return eventMessage;
	}

}
