package com.els.base.mq.activemq;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;

import com.els.base.core.event.BaseEvent;
import com.els.base.core.event.EventPublisher;
import com.els.base.mq.activemq.procedure.TopicMessageProducer;
import com.els.base.mq.common.EventMessage;

@Component("activeMqEventPublisher")
public class ActiveMqEventPublisher implements EventPublisher {
	
	private static Logger logger = LoggerFactory.getLogger(ActiveMqEventPublisher.class);

	@Resource
	private TopicMessageProducer producer;
	
	@Override
	public void multicastEvent(BaseEvent baseEvent, ResolvableType eventType) {
		EventMessage message = new EventMessage(baseEvent, eventType);
		try {
			producer.sendMessage(message);
		} catch (Exception e) {
			
			logger.error("通过 activemq 触发事件失败", e);
			throw new RuntimeException(e);
		}
	}
	
}
