/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mq.common;

import com.els.base.mq.common.EventMessage;
import com.els.base.utils.json.JsonUtils;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class CustomMessageConverter
implements MessageConverter {
    private static Logger logger = LoggerFactory.getLogger(CustomMessageConverter.class);

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        EventMessage message = (EventMessage)object;
        return session.createObjectMessage((Serializable)message);
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        TextMessage objectMessage = (TextMessage)message;
        String objJson = objectMessage.getText();
        EventMessage eventMessage = null;
        try {
            eventMessage = (EventMessage)JsonUtils.convertValue((String)objJson, EventMessage.class);
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7activemq\u63a5\u53d7\u4e8b\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return eventMessage;
    }
}

