package com.els.base.mq.activemq.consumer;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.SimpleApplicationEventMulticaster;

import com.els.base.mq.common.EventMessage;

public class TopicConsumer {
	
	private static Logger logger = LoggerFactory.getLogger(TopicConsumer.class);
	
	@Resource(name="eventMulticaster")
	private SimpleApplicationEventMulticaster eventMulticaster;
	
	public void receive(EventMessage message) {
//		logger.debug("receive a msg, event [{}], event type [{}]", message.getBaseEvent(), message.getEventType());
		eventMulticaster.multicastEvent(message.getBaseEvent(), message.getEventType());
	}

}
