/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mq.activemq.procedure;

import com.els.base.mq.common.EventMessage;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQTopic;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class TopicMessageProducer {
    private JmsTemplate template;
    private ActiveMQTopic destination;

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public ActiveMQTopic getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQTopic destination) {
        this.destination = destination;
    }

    public void sendMessage(EventMessage eventMessage) throws JsonProcessingException {
        final String eventMessageJson = JsonUtils.writeValueAsString((Object)eventMessage);
        this.template.send((Destination)this.destination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(eventMessageJson);
            }
        });
    }
}

