package com.els.base.mq.activemq.procedure;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

import org.apache.activemq.command.ActiveMQTopic;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

import com.els.base.mq.common.EventMessage;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;

public class TopicMessageProducer {

	private JmsTemplate template;
	private ActiveMQTopic destination;

	public JmsTemplate getTemplate() {
		return template;
	}

	public void setTemplate(JmsTemplate template) {
		this.template = template;
	}

	public ActiveMQTopic getDestination() {
		return destination;
	}

	public void setDestination(ActiveMQTopic destination) {
		this.destination = destination;
	}

	public void sendMessage(EventMessage eventMessage) throws JsonProcessingException {
		
		final String eventMessageJson = JsonUtils.writeValueAsString(eventMessage);
		template.send(destination, new MessageCreator() {

			@Override
			public Message createMessage(Session session) throws JMSException {
//				return session.createObjectMessage(eventMessage);
				return session.createTextMessage(eventMessageJson);
			}
		});

	}

}
