/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.log.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.log.entity.OperationLog;
import com.els.base.log.entity.OperationLogExample;
import com.els.base.log.service.OperationLogService;
import com.els.base.utils.excel.EasyPoiExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u64cd\u4f5c\u65e5\u5fd7"})
@Controller
@RequestMapping(value={"operationLog"})
public class OperationLogController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected OperationLogService operationLogService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody OperationLog operationLog) {
        User user = SpringSecurityUtils.getLoginUser();
        Assert.isNotNull((Object)user, (String)"\u767b\u5f55\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        operationLog.setUserId(user.getId());
        operationLog.setUserName(user.getNickName());
        operationLog.setProjectId(ProjectUtils.getProjectId());
        operationLog.setCreateTime(new Date());
        this.operationLogService.addObj(operationLog);
        return ResponseResult.success((Object)operationLog.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.operationLogService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u4e2d\u81f3\u5c11\u4e00\u6761\u6570\u636e\uff0c\u8fdb\u884c\u64cd\u4f5c");
        OperationLogExample example = new OperationLogExample();
        example.createCriteria().andIdIn((List)ids);
        this.operationLogService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u6309\u7167\u6761\u4ef6\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 InterfaceLog", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/delete"})
    @ResponseBody
    public ResponseResult<String> delete(@RequestBody(required=false) QueryParamWapper wapper) {
        OperationLogExample example = new OperationLogExample();
        OperationLogExample.Criteria criteria = example.createCriteria();
        if (!SpringSecurityUtils.isManagerRole()) {
            criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        this.operationLogService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u65e7\u67e5\u8be2\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OperationLog>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> params) {
        PageView pageView = new PageView(pageNo, pageSize);
        OperationLogExample example = new OperationLogExample();
        example.setPageView((PageView<OperationLog>)pageView);
        example.setOrderByClause("create_time DESC");
        OperationLogExample.Criteria criteria = example.createCriteria();
        if (!SpringSecurityUtils.isManagerRole()) {
            criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        if (CollectionUtils.isNotEmpty(params)) {
            CriteriaUtils.addCriterion((Object)criteria, params);
        }
        PageView pageData = this.operationLogService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u67e5\u8be2\u64cd\u4f5c\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 InterfaceLog", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/new/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OperationLog>> newFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageView = new PageView(pageNo, pageSize);
        OperationLogExample example = new OperationLogExample();
        example.setPageView((PageView<OperationLog>)pageView);
        example.setOrderByClause("create_time DESC");
        OperationLogExample.Criteria criteria = example.createCriteria();
        if (!SpringSecurityUtils.isManagerRole()) {
            criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.operationLogService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5bfc\u51fa")
    @RequestMapping(value={"service/export"}, method={RequestMethod.GET})
    public void exportExcel(@RequestParam(required=false) String ids, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        OperationLogExample roleExample = new OperationLogExample();
        OperationLogExample.Criteria criteria = roleExample.createCriteria();
        if (StringUtils.isNotBlank((String)ids)) {
            if (ids.contains(",")) {
                Object[] split = StringUtils.split((String)",");
                if (ArrayUtils.isNotEmpty((Object[])split)) {
                    List<Object> list = Arrays.asList(split);
                    criteria.andIdIn(list);
                }
            } else {
                criteria.andIdEqualTo(ids);
            }
        }
        if (!SpringSecurityUtils.isManagerRole()) {
            criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        roleExample.setOrderByClause("CREATE_TIME DESC");
        List operationLogs = this.operationLogService.queryAllObjByExample((IExample)roleExample);
        Assert.isNotEmpty((Collection)operationLogs, (String)"\u6ca1\u6709\u627e\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        this.logger.debug("\u5bfc\u51faexcel\u6240\u82b1\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        try {
            String format = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            EasyPoiExcelUtils.exportExcel((List)operationLogs, (String)"\u65e5\u5fd7\u7ba1\u7406", (String)"\u65e5\u5fd7\u7ba1\u7406", OperationLog.class, (String)("\u65e5\u5fd7\u7ba1\u7406" + format), (HttpServletResponse)response);
        }
        catch (IOException e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25{}", (Object)e.getMessage());
            throw new CommonException("\u5bfc\u51fa\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\uff01");
        }
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7\u8bf7\u6c42\u4f53\u4f20")
    @RequestMapping(value={"service/export2"}, method={RequestMethod.GET})
    public void export2(@RequestBody List<String> ids, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        OperationLogExample roleExample = new OperationLogExample();
        OperationLogExample.Criteria criteria = roleExample.createCriteria();
        if (CollectionUtils.isNotEmpty(ids)) {
            criteria.andIdIn((List)ids);
        }
        if (!SpringSecurityUtils.isManagerRole()) {
            criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        roleExample.setOrderByClause("CREATE_TIME DESC");
        List operationLogs = this.operationLogService.queryAllObjByExample((IExample)roleExample);
        Assert.isNotEmpty((Collection)operationLogs, (String)"\u6ca1\u6709\u627e\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        this.logger.debug("\u5bfc\u51faexcel\u6240\u82b1\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        try {
            String format = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            EasyPoiExcelUtils.exportExcel((List)operationLogs, (String)"\u65e5\u5fd7\u7ba1\u7406", (String)"\u65e5\u5fd7\u7ba1\u7406", OperationLog.class, (String)("\u65e5\u5fd7\u7ba1\u7406" + format), (HttpServletResponse)response);
        }
        catch (IOException e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25{}", (Object)e.getMessage());
            throw new CommonException("\u5bfc\u51fa\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\uff01");
        }
    }
}

