/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.log.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.log.dao.OperationLogMapper;
import com.els.base.log.entity.OperationLog;
import com.els.base.log.entity.OperationLogExample;
import com.els.base.log.service.OperationLogService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="operationLogService")
public class OperationLogServiceImpl
implements OperationLogService {
    @Resource
    protected OperationLogMapper operationLogMapper;

    @CacheEvict(value={"operationLog"}, allEntries=true)
    public void addObj(OperationLog t) {
        t.setCreateTime(new Date());
        this.operationLogMapper.insertSelective(t);
    }

    @CacheEvict(value={"operationLog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.operationLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"operationLog"}, allEntries=true)
    public void modifyObj(OperationLog t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.operationLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"operationLog"}, keyGenerator="redisKeyGenerator")
    public OperationLog queryObjById(String id) {
        return this.operationLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"operationLog"}, keyGenerator="redisKeyGenerator")
    public List<OperationLog> queryAllObjByExample(OperationLogExample example) {
        return this.operationLogMapper.selectByExample(example);
    }

    @Cacheable(value={"operationLog"}, keyGenerator="redisKeyGenerator")
    public PageView<OperationLog> queryObjByPage(OperationLogExample example) {
        PageView<OperationLog> pageView = example.getPageView();
        pageView.setQueryResult(this.operationLogMapper.selectByExampleByPage(example));
        return pageView;
    }
}

