/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.log.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.log.entity.OperationLog;
import com.els.base.log.entity.OperationLogExample;
import com.els.base.log.service.OperationLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u64cd\u4f5c\u65e5\u5fd7")
@Controller
@RequestMapping(value={"operationLog"})
public class OperationLogController {
    @Resource
    protected OperationLogService operationLogService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody OperationLog operationLog) {
        this.operationLogService.addObj(operationLog);
        return ResponseResult.success((Object)operationLog.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody OperationLog operationLog) {
        if (StringUtils.isBlank((String)operationLog.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        this.operationLogService.modifyObj(operationLog);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.operationLogService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OperationLog>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> params) {
        PageView pageView = new PageView(pageNo, pageSize);
        OperationLogExample example = new OperationLogExample();
        example.setPageView((PageView<OperationLog>)pageView);
        example.setOrderByClause("create_time DESC");
        OperationLogExample.Criteria criteria = example.createCriteria();
        if (!SpringSecurityUtils.isManagerLoginUser()) {
            criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        if (CollectionUtils.isNotEmpty(params)) {
            CriteriaUtils.addCriterion((Object)criteria, params);
        }
        PageView pageData = this.operationLogService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

