package com.els.base.log.web.controller;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.log.entity.OperationLog;
import com.els.base.log.entity.OperationLogExample;
import com.els.base.log.service.OperationLogService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="操作日志")
@Controller
@RequestMapping("operationLog")
public class OperationLogController {
    @Resource
    protected OperationLogService operationLogService;

    @ApiOperation(httpMethod="POST", value="创建操作日志")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody OperationLog operationLog) {
    	User user = SpringSecurityUtils.getLoginUser();
    	Assert.isNotNull(user, "登录帐号不能为空");
    	
    	operationLog.setUserId(user.getId());
    	operationLog.setUserName(user.getNickName());
    	operationLog.setProjectId(ProjectUtils.getProjectId());
    	operationLog.setCreateTime(new Date());
    	
        this.operationLogService.addObj(operationLog);
        return ResponseResult.success(operationLog.getId());
    }

//    @ApiOperation(httpMethod="POST", value="编辑操作日志")
//    @RequestMapping("service/edit")
//    @ResponseBody
//    public ResponseResult<String> edit(@RequestBody OperationLog operationLog) {
//        if (StringUtils.isBlank(operationLog.getId())) {
//            throw new CommonException("id 为空，保存失败","id_is_blank");
//        }
//        this.operationLogService.modifyObj(operationLog);
//        return ResponseResult.success();
//    }

//    @ApiOperation(httpMethod="POST", value="删除操作日志")
//    @RequestMapping("service/deleteById")
//    @ResponseBody
//    public ResponseResult<String> deleteById(String id) {
//        this.operationLogService.deleteObjById(id);
//        return ResponseResult.success();
//    }

    @ApiOperation(httpMethod="GET", value="查询操作日志")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<OperationLog>> findByPage(
    		@ApiParam(value="所在页",defaultValue="1" ) @RequestParam(defaultValue="1") int pageNo, 
    		@ApiParam(value="每页的数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件") @RequestBody(required=false) List<QueryParam> params) {
        PageView<OperationLog> pageView = new PageView<>(pageNo, pageSize);
        OperationLogExample example = new OperationLogExample();
        example.setPageView(pageView);
        example.setOrderByClause("create_time DESC");
        
        OperationLogExample.Criteria criteria = example.createCriteria();
        if(!SpringSecurityUtils.isManagerLoginUser()){
        	criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        
        if (CollectionUtils.isNotEmpty(params)) {
        	CriteriaUtils.addCriterion(criteria, params);
		}
        
        PageView<OperationLog> pageData = this.operationLogService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}