package com.els.base.log.event.listener;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.els.base.log.entity.OperationLog;
import com.els.base.log.event.OperateOverEvent;
import com.els.base.log.service.OperationLogService;

@Component
public class OperationOverListener implements ApplicationListener<OperateOverEvent>{
	
	@Value("${operation.log.is.enable:true}")
	private String isEnable;

	@Resource
	private OperationLogService operationLogService;
	
	@Override
	public void onApplicationEvent(OperateOverEvent event) {
		if (!Boolean.TRUE.toString().equals(this.isEnable)) {
			return;
		}
		
		OperationLog operationLog = (OperationLog) event.getSource();
		operationLogService.addObj(operationLog);
	}

}
