package com.els.base.log.service;

import java.util.Date;

import javax.annotation.Resource;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.els.base.log.entity.OperationLogExample;

@Component
public class DeleteOperateLogJob {
	
	@Value("${operate.log.expire.days:60}")
	private Integer expireLogsDays;
	
	@Resource
	protected OperationLogService operationLogService;
	
	public void deleteLog(){
		if (expireLogsDays == null) {
			expireLogsDays = 60;
		}
		Date expireDay = DateUtils.addDays(new Date(), -expireLogsDays);
		
		OperationLogExample example = new OperationLogExample();
		example.createCriteria().andCreateTimeLessThanOrEqualTo(expireDay);
		
		this.operationLogService.deleteByExample(example);
	}
	

}
