package com.els.base.log.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.log.dao.OperationLogMapper;
import com.els.base.log.entity.OperationLog;
import com.els.base.log.entity.OperationLogExample;
import com.els.base.log.service.OperationLogService;

@Service("operationLogService")
public class OperationLogServiceImpl implements OperationLogService {
    @Resource
    protected OperationLogMapper operationLogMapper;

    @CacheEvict(value={"operationLog"}, allEntries=true)
    @Override
    public void addObj(OperationLog t) {
    	t.setCreateTime(new Date());
        this.operationLogMapper.insertSelective(t);
    }

    @CacheEvict(value={"operationLog"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.operationLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"operationLog"}, allEntries=true)
    @Override
    public void modifyObj(OperationLog t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.operationLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="operationLog", keyGenerator="redisKeyGenerator")
    @Override
    public OperationLog queryObjById(String id) {
        return this.operationLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="operationLog", keyGenerator="redisKeyGenerator")
    @Override
    public List<OperationLog> queryAllObjByExample(OperationLogExample example) {
        return this.operationLogMapper.selectByExample(example);
    }

    @Cacheable(value="operationLog", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<OperationLog> queryObjByPage(OperationLogExample example) {
        PageView<OperationLog> pageView = example.getPageView();
        pageView.setQueryResult(this.operationLogMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"operationLog"}, allEntries=true)
	@Override
	public void deleteByExample(OperationLogExample example) {
    	Assert.isNotNull(example, "参数不能为空");
    	Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
    	
    	this.operationLogMapper.deleteByExample(example);
	}

    @CacheEvict(value={"operationLog"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<OperationLog> list) {
		if (CollectionUtils.isEmpty(list)) {
			return;
		}
		
		list.forEach(record ->{
			this.operationLogMapper.insertSelective(record);		
		});		
	}
}