package com.els.base.log.event.listener;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

import com.els.base.auth.entity.User;
import com.els.base.log.entity.OperationLog;
import com.els.base.log.event.OperateOverEvent;
import com.els.base.utils.SpringContextHolder;

@Component
public class AuthEventListener implements ApplicationListener<AbstractAuthenticationEvent> {
	
	@Value("${operation.log.is.enable:false}")
	private String operateLogIsEnable;
	
	@Value("${operation.log.login.is.enable:true}")
	private String operateLoginLogIsEnable;

	@Override
	public void onApplicationEvent(AbstractAuthenticationEvent event) {
		if (!Boolean.TRUE.toString().equals(this.operateLogIsEnable)) {
			return;
		}
		
		if (!Boolean.TRUE.toString().equals(this.operateLoginLogIsEnable)) {
			return;
		}
		
		OperationLog operationLog = new OperationLog();
		operationLog.setTarget("登录");
		
		Authentication auth = event.getAuthentication();
		WebAuthenticationDetails detail = (WebAuthenticationDetails) auth.getDetails();
		if (detail != null) {
			operationLog.setOriginIp(detail.getRemoteAddress());
		}

		if (event instanceof InteractiveAuthenticationSuccessEvent 
				|| event instanceof AuthenticationSuccessEvent) {
			Object obj = auth.getPrincipal();
			User user = null;
			if (obj instanceof User) {
				user = (User) obj;
			}
			
			if (user != null) {
				operationLog.setUserId(user.getId());
				operationLog.setUserName(user.getUsername());
			}
			operationLog.setMethod("登录成功");
			operationLog.setResult("操作成功");
			publishEvent(operationLog);
		}else if(event instanceof AbstractAuthenticationFailureEvent){
			operationLog.setUserName(auth.getPrincipal().toString());
			operationLog.setMethod("登录失败");
			operationLog.setResult("操作失败");
			publishEvent(operationLog);
			
		}
		
	}
	
	private void publishEvent(OperationLog operationLog) {
		OperateOverEvent operationLogevent = new OperateOverEvent(operationLog);
		SpringContextHolder.getApplicationContext().publishEvent(operationLogevent);
		
	}

}
