/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.log.event.listener;

import com.els.base.core.entity.user.User;
import com.els.base.log.entity.OperationLog;
import com.els.base.log.event.OperateOverEvent;
import com.els.base.utils.SpringContextHolder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class AuthEventListener
implements ApplicationListener<AbstractAuthenticationEvent> {
    @Value(value="${operation.log.is.enable:false}")
    private String operateLogIsEnable;
    @Value(value="${operation.log.login.is.enable:true}")
    private String operateLoginLogIsEnable;

    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        if (!Boolean.TRUE.toString().equals(this.operateLogIsEnable)) {
            return;
        }
        if (!Boolean.TRUE.toString().equals(this.operateLoginLogIsEnable)) {
            return;
        }
        OperationLog operationLog = new OperationLog();
        operationLog.setTarget("\u767b\u5f55");
        Authentication auth = event.getAuthentication();
        WebAuthenticationDetails detail = (WebAuthenticationDetails)auth.getDetails();
        if (detail != null) {
            operationLog.setOriginIp(detail.getRemoteAddress());
        }
        if (event instanceof InteractiveAuthenticationSuccessEvent || event instanceof AuthenticationSuccessEvent) {
            Object obj = auth.getPrincipal();
            User user = null;
            if (obj instanceof User) {
                user = (User)obj;
            }
            if (user != null) {
                operationLog.setUserId(user.getId());
                operationLog.setUserName(user.getLoginName());
            }
            operationLog.setMethod("\u767b\u5f55\u6210\u529f");
            operationLog.setResult("\u64cd\u4f5c\u6210\u529f");
            this.publishEvent(operationLog);
        } else if (event instanceof AbstractAuthenticationFailureEvent) {
            operationLog.setUserName(auth.getPrincipal().toString());
            operationLog.setMethod("\u767b\u5f55\u5931\u8d25");
            operationLog.setResult("\u64cd\u4f5c\u5931\u8d25");
            this.publishEvent(operationLog);
        }
    }

    private void publishEvent(OperationLog operationLog) {
        OperateOverEvent operationLogevent = new OperateOverEvent(operationLog);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)operationLogevent);
    }
}

