-- ----------------------------
-- 操作记录
-- ----------------------------
-- DROP TABLE "T_BASE_OPERATION_LOG";
CREATE TABLE "T_BASE_OPERATION_LOG" (
  "ID" NVARCHAR2(32) NOT NULL ,
  "PROJECT_ID" NVARCHAR2(32) ,
  "USER_ID" NVARCHAR2(32) ,
  "USER_NAME" NVARCHAR2(255) ,
  "ORIGIN_IP" NVARCHAR2(255) ,
  "ORIGIN_URL" NVARCHAR2(255) ,
  "TARGET" NVARCHAR2(255) ,
  "METHOD" NVARCHAR2(255) ,
  "PARAMS" NCLOB ,
  "RESULT" NCLOB ,
  "CREATE_TIME" DATE DEFAULT sysdate
);

COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."USER_ID" IS '用户id';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."USER_NAME" IS '用户名';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."ORIGIN_IP" IS '用户ip';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."ORIGIN_URL" IS '原始请求';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."TARGET" IS '操作目标';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."METHOD" IS '操作方法';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."PARAMS" IS '操作参数';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."RESULT" IS '操作结果';
COMMENT ON COLUMN "T_BASE_OPERATION_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON TABLE "T_BASE_OPERATION_LOG" IS '操作记录';

ALTER TABLE "T_BASE_OPERATION_LOG" ADD PRIMARY KEY ("ID");









