/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.palette.dao.PaletteDetailedMapper;
import com.els.base.palette.entity.PaletteColor;
import com.els.base.palette.entity.PaletteColorExample;
import com.els.base.palette.entity.PaletteDetailed;
import com.els.base.palette.entity.PaletteDetailedExample;
import com.els.base.palette.entity.PaletteSummary;
import com.els.base.palette.enums.PaletteDetailedStatus;
import com.els.base.palette.enums.PaletteSummaryOrderStatus;
import com.els.base.palette.service.PaletteColorService;
import com.els.base.palette.service.PaletteDetailedService;
import com.els.base.palette.service.PaletteSummaryService;
import com.els.base.palette.web.controller.vo.ConfirmVo;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPaletteDetailedService")
public class PaletteDetailedServiceImpl
implements PaletteDetailedService {
    @Resource
    protected PaletteDetailedMapper paletteDetailedMapper;
    @Resource
    protected PaletteColorService paletteColorService;
    @Resource
    protected PaletteSummaryService paletteSummaryService;
    @Resource
    protected UserService userService;

    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void addObj(PaletteDetailed t) {
        this.paletteDetailedMapper.insertSelective(t);
    }

    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void deleteObjById(String id) {
        this.paletteDetailedMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void modifyObj(PaletteDetailed paletteDetailed) {
        if (StringUtils.isBlank((String)paletteDetailed.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.paletteDetailedMapper.updateByPrimaryKeySelective(paletteDetailed);
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void modifyDetailed(PaletteDetailed paletteDetailed) {
        if (StringUtils.isBlank((String)paletteDetailed.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        ArrayList<PaletteColor> paletteColorList = new ArrayList<PaletteColor>();
        if (paletteDetailed.getUpperLimit() != null && paletteDetailed.getMiddleLimit() != null && paletteDetailed.getLowerLimit() != null) {
            paletteColorList.add(paletteDetailed.getUpperLimit());
            paletteColorList.add(paletteDetailed.getMiddleLimit());
            paletteColorList.add(paletteDetailed.getLowerLimit());
        }
        for (int i = 0; CollectionUtils.isNotEmpty(paletteColorList) && i < paletteColorList.size(); ++i) {
            PaletteColor paletteColor = (PaletteColor)paletteColorList.get(i);
            if (StringUtils.isBlank((String)paletteColor.getId())) {
                this.paletteColorService.addObj(paletteColor);
                continue;
            }
            this.paletteColorService.modifyObj(paletteColor);
        }
        this.paletteDetailedMapper.updateByPrimaryKeySelective(paletteDetailed);
        if (StringUtils.isBlank((String)paletteDetailed.getPaletteCode())) {
            return;
        }
        List<PaletteSummary> paletteSummaries = this.paletteSummaryService.queryListBySapOrderNo(paletteDetailed.getSapOrderNo());
        PaletteSummary paletteSummary = new PaletteSummary();
        paletteSummary.setId(paletteSummaries.get(0).getId());
        paletteSummary.setPaletteCode(paletteDetailed.getPaletteCode());
        paletteSummary.setPaletteEndDate(paletteDetailed.getPaletteEndDate());
        this.paletteSummaryService.modifyObj(paletteSummary);
    }

    public PaletteDetailed queryObjById(String id) {
        return this.paletteDetailedMapper.selectByPrimaryKey(id);
    }

    public List<PaletteDetailed> queryAllObjByExample(PaletteDetailedExample example) {
        return this.paletteDetailedMapper.selectByExample(example);
    }

    public PageView<PaletteDetailed> queryObjByPage(PaletteDetailedExample example) {
        PageView<PaletteDetailed> pageView = example.getPageView();
        List<PaletteDetailed> paletteDetailedColorList = this.paletteDetailedMapper.selectByExampleByPage(example);
        if (CollectionUtils.isNotEmpty(paletteDetailedColorList)) {
            for (PaletteDetailed paletteDetailed : paletteDetailedColorList) {
                paletteDetailed.setUpperLimit(this.queryColorInfo(paletteDetailed.getId(), Constant.NO_INT, paletteDetailed.getIsSendToColor(), "pur"));
                paletteDetailed.setMiddleLimit(this.queryColorInfo(paletteDetailed.getId(), Constant.YES_INT, paletteDetailed.getIsSendToColor(), "pur"));
                paletteDetailed.setLowerLimit(this.queryColorInfo(paletteDetailed.getId(), 2, paletteDetailed.getIsSendToColor(), "pur"));
                if (paletteDetailed.getIsSendToColor() != 0) continue;
                paletteDetailed.setAttachment(null);
                paletteDetailed.setPaletteEndDate(null);
                paletteDetailed.setPaletteCode(null);
            }
        }
        pageView.setQueryResult(paletteDetailedColorList);
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void supCompanyConfirmOrRefuse(ConfirmVo confirmVo, Company company, String senderId) {
        PaletteDetailedExample detailedExample = new PaletteDetailedExample();
        detailedExample.createCriteria().andSapOrderNoEqualTo(confirmVo.getSapOrderNo()).andCompanyIdEqualTo(company.getId());
        List<PaletteDetailed> paletteDetailedList = this.paletteDetailedMapper.selectByExample(detailedExample);
        for (int i = 0; CollectionUtils.isNotEmpty(paletteDetailedList) && i < paletteDetailedList.size(); ++i) {
            PaletteDetailed paletteDetailed = new PaletteDetailed();
            paletteDetailed.setId(paletteDetailedList.get(i).getId());
            String businessTypeCode = null;
            if (confirmVo.getIsConfirm().intValue() == PaletteSummaryOrderStatus.CONFIRMED.getCode()) {
                paletteDetailed.setStatus(PaletteDetailedStatus.COLORING.getValue());
                paletteDetailed.setHeadStatus(PaletteSummaryOrderStatus.CONFIRMED.getCode());
                businessTypeCode = "PALETTE_PUR_CONFIRM";
            } else {
                paletteDetailed.setStatus(confirmVo.getIsConfirm());
                paletteDetailed.setHeadStatus(PaletteSummaryOrderStatus.REFUSED.getCode());
                businessTypeCode = "PALETTE_PUR_NOTCONFIRM";
            }
            this.paletteDetailedMapper.updateByPrimaryKeySelective(paletteDetailed);
            paletteDetailedList.get(i).setCurrentCompanyName(company.getCompanyName());
            String receiverId = paletteDetailedList.get(i).getPurUserId();
            Message message = Message.init((Object)paletteDetailedList.get(i)).setCompanyCode(paletteDetailedList.get(i).getSupplierSrmCode()).setSenderId(senderId).addReceiverId(receiverId).setBusinessTypeCode(businessTypeCode).setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void supSendToColorer(String sapOrderNo, Company company, String senderId) {
        PaletteDetailedExample detailedExample = new PaletteDetailedExample();
        detailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo).andCompanyIdEqualTo(company.getId());
        List<PaletteDetailed> paletteDetailedList = this.paletteDetailedMapper.selectByExample(detailedExample);
        for (int i = 0; CollectionUtils.isNotEmpty(paletteDetailedList) && i < paletteDetailedList.size(); ++i) {
            PaletteDetailed paletteDetailed = new PaletteDetailed();
            paletteDetailed.setId(paletteDetailedList.get(i).getId());
            paletteDetailed.setHeadStatus(PaletteSummaryOrderStatus.SAMPLED.getCode());
            paletteDetailed.setStatus(PaletteDetailedStatus.QUARANTINE.getValue());
            paletteDetailed.setIsSendToColor(Constant.YES_INT);
            this.paletteDetailedMapper.updateByPrimaryKeySelective(paletteDetailed);
            List<PaletteSummary> paletteSummaries = this.paletteSummaryService.queryListBySapOrderNo(sapOrderNo);
            for (int j = 0; CollectionUtils.isNotEmpty(paletteSummaries) && j < paletteSummaries.size(); ++j) {
                Integer submitNum = paletteSummaries.get(0).getSubmitNum();
                if (submitNum == null) {
                    submitNum = 0;
                }
                PaletteSummary paletteSummary = new PaletteSummary();
                paletteSummary.setId(paletteSummaries.get(0).getId());
                paletteSummary.setSubmitNum(submitNum + 1);
                paletteSummary.setOrderStatus(PaletteSummaryOrderStatus.SAMPLED.getCode());
                this.paletteSummaryService.modifyObj(paletteSummary);
            }
            paletteDetailedList.get(i).setCurrentCompanyName(company.getCompanyName());
            String receiverId = paletteDetailedList.get(i).getPurUserId();
            Message message = Message.init((Object)paletteDetailedList.get(i)).setCompanyCode(paletteDetailedList.get(i).getSupplierSrmCode()).setSenderId(senderId).addReceiverId(receiverId).setBusinessTypeCode("PALETTE_SEND_TO_COLOR").setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
            this.paletteDetailedMapper.updateByPrimaryKeySelective(paletteDetailed);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void colorerConfirmOrRefuse(List<ConfirmVo> confirmList, Company company, com.els.base.auth.entity.User user) {
        for (ConfirmVo confirmVo : confirmList) {
            PaletteDetailed detailed = this.queryListBySapOrderNo(confirmVo.getSapOrderNo()).get(0);
            if (detailed == null || !detailed.getHeadStatus().equals(PaletteSummaryOrderStatus.SAMPLED.getCode())) {
                throw new CommonException("\u53ea\u6709\u72b6\u6001\u4e3a\u5df2\u9001\u6837\u7684\u8ba2\u5355\u624d\u80fd\u8ba4\u5b9a\u6216\u9a73\u56de");
            }
            PaletteDetailed paletteDetailed = new PaletteDetailed();
            paletteDetailed.setId(detailed.getId());
            if (confirmVo.getIsConfirm().equals(PaletteSummaryOrderStatus.COGNIZANCED.getCode())) {
                paletteDetailed.setStatus(PaletteDetailedStatus.COGNIGANCE.getValue());
                paletteDetailed.setHeadStatus(PaletteSummaryOrderStatus.COGNIZANCED.getCode());
            } else {
                paletteDetailed.setStatus(PaletteDetailedStatus.NOTCOGNIGANCE.getValue());
                paletteDetailed.setHeadStatus(PaletteSummaryOrderStatus.REJECTED.getCode());
            }
            this.paletteDetailedMapper.updateByPrimaryKeySelective(paletteDetailed);
            List<PaletteSummary> paletteSummaryList = this.paletteSummaryService.queryListBySapOrderNo(confirmVo.getSapOrderNo());
            for (int i = 0; CollectionUtils.isNotEmpty(paletteSummaryList) && i < paletteSummaryList.size(); ++i) {
                PaletteSummary paletteSummary = new PaletteSummary();
                paletteSummary.setId(paletteSummaryList.get(0).getId());
                paletteSummary.setFirmlyTime(new Date());
                paletteSummary.setOrderStatus(confirmVo.getIsConfirm());
                paletteSummary.setConfirmRefusePerson(user.getNickName());
                if (StringUtils.isNotBlank((String)confirmVo.getRemark())) {
                    paletteSummary.setRejectReason(confirmVo.getRemark());
                }
                this.paletteSummaryService.modifyObj(paletteSummary);
            }
            User purchaser = this.userService.findByUserLoginName(detailed.getSupplierSrmCode());
            detailed.setCurrentCompanyName(company.getCompanyName());
            Message message = Message.init((Object)detailed).setCompanyCode(detailed.getSupplierSrmCode()).setSenderId(user.getId()).addReceiverId(purchaser.getId()).setBusinessTypeCode("PALETTE_SUP_AFFIRME").setMsgLevel(MessageLevelEnum.HIGH);
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Override
    public PageView<PaletteDetailed> queryObjByPageForSup(PaletteDetailedExample example) {
        PageView<PaletteDetailed> pageView = example.getPageView();
        List<PaletteDetailed> paletteDetailedColorList = this.paletteDetailedMapper.selectByExampleByPage(example);
        if (CollectionUtils.isNotEmpty(paletteDetailedColorList)) {
            for (PaletteDetailed paletteDetailed : paletteDetailedColorList) {
                paletteDetailed.setUpperLimit(this.queryColorInfo(paletteDetailed.getId(), Constant.NO_INT, paletteDetailed.getIsSendToColor(), "sup"));
                paletteDetailed.setMiddleLimit(this.queryColorInfo(paletteDetailed.getId(), Constant.YES_INT, paletteDetailed.getIsSendToColor(), "sup"));
                paletteDetailed.setLowerLimit(this.queryColorInfo(paletteDetailed.getId(), 2, paletteDetailed.getIsSendToColor(), "sup"));
            }
        }
        pageView.setQueryResult(paletteDetailedColorList);
        return pageView;
    }

    public PaletteColor queryColorInfo(String id, Integer constant, Integer isSendToColor, String person) {
        Iterator iterator;
        if (isSendToColor == null) {
            isSendToColor = 0;
        }
        PaletteColorExample colorExample = new PaletteColorExample();
        colorExample.createCriteria().andPaletteDetailedIdEqualTo(id).andColorTypeEqualTo(constant);
        List queryAllObjByExample = this.paletteColorService.queryAllObjByExample((IExample)colorExample);
        if ((isSendToColor == 1 || person.equals("sup")) && CollectionUtils.isNotEmpty((Collection)queryAllObjByExample)) {
            return (PaletteColor)queryAllObjByExample.get(0);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryAllObjByExample) && (iterator = queryAllObjByExample.iterator()).hasNext()) {
            PaletteColor paletteColor = (PaletteColor)iterator.next();
            paletteColor.setDa(null);
            paletteColor.setDb(null);
            paletteColor.setDe(null);
            paletteColor.setDl(null);
            paletteColor.setCmc(null);
            return paletteColor;
        }
        return null;
    }

    @Override
    public void judgeIsColorStatus(List<String> sapOrderNoList, String currentCompanyId) {
        for (String sapOrderNo : sapOrderNoList) {
            PaletteDetailedExample detailedExample = new PaletteDetailedExample();
            detailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo).andCompanyIdEqualTo(currentCompanyId);
            List<PaletteDetailed> paletteDetailedList = this.paletteDetailedMapper.selectByExample(detailedExample);
            List<PaletteSummary> paletteSummaries = this.paletteSummaryService.queryListBySapOrderNo(sapOrderNo);
            paletteSummaries.forEach(paletteSummary -> {
                if (!paletteSummary.getOrderStatus().equals(PaletteSummaryOrderStatus.CONFIRMED.getCode()) && !paletteSummary.getOrderStatus().equals(PaletteSummaryOrderStatus.REJECTED.getCode())) {
                    throw new CommonException("\u542b\u4e0d\u53ef\u53d1\u9001\u7684\u6570\u636e\uff08\u53ea\u6709\u5934\u72b6\u6001\u4e3a\u5df2\u63a5\u6536\u6216\u5df2\u9a73\u56de\u7684\u6570\u636e\u624d\u80fd\u53d1\u9001\uff01\uff09");
                }
            });
            for (int i = 0; CollectionUtils.isNotEmpty(paletteDetailedList) && i < paletteDetailedList.size(); ++i) {
                PaletteColorExample colorExample = new PaletteColorExample();
                colorExample.createCriteria().andPaletteDetailedIdEqualTo(paletteDetailedList.get(i).getId());
                List paletteColorList = this.paletteColorService.queryAllObjByExample((IExample)colorExample);
                for (int j = 0; CollectionUtils.isNotEmpty((Collection)paletteColorList) && j < paletteColorList.size(); ++j) {
                    if (!StringUtils.isBlank((String)((PaletteColor)paletteColorList.get(i)).getDl()) && !StringUtils.isBlank((String)((PaletteColor)paletteColorList.get(i)).getDa()) && !StringUtils.isBlank((String)((PaletteColor)paletteColorList.get(i)).getDb()) && !StringUtils.isBlank((String)((PaletteColor)paletteColorList.get(i)).getDe())) continue;
                    throw new CommonException("\u4e09\u8272\u8272\u5dee\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4e09\u8272\u8272\u5dee\u5185\u5bb9"});
                }
                if (paletteDetailedList.get(i).getAttachment() != null) continue;
                throw new CommonException("\u6cb9\u6f06\u7269\u6027\u6d4b\u8bd5\u62a5\u544a\u9644\u4ef6", "base_canot_be_null", new Object[]{"\u6cb9\u6f06\u7269\u6027\u6d4b\u8bd5\u62a5\u544a\u9644\u4ef6"});
            }
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void findExpiredPalette() {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = LocalDate.now().minusDays(1L);
        Date date = Date.from(localDate.atStartOfDay(zoneId).toInstant());
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(PaletteSummaryOrderStatus.SAMPLED.getCode());
        statusList.add(PaletteSummaryOrderStatus.COGNIZANCED.getCode());
        PaletteDetailedExample tempPaletteDetailedExample = new PaletteDetailedExample();
        tempPaletteDetailedExample.createCriteria().andPaletteEndDateLessThanOrEqualTo(date).andHeadStatusIn(statusList);
        List<PaletteDetailed> tempPaletteDetaileds = this.paletteDetailedMapper.selectByExample(tempPaletteDetailedExample);
        if (CollectionUtils.isNotEmpty(tempPaletteDetaileds)) {
            for (PaletteDetailed tempPaletteDetailed : tempPaletteDetaileds) {
                List<PaletteSummary> paletteSummaries = this.paletteSummaryService.queryListBySapOrderNo(tempPaletteDetailed.getSapOrderNo());
                PaletteSummary paletteSummary = new PaletteSummary();
                paletteSummary.setId(paletteSummaries.get(0).getId());
                paletteSummary.setOrderStatus(PaletteSummaryOrderStatus.EXPIRED.getCode());
                this.paletteSummaryService.modifyObj(paletteSummary);
            }
        }
        LocalDate thiryDaysAgo = LocalDate.now().plusDays(31L);
        Date thiryDaysAgoDate = Date.from(thiryDaysAgo.atStartOfDay(zoneId).toInstant());
        ArrayList<Integer> tempStatusList = new ArrayList<Integer>();
        tempStatusList.add(PaletteSummaryOrderStatus.SAMPLED.getCode());
        tempStatusList.add(PaletteSummaryOrderStatus.COGNIZANCED.getCode());
        tempStatusList.add(PaletteSummaryOrderStatus.EXPIRED.getCode());
        PaletteDetailedExample paletteDetailedExample = new PaletteDetailedExample();
        paletteDetailedExample.createCriteria().andPaletteEndDateEqualTo(thiryDaysAgoDate).andHeadStatusIn(tempStatusList);
        List<PaletteDetailed> paletteDetaileds = this.paletteDetailedMapper.selectByExample(paletteDetailedExample);
        if (CollectionUtils.isNotEmpty(paletteDetaileds)) {
            for (PaletteDetailed paletteDetailed : paletteDetaileds) {
                List<PaletteSummary> paletteSummaries = this.paletteSummaryService.queryListBySapOrderNo(paletteDetailed.getSapOrderNo());
                String createPersonName = paletteSummaries.get(0).getCreatePerson();
                UserExample userExample = new UserExample();
                userExample.createCriteria().andNickNameEqualTo(createPersonName);
                User createPerson = (User)this.userService.queryAllObjByExample((IExample)userExample).get(0);
                Message message = Message.init((Object)paletteDetailed).setCompanyCode(paletteDetailed.getSupplierSrmCode()).addReceiverId(createPerson.getId()).setBusinessTypeCode("PALETTE_CODE_EXPIRED").setMsgLevel(MessageLevelEnum.HIGH);
                MessageSendUtils.sendMessage((Message)message);
            }
        }
    }

    @Override
    public List<PaletteDetailed> queryListBySapOrderNo(String sapOrderNo) {
        PaletteDetailedExample paletteDetailedExample = new PaletteDetailedExample();
        paletteDetailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo);
        List<PaletteDetailed> paletteDetaileds = this.paletteDetailedMapper.selectByExample(paletteDetailedExample);
        return paletteDetaileds;
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteDetailed"}, allEntries=true)
    public void purExpiredDate(ConfirmVo confirmVo) {
        List<PaletteDetailed> paletteDetaileds = this.queryListBySapOrderNo(confirmVo.getSapOrderNo());
        if (CollectionUtils.isEmpty(paletteDetaileds)) {
            throw new CommonException("\u65e0\u6cd5\u67e5\u8be2\u5bf9\u5e94\u5355\u636e");
        }
        PaletteDetailed paletteDetailed = this.queryObjById(paletteDetaileds.get(0).getId());
        paletteDetailed.setPaletteEndDate(confirmVo.getPaletteEndDate());
        this.paletteDetailedMapper.updateByPrimaryKeySelective(paletteDetailed);
        List<PaletteSummary> paletteSummaries = this.paletteSummaryService.queryListBySapOrderNo(confirmVo.getSapOrderNo());
        PaletteSummary paletteSummary = new PaletteSummary();
        paletteSummary.setId(paletteSummaries.get(0).getId());
        paletteSummary.setPaletteEndDate(confirmVo.getPaletteEndDate());
        paletteSummary.setOrderStatus(paletteDetailed.getHeadStatus());
        this.paletteSummaryService.modifyObj(paletteSummary);
    }
}

