/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.palette.entity.PlasticDetailed;
import com.els.base.palette.entity.PlasticDetailedExample;
import com.els.base.palette.entity.PlasticSummary;
import com.els.base.palette.entity.PlasticSummaryExample;
import com.els.base.palette.enums.PaletteDetailedStatus;
import com.els.base.palette.service.PlasticDetailedService;
import com.els.base.palette.service.PlasticSummaryService;
import com.els.base.palette.web.controller.vo.ConfirmVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5851\u80f6\u4ef6\u6253\u6837\u6c47\u603b")
@Controller
@RequestMapping(value={"plasticSummary"})
public class PlasticSummaryController {
    @Resource
    protected PlasticSummaryService plasticSummaryService;
    @Resource
    private PlasticDetailedService plasticDetailedService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5851\u80f6\u4ef6\u6253\u6837\u6c47\u603b")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PlasticSummary plasticSummary) {
        this.plasticSummaryService.addObj(plasticSummary);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5851\u80f6\u4ef6\u6253\u6837\u6c47\u603b")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PlasticSummary plasticSummary) {
        if (StringUtils.isBlank((String)plasticSummary.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.plasticSummaryService.modifyObj(plasticSummary);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5851\u80f6\u4ef6\u6253\u6837\u6c47\u603b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.plasticSummaryService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5851\u80f6\u4ef6\u6253\u6837\u6c47\u603b--\u91c7\u8d2d\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PlasticSummary", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<PlasticSummary>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PlasticSummaryExample example = new PlasticSummaryExample();
        example.setPageView((PageView<PlasticSummary>)new PageView(pageNo, pageSize));
        PlasticSummaryExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.plasticSummaryService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5851\u80f6\u4ef6\u6253\u6837\u6c47\u603b--\u4f9b\u5e94\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PlasticSummary", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<PlasticSummary>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List plasticDetailedList;
        String[] split = null;
        QueryParam confirgStatus = null;
        for (int i = 0; wapper != null && CollectionUtils.isNotEmpty((Collection)wapper.getQueryParams()) && i < wapper.getQueryParams().size(); ++i) {
            if (!((QueryParam)wapper.getQueryParams().get(i)).getProperty().equals("confirmStatus")) continue;
            confirgStatus = (QueryParam)wapper.getQueryParams().get(i);
            String[] value = confirgStatus.getValue();
            String b = value.replaceAll("[\\[\\]]", "");
            split = b.split(",");
            break;
        }
        if (confirgStatus != null) {
            wapper.getQueryParams().remove(confirgStatus);
        }
        ArrayList<Integer> detailedStatus = new ArrayList<Integer>();
        if (split != null) {
            for (void var10_13 : split) {
                if (var10_13.equals("1")) {
                    detailedStatus.add(PaletteDetailedStatus.UNCOMFIRMED.getValue());
                    continue;
                }
                if (var10_13.equals("2")) {
                    detailedStatus.add(PaletteDetailedStatus.COMFIRMED.getValue());
                    continue;
                }
                if (!var10_13.equals("3")) continue;
                detailedStatus.add(PaletteDetailedStatus.SUPNOTCOMFIRMED.getValue());
            }
        }
        PlasticDetailedExample plasticDetailedExample = new PlasticDetailedExample();
        PlasticDetailedExample.Criteria detaCriteria = plasticDetailedExample.createCriteria();
        detaCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsSendToSupEqualTo(Constant.YES_INT);
        if (CollectionUtils.isNotEmpty(detailedStatus)) {
            detaCriteria.andStatusIn(detailedStatus);
        }
        if (CollectionUtils.isEmpty((Collection)(plasticDetailedList = this.plasticDetailedService.queryAllObjByExample((IExample)plasticDetailedExample)))) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PlasticDetailed plasticDetailed : plasticDetailedList) {
            arrayList.add(plasticDetailed.getSapOrderNo());
        }
        PlasticSummaryExample psExample = new PlasticSummaryExample();
        PlasticSummaryExample.Criteria psCriteria = psExample.createCriteria();
        psCriteria.andSapOrderNoIn(arrayList);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)psExample, (QueryParamWapper)wapper);
        }
        PageView pageView = new PageView(pageNo, pageSize);
        psExample.setPageView((PageView<PlasticSummary>)pageView);
        pageView = this.plasticSummaryService.queryObjByPage((IExample)psExample);
        for (PlasticSummary plasticSummary : pageView.getQueryResult()) {
            List<PlasticDetailed> detailedList = plasticSummary.getPlasticDetailedList();
            for (PlasticDetailed plasticDetailed : plasticDetailedList) {
                if (!plasticSummary.getSapOrderNo().equals(plasticDetailed.getSapOrderNo())) continue;
                detailedList.add(plasticDetailed);
            }
        }
        return ResponseResult.success((Object)pageView);
    }

    @ApiOperation(httpMethod="POST", value="\u4ecePLM\u7cfb\u7edf\u5bfc\u5165\u5851\u80f6\u4ef6\u6253\u6837\u6570\u636e")
    @RequestMapping(value={"front/plasticSummary/importFromPlm/{accessToken}"})
    @ResponseBody
    public ResponseResult<String> importFromPlm(@PathVariable(value="accessToken") String accessToken, @RequestBody List<PlasticSummary> list) {
        this.plasticSummaryService.importFromPlm(list, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5851\u80f6\u4ef6\u6253\u6837\u5355\u636e")
    @RequestMapping(value={"service/addBuild"})
    @ResponseBody
    public ResponseResult<String> addBuild(@RequestBody List<PlasticSummary> list) {
        this.plasticSummaryService.importFromPlm(list, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5851\u80f6\u4ef6\u6253\u6837\u6279\u91cf\u53d1\u9001")
    @RequestMapping(value={"service/purSendToSupCompany"})
    @ResponseBody
    public ResponseResult<String> purSendToSupCompany(@RequestBody List<PlasticSummary> plasticSummaryList) {
        if (CollectionUtils.isEmpty(plasticSummaryList)) {
            throw new CommonException("plasticSummaryList data can not be null");
        }
        Company currentCompany = CompanyUtils.currentCompany();
        this.plasticSummaryService.purSendToSupCompany(plasticSummaryList, currentCompany, SpringSecurityUtils.getLoginUserId());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5851\u80f6\u4ef6\u6253\u6837\u4f9b\u5e94\u5546\u6279\u91cf\u786e\u8ba4\u6216\u62d2\u7edd(\u786e\u8ba4\uff1a2 \u62d2\u7edd\uff1a3)")
    @RequestMapping(value={"service/supCompanyConfirmOrRefuse"})
    @ResponseBody
    public ResponseResult<String> supCompanyConfirmOrRefuse(@RequestBody List<ConfirmVo> confirmList) {
        if (CollectionUtils.isEmpty(confirmList)) {
            throw new CommonException("data can not be null");
        }
        this.plasticDetailedService.judgeIsConfirmStatus(confirmList, CompanyUtils.currentCompanyId());
        for (ConfirmVo confirmVo : confirmList) {
            if (confirmVo.getIsConfirm().intValue() == PaletteDetailedStatus.COMFIRMED.getValue()) {
                this.plasticDetailedService.supCompanyConfirmOrRefuse(confirmVo.getSapOrderNo(), confirmVo.getIsConfirm(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUserId());
            } else if (confirmVo.getIsConfirm().intValue() == PaletteDetailedStatus.SUPNOTCOMFIRMED.getValue()) {
                this.plasticDetailedService.supCompanyConfirmOrRefuse(confirmVo.getSapOrderNo(), confirmVo.getIsConfirm(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUserId());
            }
            this.plasticSummaryService.changeHeadStatus(confirmVo.getSapOrderNo());
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5851\u80f6\u4ef6\u6253\u6837\u4f9b\u5e94\u5546\u53d1\u9001\u81f3\u7f8e\u5de5")
    @RequestMapping(value={"service/supSendToColorer"})
    @ResponseBody
    public ResponseResult<String> supSendToColorer(@RequestBody List<String> sapOrderNoList) {
        if (CollectionUtils.isNotEmpty(sapOrderNoList)) {
            this.plasticDetailedService.judgeIsColorStatus(sapOrderNoList, CompanyUtils.currentCompanyId());
            for (String sapOrderNo : sapOrderNoList) {
                this.plasticDetailedService.supSendToColorer(sapOrderNo, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUserId());
                this.plasticSummaryService.changeHeadStatus(sapOrderNo);
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f8e\u5de5\u6279\u91cf\u8ba4\u5b9a\u4f9b\u5e94\u5546(\u786e\u8ba4\uff1a2 \u62d2\u7edd\uff1a3)")
    @RequestMapping(value={"service/colorerConfirmOrRefuse"})
    @ResponseBody
    public ResponseResult<String> colorerConfirmOrRefuse(@RequestBody List<ConfirmVo> confirmList) {
        if (CollectionUtils.isEmpty(confirmList)) {
            throw new CommonException("data can not be null");
        }
        this.plasticDetailedService.colorerConfirmOrRefuse(confirmList, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUserId());
        return ResponseResult.success();
    }
}

