/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.palette.dao.PaletteColorMapper;
import com.els.base.palette.entity.PaletteColor;
import com.els.base.palette.entity.PaletteColorExample;
import com.els.base.palette.service.PaletteColorService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultPaletteColorService")
public class PaletteColorServiceImpl
implements PaletteColorService {
    @Resource
    protected PaletteColorMapper paletteColorMapper;

    @CacheEvict(value={"paletteColor"}, allEntries=true)
    public void addObj(PaletteColor t) {
        this.paletteColorMapper.insertSelective(t);
    }

    @CacheEvict(value={"paletteColor"}, allEntries=true)
    public void deleteObjById(String id) {
        this.paletteColorMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"paletteColor"}, allEntries=true)
    public void modifyObj(PaletteColor t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.paletteColorMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"paletteColor"}, keyGenerator="redisKeyGenerator")
    public PaletteColor queryObjById(String id) {
        return this.paletteColorMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"paletteColor"}, keyGenerator="redisKeyGenerator")
    public List<PaletteColor> queryAllObjByExample(PaletteColorExample example) {
        return this.paletteColorMapper.selectByExample(example);
    }

    @Cacheable(value={"paletteColor"}, keyGenerator="redisKeyGenerator")
    public PageView<PaletteColor> queryObjByPage(PaletteColorExample example) {
        PageView<PaletteColor> pageView = example.getPageView();
        pageView.setQueryResult(this.paletteColorMapper.selectByExampleByPage(example));
        return pageView;
    }
}

