/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.palette.dao.PaletteSummaryMapper;
import com.els.base.palette.entity.PaletteColor;
import com.els.base.palette.entity.PaletteDetailed;
import com.els.base.palette.entity.PaletteDetailedExample;
import com.els.base.palette.entity.PaletteSummary;
import com.els.base.palette.entity.PaletteSummaryExample;
import com.els.base.palette.enums.PaletteDetailedStatus;
import com.els.base.palette.enums.PaletteSummaryOrderStatus;
import com.els.base.palette.service.PaletteColorService;
import com.els.base.palette.service.PaletteDetailedService;
import com.els.base.palette.service.PaletteSummaryService;
import com.els.base.palette.web.controller.vo.ConfirmVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPaletteSummaryService")
public class PaletteSummaryServiceImpl
implements PaletteSummaryService {
    @Resource
    protected PaletteSummaryMapper paletteSummaryMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected PaletteDetailedService paletteDetailedService;
    @Resource
    protected PaletteColorService paletteColorService;

    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void addObj(PaletteSummary t) {
        this.paletteSummaryMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void deleteObjById(String id) {
        PaletteSummary paletteSummary = this.paletteSummaryMapper.selectByPrimaryKey(id);
        if (!paletteSummary.getOrderStatus().equals(PaletteSummaryOrderStatus.UNPUBLISH.getCode())) {
            throw new CommonException("\u53ea\u6709\u672a\u53d1\u5e03\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664");
        }
        PaletteSummary tempPaletteSummary = this.queryObjById(id);
        List<PaletteDetailed> paletteDetaileds = this.paletteDetailedService.queryListBySapOrderNo(tempPaletteSummary.getSapOrderNo());
        this.paletteDetailedService.deleteObjById(paletteDetaileds.get(0).getId());
        this.paletteSummaryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void modifyObj(PaletteSummary t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.paletteSummaryMapper.updateByPrimaryKeySelective(t);
    }

    public PaletteSummary queryObjById(String id) {
        return this.paletteSummaryMapper.selectByPrimaryKey(id);
    }

    public List<PaletteSummary> queryAllObjByExample(PaletteSummaryExample example) {
        return this.paletteSummaryMapper.selectByExample(example);
    }

    public PageView<PaletteSummary> queryObjByPage(PaletteSummaryExample example) {
        PageView<PaletteSummary> pageView = example.getPageView();
        List<PaletteSummary> selectByExampleByPage = this.paletteSummaryMapper.selectByExampleByPage(example);
        pageView.setQueryResult(selectByExampleByPage);
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void importFromPlm(List<PaletteSummary> list, com.els.base.auth.entity.User user) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        for (PaletteSummary paletteSummary : list) {
            String sapOrderNo = this.generateCodeService.getNextCode("PALETTE_ORDER_NO");
            paletteSummary.setSapOrderNo(sapOrderNo);
            paletteSummary.setCreatePerson(user.getNickName());
            paletteSummary.setCreateTime(new Date());
            paletteSummary.setSapCreateTime(new Date());
            paletteSummary.setOrderStatus(PaletteSummaryOrderStatus.UNPUBLISH.getCode());
            paletteSummary.setIsSendToSup(Constant.NO_INT);
            paletteSummary.setSubmitNum(0);
            CompanyExample companyExample = new CompanyExample();
            companyExample.createCriteria().andCompanyCodeEqualTo(paletteSummary.getSupplierSrmCode());
            List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
            Company company = (Company)companyList.get(0);
            paletteSummary.setSupplierSapCode(company.getCompanySapCode());
            paletteSummary.setSupCompanyName(company.getCompanyName());
            this.paletteSummaryMapper.insert(paletteSummary);
            PaletteDetailed paletteDetailed = new PaletteDetailed();
            paletteDetailed.setCompanyId(company.getId());
            paletteDetailed.setStatus(PaletteDetailedStatus.UNSEND.getValue());
            paletteDetailed.setHeadStatus(paletteSummary.getOrderStatus());
            paletteDetailed.setSapOrderNo(paletteSummary.getSapOrderNo());
            paletteDetailed.setSupplierSapCode(company.getCompanySapCode());
            paletteDetailed.setSupplierSrmCode(company.getCompanyCode());
            paletteDetailed.setSupplierName(company.getCompanyName());
            paletteDetailed.setSupplierAddress(company.getAddress());
            paletteDetailed.setIsSendToColor(Constant.NO_INT);
            paletteDetailed.setIsSendToSup(Constant.NO_INT);
            paletteDetailed.setContacts(company.getContacts());
            paletteDetailed.setPhoneNumber(company.getTelephone());
            this.paletteDetailedService.addObj(paletteDetailed);
            this.insertColorInfo(paletteSummary.getSapOrderNo());
        }
    }

    private void insertColorInfo(String sapOrderNo) {
        List<PaletteDetailed> paletteDetailedList = this.paletteDetailedService.queryListBySapOrderNo(sapOrderNo);
        for (int i = 0; CollectionUtils.isNotEmpty(paletteDetailedList) && i < paletteDetailedList.size(); ++i) {
            String id = paletteDetailedList.get(i).getId();
            PaletteColor paletteColor = new PaletteColor();
            paletteColor.setPaletteDetailedId(id);
            paletteColor.setColorType(0);
            this.paletteColorService.addObj(paletteColor);
            paletteColor.setId(null);
            paletteColor.setColorType(1);
            this.paletteColorService.addObj(paletteColor);
            paletteColor.setId(null);
            paletteColor.setColorType(2);
            this.paletteColorService.addObj(paletteColor);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void purSendToSupCompany(PaletteSummary paletteSummary, Company company, String purUserId) {
        List<PaletteDetailed> paletteDetailedList = this.paletteDetailedService.queryListBySapOrderNo(paletteSummary.getSapOrderNo());
        for (int i = 0; CollectionUtils.isNotEmpty(paletteDetailedList) && i < paletteDetailedList.size(); ++i) {
            PaletteDetailed paletteDetailed = new PaletteDetailed();
            paletteDetailed.setId(paletteDetailedList.get(i).getId());
            paletteDetailed.setPurUserId(purUserId);
            paletteDetailed.setStatus(PaletteDetailedStatus.UNCOMFIRMED.getValue());
            paletteDetailed.setHeadStatus(PaletteSummaryOrderStatus.PUBLISHED.getCode());
            paletteDetailed.setIsSendToSup(Constant.YES_INT);
            paletteDetailed.setSapOrderNo(paletteDetailedList.get(i).getSapOrderNo());
            this.paletteDetailedService.modifyObj(paletteDetailed);
            User supplier = this.userService.findByUserLoginName(paletteDetailedList.get(i).getSupplierSrmCode());
            paletteSummary.setCurrentCompanyName(company.getCompanyName());
            Message message = new Message(paletteDetailedList.get(i).getSupplierSrmCode(), purUserId, supplier.getId(), "PALETTE_SEND", MessageLevelEnum.HIGH, (Object)paletteSummary);
            MessageSendUtils.sendMessage((Message)message);
        }
        PaletteSummary palette = new PaletteSummary();
        palette.setId(paletteSummary.getId());
        palette.setIsSendToSup(Constant.YES_INT);
        palette.setOrderStatus(PaletteSummaryOrderStatus.PUBLISHED.getCode());
        this.paletteSummaryMapper.updateByPrimaryKeySelective(palette);
    }

    @Override
    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void changeHeadStatus(ConfirmVo confirmVo) {
        List<PaletteSummary> selectByExample = this.queryListBySapOrderNo(confirmVo.getSapOrderNo());
        if (CollectionUtils.isEmpty(selectByExample)) {
            return;
        }
        PaletteSummary paletteSummary = new PaletteSummary();
        paletteSummary.setId(selectByExample.get(0).getId());
        paletteSummary.setOrderStatus(confirmVo.getIsConfirm());
        if (StringUtils.isNotBlank((String)confirmVo.getRemark())) {
            paletteSummary.setRefuseReason(confirmVo.getRemark());
        }
        this.paletteSummaryMapper.updateByPrimaryKeySelective(paletteSummary);
    }

    @Override
    public String getDetailedStatus(String sapOrderNo, String currentCompanyId) {
        PaletteDetailedExample detailedExample = new PaletteDetailedExample();
        detailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo).andCompanyIdEqualTo(currentCompanyId);
        List paletteDetailedList = this.paletteDetailedService.queryAllObjByExample((IExample)detailedExample);
        String status = null;
        if (CollectionUtils.isNotEmpty((Collection)paletteDetailedList)) {
            for (PaletteDetailed paletteDetailed : paletteDetailedList) {
                Integer integer = paletteDetailed.getStatus();
                if (integer == 1) {
                    status = "1";
                    continue;
                }
                if (integer == 3) {
                    status = "3";
                    continue;
                }
                status = "2";
            }
        }
        return status;
    }

    @Override
    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void purSetUseModule(ConfirmVo confirmVo) {
        List<PaletteSummary> paletteSummaries = this.queryListBySapOrderNo(confirmVo.getSapOrderNo());
        if (CollectionUtils.isEmpty(paletteSummaries)) {
            throw new CommonException("\u5355\u636e\u53f7\u9519\u8bef");
        }
        PaletteSummary paletteSummary = new PaletteSummary();
        paletteSummary.setId(paletteSummaries.get(0).getId());
        paletteSummary.setUseModule(confirmVo.getUseModule());
        this.paletteSummaryMapper.updateByPrimaryKeySelective(paletteSummary);
    }

    @Override
    @Transactional
    @CacheEvict(value={"paletteSummary"}, allEntries=true)
    public void purExpiredOrder(String id) {
        PaletteSummary paletteSummary = this.paletteSummaryMapper.selectByPrimaryKey(id);
        if (paletteSummary.getOrderStatus().equals(PaletteSummaryOrderStatus.UNPUBLISH.getCode()) || paletteSummary.getOrderStatus().equals(PaletteSummaryOrderStatus.OBSOLETED.getCode())) {
            throw new CommonException("\u53ea\u6709\u5df2\u53d1\u5e03\u7ed9\u4f9b\u5e94\u5546\u540e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u4f5c\u5e9f");
        }
        paletteSummary.setOrderStatus(PaletteSummaryOrderStatus.OBSOLETED.getCode());
        this.paletteSummaryMapper.updateByPrimaryKeySelective(paletteSummary);
        List<PaletteDetailed> paletteDetaileds = this.paletteDetailedService.queryListBySapOrderNo(paletteSummary.getSapOrderNo());
        PaletteDetailed paletteDetailed = new PaletteDetailed();
        paletteDetailed.setId(paletteDetaileds.get(0).getId());
        paletteDetailed.setHeadStatus(paletteSummary.getOrderStatus());
        this.paletteDetailedService.modifyObj(paletteDetailed);
    }

    @Override
    public void judgeIsConfirmStatus(List<ConfirmVo> confirmList) {
        for (ConfirmVo confirmVo : confirmList) {
            List<PaletteSummary> paletteSummaries = this.queryListBySapOrderNo(confirmVo.getSapOrderNo());
            paletteSummaries.forEach(paletteSummary -> {
                if (!paletteSummary.getOrderStatus().equals(PaletteSummaryOrderStatus.PUBLISHED.getCode()) && !paletteSummary.getOrderStatus().equals(PaletteSummaryOrderStatus.REJECTED.getCode())) {
                    throw new CommonException("\u542b\u4e0d\u53ef\u786e\u8ba4\u6216\u62d2\u7edd\u7684\u6570\u636e\uff08\u53ea\u6709\u5934\u72b6\u6001\u4e3a\u201c\u5df2\u53d1\u5e03\u201d\u7684\u6570\u636e\u624d\u80fd\u786e\u8ba4\u6216\u62d2\u7edd\uff01\uff09");
                }
            });
        }
    }

    @Override
    public List<PaletteSummary> queryListBySapOrderNo(String sapOrderNo) {
        PaletteSummaryExample paletteSummaryExample = new PaletteSummaryExample();
        paletteSummaryExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo);
        List<PaletteSummary> paletteSummaries = this.paletteSummaryMapper.selectByExample(paletteSummaryExample);
        return paletteSummaries;
    }

    @Override
    public PageView<PaletteSummary> findByPageForPur(PaletteSummaryExample example) {
        PageView<PaletteSummary> pageView = example.getPageView();
        List<PaletteSummary> selectByExampleByPage = this.paletteSummaryMapper.selectByExampleByPage(example);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(PaletteSummaryOrderStatus.CONFIRMED.getCode());
        statusList.add(PaletteSummaryOrderStatus.REFUSED.getCode());
        for (PaletteSummary paletteSummary : selectByExampleByPage) {
            if (!statusList.contains(paletteSummary.getOrderStatus())) continue;
            paletteSummary.setPaletteEndDate(null);
            paletteSummary.setPaletteCode(null);
        }
        pageView.setQueryResult(selectByExampleByPage);
        return pageView;
    }
}

