/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.palette.dao.PlasticDetailedMapper;
import com.els.base.palette.entity.PlasticDetailed;
import com.els.base.palette.entity.PlasticDetailedExample;
import com.els.base.palette.entity.PlasticSummary;
import com.els.base.palette.entity.PlasticSummaryExample;
import com.els.base.palette.enums.PaletteDetailedStatus;
import com.els.base.palette.service.PlasticDetailedService;
import com.els.base.palette.service.PlasticSummaryService;
import com.els.base.palette.web.controller.vo.ConfirmVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultPlasticDetailedService")
public class PlasticDetailedServiceImpl
implements PlasticDetailedService {
    @Resource
    protected PlasticDetailedMapper plasticDetailedMapper;
    @Resource
    protected PlasticSummaryService plasticSummaryService;
    @Resource
    protected UserService userService;

    @CacheEvict(value={"plasticDetailed"}, allEntries=true)
    public void addObj(PlasticDetailed t) {
        this.plasticDetailedMapper.insertSelective(t);
    }

    @CacheEvict(value={"plasticDetailed"}, allEntries=true)
    public void deleteObjById(String id) {
        this.plasticDetailedMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"plasticDetailed"}, allEntries=true)
    public void modifyObj(PlasticDetailed t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.plasticDetailedMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"plasticDetailed"}, keyGenerator="redisKeyGenerator")
    public PlasticDetailed queryObjById(String id) {
        return this.plasticDetailedMapper.selectByPrimaryKey(id);
    }

    public List<PlasticDetailed> queryAllObjByExample(PlasticDetailedExample example) {
        return this.plasticDetailedMapper.selectByExample(example);
    }

    public PageView<PlasticDetailed> queryObjByPage(PlasticDetailedExample example) {
        PageView<PlasticDetailed> pageView = example.getPageView();
        pageView.setQueryResult(this.plasticDetailedMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void supCompanyConfirmOrRefuse(String sapOrderNo, Integer isConfirm, Company company, String senderId) {
        PlasticDetailedExample plasticDetailedExample = new PlasticDetailedExample();
        plasticDetailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo).andCompanyIdEqualTo(company.getId());
        List<PlasticDetailed> plasticDetailedList = this.plasticDetailedMapper.selectByExample(plasticDetailedExample);
        for (int i = 0; CollectionUtils.isNotEmpty(plasticDetailedList) && i < plasticDetailedList.size(); ++i) {
            if (plasticDetailedList.get(i).getStatus().intValue() != PaletteDetailedStatus.UNCOMFIRMED.getValue()) {
                throw new CommonException("\u542b\u5df2\u786e\u8ba4\u6216\u62d2\u7edd\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u786e\u8ba4\uff01", "incould_confirm_orderNo", new Object[]{"\u786e\u8ba4\u6216\u62d2\u7edd"});
            }
            PlasticDetailed detailed = new PlasticDetailed();
            detailed.setId(plasticDetailedList.get(i).getId());
            String businessTypeCode = null;
            if (isConfirm == 2) {
                detailed.setStatus(PaletteDetailedStatus.MAKING.getValue());
                detailed.setHeadStatus(PaletteDetailedStatus.COMFIRMED.getValue());
                businessTypeCode = "PLASTIC_PUR_CONFIRM";
            } else {
                detailed.setStatus(isConfirm);
                detailed.setHeadStatus(PaletteDetailedStatus.SUPNOTCOMFIRMED.getValue());
                businessTypeCode = "PLASTIC_PUR_NOTCONFIRM";
            }
            this.plasticDetailedMapper.updateByPrimaryKeySelective(detailed);
            plasticDetailedList.get(i).setCurrentCompanyName(company.getCompanyName());
            Message message = new Message(plasticDetailedList.get(i).getSupplierSrmCode(), senderId, plasticDetailedList.get(i).getPurUserId(), businessTypeCode, MessageLevelEnum.HIGH, (Object)plasticDetailedList.get(i));
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Override
    public void supSendToColorer(String sapOrderNo, Company company, String senderId) {
        PlasticDetailedExample plasticDetailedExample = new PlasticDetailedExample();
        plasticDetailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo).andCompanyIdEqualTo(company.getId());
        List<PlasticDetailed> plasticDetailedList = this.plasticDetailedMapper.selectByExample(plasticDetailedExample);
        for (int i = 0; CollectionUtils.isNotEmpty(plasticDetailedList) && i < plasticDetailedList.size(); ++i) {
            if (plasticDetailedList.get(i).getStatus().intValue() != PaletteDetailedStatus.MAKING.getValue()) {
                throw new CommonException("\u53ea\u6709\u6b63\u5728\u5236\u6837\u7684\u72b6\u6001\u624d\u80fd\u53d1\u9001", "only_status", new Object[]{"\u6b63\u5728\u5236\u6837"});
            }
            if (plasticDetailedList.get(i).getAttachment() == null) {
                throw new CommonException("\u5de5\u827a\u56fe\u7eb8\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u5de5\u827a\u56fe\u7eb8\u9644\u4ef6"});
            }
            PlasticDetailed detailed = new PlasticDetailed();
            detailed.setId(plasticDetailedList.get(i).getId());
            detailed.setStatus(PaletteDetailedStatus.QUARANTINE.getValue());
            detailed.setIsSendToColor(Constant.YES_INT);
            this.plasticDetailedMapper.updateByPrimaryKeySelective(detailed);
            plasticDetailedList.get(i).setCurrentCompanyName(company.getCompanyName());
            Message message = new Message(plasticDetailedList.get(i).getSupplierSrmCode(), senderId, plasticDetailedList.get(i).getPurUserId(), "PLASTIC_SEND_TO_COLOR", MessageLevelEnum.HIGH, (Object)plasticDetailedList.get(i));
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    @Override
    public void colorerConfirmOrRefuse(List<ConfirmVo> confirmList, Company company, String senderId) {
        ArrayList<String> statusList = new ArrayList<String>();
        for (ConfirmVo confirmVo : confirmList) {
            PlasticDetailed selectByPrimaryKey = this.plasticDetailedMapper.selectByPrimaryKey(confirmVo.getId());
            statusList.add(selectByPrimaryKey.getStatus().toString());
        }
        if (Collections.frequency(statusList, "5") != statusList.size()) {
            throw new CommonException("\u542b\u4e0d\u53ef\u8ba4\u5b9a\u7684\u6570\u636e(\u53ea\u6709\u5f85\u68c0\u72b6\u6001\u4e0b\u7684\u6570\u636e\u624d\u80fd\u8ba4\u5b9a\uff01)", "only_confirm", new Object[]{"\u5f85\u68c0"});
        }
        String sapOrderNo = null;
        for (ConfirmVo confirmVo : confirmList) {
            PlasticDetailed plasticDetailed = this.plasticDetailedMapper.selectByPrimaryKey(confirmVo.getId());
            sapOrderNo = plasticDetailed.getSapOrderNo();
            PlasticDetailed detailed = new PlasticDetailed();
            detailed.setId(plasticDetailed.getId());
            detailed.setStatus(PaletteDetailedStatus.COGNIGANCE.getValue());
            this.plasticDetailedMapper.updateByPrimaryKeySelective(detailed);
            PlasticSummaryExample plasticSummaryExample = new PlasticSummaryExample();
            plasticSummaryExample.createCriteria().andSapOrderNoEqualTo(plasticDetailed.getSapOrderNo());
            List plasticSummaryList = this.plasticSummaryService.queryAllObjByExample((IExample)plasticSummaryExample);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)plasticSummaryList) && i < plasticSummaryList.size(); ++i) {
                PlasticSummary plasticSummary = new PlasticSummary();
                plasticSummary.setId(((PlasticSummary)plasticSummaryList.get(i)).getId());
                plasticSummary.setFirmlyTime(new Date());
                this.plasticSummaryService.modifyObj(plasticSummary);
            }
            User purchaser = this.userService.findByUserLoginName(plasticDetailed.getSupplierSrmCode());
            plasticDetailed.setCurrentCompanyName(company.getCompanyName());
            Message message = new Message(plasticDetailed.getSupplierSrmCode(), senderId, purchaser.getId(), "PLASTIC_SUP_AFFIRME", MessageLevelEnum.HIGH, (Object)plasticDetailed);
            MessageSendUtils.sendMessage((Message)message);
        }
        this.setAntherDetailedStatus(sapOrderNo);
    }

    private void setAntherDetailedStatus(String sapOrderNo) {
        if (StringUtils.isNotBlank((String)sapOrderNo)) {
            PlasticDetailedExample plasticDetailedExample = new PlasticDetailedExample();
            plasticDetailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo).andStatusNotEqualTo(PaletteDetailedStatus.COGNIGANCE.getValue());
            List<PlasticDetailed> plasticDetailedList = this.plasticDetailedMapper.selectByExample(plasticDetailedExample);
            for (int i = 0; CollectionUtils.isNotEmpty(plasticDetailedList) && i < plasticDetailedList.size(); ++i) {
                PlasticDetailed detailed = new PlasticDetailed();
                detailed.setId(plasticDetailedList.get(i).getId());
                detailed.setStatus(PaletteDetailedStatus.NOTCOGNIGANCE.getValue());
                this.plasticDetailedMapper.updateByPrimaryKeySelective(detailed);
            }
        }
    }

    @Override
    public PageView<PlasticDetailed> queryObjByPageForPur(PlasticDetailedExample example) {
        PageView<PlasticDetailed> pageView = example.getPageView();
        List<PlasticDetailed> plasticDetailedList = this.plasticDetailedMapper.selectByExampleByPage(example);
        if (CollectionUtils.isNotEmpty(plasticDetailedList)) {
            for (PlasticDetailed plasticDetailed : plasticDetailedList) {
                if (plasticDetailed.getIsSendToColor() == null || plasticDetailed.getIsSendToColor() != 0) continue;
                plasticDetailed.setAttachment(null);
            }
        }
        pageView.setQueryResult(plasticDetailedList);
        return pageView;
    }

    @Override
    public void judgeIsConfirmStatus(List<ConfirmVo> confirmList, String currentCompanyId) {
        ArrayList<String> statusList = new ArrayList<String>();
        for (ConfirmVo confirmVo : confirmList) {
            PlasticDetailedExample plasticDetailedExample = new PlasticDetailedExample();
            plasticDetailedExample.createCriteria().andSapOrderNoEqualTo(confirmVo.getSapOrderNo()).andCompanyIdEqualTo(currentCompanyId);
            List<PlasticDetailed> selectByExample = this.plasticDetailedMapper.selectByExample(plasticDetailedExample);
            for (int i = 0; CollectionUtils.isNotEmpty(selectByExample) && i < selectByExample.size(); ++i) {
                statusList.add(selectByExample.get(i).getStatus().toString());
            }
        }
        if (Collections.frequency(statusList, "1") != statusList.size()) {
            throw new CommonException("\u542b\u4e0d\u53ef\u786e\u8ba4\u6216\u62d2\u7edd\u7684\u6570\u636e\uff08\u53ea\u6709\u884c\u72b6\u6001\u4e3a\u201c\u672a\u786e\u8ba4\u201d\u7684\u6570\u636e\u624d\u80fd\u786e\u8ba4\u6216\u62d2\u7edd\uff01\uff09", "only_refuse", new Object[]{"\u672a\u786e\u8ba4"});
        }
    }

    @Override
    public void judgeIsColorStatus(List<String> sapOrderNoList, String currentCompanyId) {
        ArrayList<String> statusList = new ArrayList<String>();
        for (String sapOrderNo : sapOrderNoList) {
            PlasticDetailedExample plasticDetailedExample = new PlasticDetailedExample();
            plasticDetailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo).andCompanyIdEqualTo(currentCompanyId);
            List<PlasticDetailed> plasticDetailedList = this.plasticDetailedMapper.selectByExample(plasticDetailedExample);
            for (int i = 0; CollectionUtils.isNotEmpty(plasticDetailedList) && i < plasticDetailedList.size(); ++i) {
                statusList.add(plasticDetailedList.get(i).getStatus().toString());
            }
        }
        if (Collections.frequency(statusList, "8") != statusList.size()) {
            throw new CommonException("\u542b\u4e0d\u53ef\u53d1\u9001\u7684\u6570\u636e\uff08\u53ea\u6709\u884c\u72b6\u6001\u4e3a\u201c\u6b63\u5728\u5236\u6837\u201d\u7684\u6570\u636e\u624d\u80fd\u53d1\u9001\uff01\uff09", "only_send", new Object[]{"\u6b63\u5728\u5236\u6837"});
        }
    }
}

