/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.palette.dao.PlasticSummaryMapper;
import com.els.base.palette.entity.PlasticDetailed;
import com.els.base.palette.entity.PlasticDetailedExample;
import com.els.base.palette.entity.PlasticSummary;
import com.els.base.palette.entity.PlasticSummaryExample;
import com.els.base.palette.enums.PaletteDetailedStatus;
import com.els.base.palette.enums.PlasticSummaryStatus;
import com.els.base.palette.service.PlasticDetailedService;
import com.els.base.palette.service.PlasticSummaryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultPlasticSummaryService")
public class PlasticSummaryServiceImpl
implements PlasticSummaryService {
    @Resource
    protected PlasticSummaryMapper plasticSummaryMapper;
    @Resource
    protected PlasticDetailedService plasticDetailedService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;
    @Resource
    protected GenerateCodeService generateCodeService;

    @CacheEvict(value={"plasticSummary"}, allEntries=true)
    public void addObj(PlasticSummary t) {
        this.plasticSummaryMapper.insertSelective(t);
    }

    @CacheEvict(value={"plasticSummary"}, allEntries=true)
    public void deleteObjById(String id) {
        this.plasticSummaryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"plasticSummary"}, allEntries=true)
    public void modifyObj(PlasticSummary t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.plasticSummaryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"plasticSummary"}, keyGenerator="redisKeyGenerator")
    public PlasticSummary queryObjById(String id) {
        return this.plasticSummaryMapper.selectByPrimaryKey(id);
    }

    public List<PlasticSummary> queryAllObjByExample(PlasticSummaryExample example) {
        return this.plasticSummaryMapper.selectByExample(example);
    }

    public PageView<PlasticSummary> queryObjByPage(PlasticSummaryExample example) {
        PageView<PlasticSummary> pageView = example.getPageView();
        pageView.setQueryResult(this.plasticSummaryMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"plasticSummary"}, allEntries=true)
    public void importFromPlm(List<PlasticSummary> list, com.els.base.auth.entity.User user) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        for (PlasticSummary plasticSummary : list) {
            String[] split;
            String sapOrderNo = this.generateCodeService.getNextCode("PLASTIC_ORDER_NO");
            plasticSummary.setSapOrderNo(sapOrderNo);
            plasticSummary.setCreatePerson(user.getNickName());
            plasticSummary.setCreateTime(new Date());
            plasticSummary.setSampleDeliveryTime(new Date());
            plasticSummary.setConfirmStatus(PlasticSummaryStatus.UNCOMFIRMED.getValue());
            plasticSummary.setIsSendToSup(Constant.NO_INT);
            this.plasticSummaryMapper.insert(plasticSummary);
            for (String sapCode : split = plasticSummary.getSendToSupSapCodes().split(",")) {
                CompanyExample companyExample = new CompanyExample();
                companyExample.createCriteria().andCompanySapCodeEqualTo(sapCode);
                List companyList = this.companyService.queryAllObjByExample((IExample)companyExample);
                for (int i = 0; CollectionUtils.isNotEmpty((Collection)companyList) && i < companyList.size(); ++i) {
                    Company company = (Company)companyList.get(i);
                    PlasticDetailed plasticDetailed = new PlasticDetailed();
                    plasticDetailed.setStatus(PaletteDetailedStatus.UNSEND.getValue());
                    plasticDetailed.setHeadStatus(PaletteDetailedStatus.UNSEND.getValue());
                    plasticDetailed.setIsSendToSup(Constant.NO_INT);
                    plasticDetailed.setIsSendToColor(Constant.NO_INT);
                    plasticDetailed.setCompanyId(company.getId());
                    plasticDetailed.setSapOrderNo(plasticSummary.getSapOrderNo());
                    plasticDetailed.setSupplierSapCode(sapCode);
                    plasticDetailed.setSupplierSrmCode(company.getCompanyCode());
                    plasticDetailed.setSupplierName(company.getCompanyName());
                    plasticDetailed.setSupplierAddress(company.getAddress());
                    plasticDetailed.setMaterialCode(plasticSummary.getMaterialCode());
                    plasticDetailed.setContacts(company.getContacts());
                    plasticDetailed.setPhoneNumber(company.getTelephone());
                    this.plasticDetailedService.addObj(plasticDetailed);
                }
            }
        }
    }

    @Override
    public void purSendToSupCompany(List<PlasticSummary> plasticSummaryList, Company company, String senderId) {
        for (PlasticSummary plasticSummary : plasticSummaryList) {
            PlasticDetailedExample detailedExample = new PlasticDetailedExample();
            detailedExample.createCriteria().andSapOrderNoEqualTo(plasticSummary.getSapOrderNo());
            List plasticDetailedList = this.plasticDetailedService.queryAllObjByExample((IExample)detailedExample);
            for (int i = 0; CollectionUtils.isNotEmpty((Collection)plasticDetailedList) && i < plasticDetailedList.size(); ++i) {
                if (((PlasticDetailed)plasticDetailedList.get(i)).getStatus().intValue() != PaletteDetailedStatus.UNSEND.getValue()) {
                    throw new CommonException("\u542b\u5df2\u53d1\u9001\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u9001\uff01", "incould_confirm_orderNo", new Object[]{"\u53d1\u9001"});
                }
                PlasticDetailed plasticDetailed = new PlasticDetailed();
                plasticDetailed.setId(((PlasticDetailed)plasticDetailedList.get(i)).getId());
                plasticDetailed.setPurUserId(senderId);
                plasticDetailed.setStatus(PaletteDetailedStatus.UNCOMFIRMED.getValue());
                plasticDetailed.setHeadStatus(PaletteDetailedStatus.UNCOMFIRMED.getValue());
                plasticDetailed.setIsSendToSup(Constant.YES_INT);
                this.plasticDetailedService.modifyObj(plasticDetailed);
                User supplier = this.userService.findByUserLoginName(((PlasticDetailed)plasticDetailedList.get(i)).getSupplierSrmCode());
                plasticSummary.setCurrentCompanyName(company.getCompanyName());
                Message message = new Message(((PlasticDetailed)plasticDetailedList.get(i)).getSupplierSrmCode(), senderId, supplier.getId(), "PLASTIC_SEND", MessageLevelEnum.HIGH, (Object)plasticSummary);
                MessageSendUtils.sendMessage((Message)message);
            }
            PlasticSummary summary = new PlasticSummary();
            summary.setId(plasticSummary.getId());
            summary.setIsSendToSup(Constant.YES_INT);
            this.plasticSummaryMapper.updateByPrimaryKeySelective(summary);
        }
    }

    @Override
    public void changeHeadStatus(String sapOrderNo) {
        PlasticSummaryExample plasticSummaryExample = new PlasticSummaryExample();
        plasticSummaryExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo);
        List<PlasticSummary> plasticSummaryList = this.plasticSummaryMapper.selectByExample(plasticSummaryExample);
        for (int i = 0; CollectionUtils.isNotEmpty(plasticSummaryList) && i < plasticSummaryList.size(); ++i) {
            PlasticDetailedExample detailedExample = new PlasticDetailedExample();
            detailedExample.createCriteria().andSapOrderNoEqualTo(sapOrderNo);
            List plasticDetailedList = this.plasticDetailedService.queryAllObjByExample((IExample)detailedExample);
            ArrayList<String> statusList = new ArrayList<String>();
            for (int j = 0; CollectionUtils.isNotEmpty((Collection)plasticDetailedList) && j < plasticDetailedList.size(); ++j) {
                statusList.add(((PlasticDetailed)plasticDetailedList.get(j)).getStatus().toString());
            }
            PlasticSummary plasticSummary = new PlasticSummary();
            plasticSummary.setId(plasticSummaryList.get(0).getId());
            if (statusList.contains("1")) {
                plasticSummary.setConfirmStatus(PlasticSummaryStatus.PARTREFUSE.getValue());
            } else if (statusList.contains("3") && Collections.frequency(statusList, "3") != statusList.size()) {
                plasticSummary.setConfirmStatus(PlasticSummaryStatus.PARTREFUSE.getValue());
            } else if (Collections.frequency(statusList, "3") == statusList.size()) {
                plasticSummary.setConfirmStatus(PlasticSummaryStatus.SUPNOTCOMFIRMED.getValue());
            } else {
                plasticSummary.setConfirmStatus(PlasticSummaryStatus.COMFIRMED.getValue());
            }
            this.plasticSummaryMapper.updateByPrimaryKeySelective(plasticSummary);
        }
    }
}

