/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.palette.entity.PaletteDetailed;
import com.els.base.palette.entity.PaletteDetailedExample;
import com.els.base.palette.service.PaletteDetailedService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8272\u677f\u8c03\u8272\u660e\u7ec6")
@Controller
@RequestMapping(value={"paletteDetailed"})
public class PaletteDetailedController {
    @Resource
    protected PaletteDetailedService paletteDetailedService;

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8272\u677f\u8c03\u8272\u660e\u7ec6")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<PaletteDetailed> paletteDetailedList) {
        if (CollectionUtils.isEmpty(paletteDetailedList)) {
            throw new CommonException("data \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        for (PaletteDetailed paletteDetailed : paletteDetailedList) {
            Assert.isNotBlank((String)paletteDetailed.getPaletteCode(), (String)"\u8272\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)paletteDetailed.getPaletteEndDate(), (String)"\u8272\u677f\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            if (paletteDetailed.getLowerLimit() == null || paletteDetailed.getMiddleLimit() == null || paletteDetailed.getUpperLimit() == null) {
                throw new CommonException("\u4e09\u8272\u8272\u5dee\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.paletteDetailedService.modifyDetailed(paletteDetailed);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8272\u677f\u8c03\u8272\u660e\u7ec6")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.paletteDetailedService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8272\u677f\u8c03\u8272\u660e\u7ec6--\u91c7\u8d2d\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PaletteDetailed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<PaletteDetailed>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PaletteDetailedExample example = new PaletteDetailedExample();
        example.setPageView((PageView<PaletteDetailed>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            PaletteDetailedExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.paletteDetailedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8272\u677f\u8c03\u8272\u660e\u7ec6--\u4f9b\u5e94\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PaletteDetailed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<PaletteDetailed>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PaletteDetailedExample example = new PaletteDetailedExample();
        PaletteDetailedExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        example.setPageView((PageView<PaletteDetailed>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView<PaletteDetailed> pageData = this.paletteDetailedService.queryObjByPageForSup(example);
        return ResponseResult.success(pageData);
    }
}

