/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.palette.entity.PaletteSummary;
import com.els.base.palette.entity.PaletteSummaryExample;
import com.els.base.palette.enums.PaletteSummaryOrderStatus;
import com.els.base.palette.service.PaletteDetailedService;
import com.els.base.palette.service.PaletteSummaryService;
import com.els.base.palette.web.controller.vo.ConfirmVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8272\u677f\u8c03\u8272\u6c47\u603b")
@Controller
@RequestMapping(value={"paletteSummary"})
public class PaletteSummaryController {
    @Resource
    protected PaletteSummaryService paletteSummaryService;
    @Resource
    protected PaletteDetailedService paletteDetailedService;

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8272\u677f\u8c03\u8272\u6c47\u603b")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PaletteSummary paletteSummary) {
        if (StringUtils.isBlank((String)paletteSummary.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.paletteSummaryService.modifyObj(paletteSummary);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8272\u677f\u8c03\u8272\u6c47\u603b")
    @RequestMapping(value={"service/batchDelete"})
    @ResponseBody
    public ResponseResult<String> batchDelete(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String id : ids) {
            this.paletteSummaryService.deleteObjById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8272\u677f\u8c03\u8272\u6c47\u603b--\u91c7\u8d2d\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PaletteSummary", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<PaletteSummary>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PaletteSummaryExample example = new PaletteSummaryExample();
        example.setPageView((PageView<PaletteSummary>)new PageView(pageNo, pageSize));
        PaletteSummaryExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<PaletteSummary> pageData = this.paletteSummaryService.findByPageForPur(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8272\u677f\u8c03\u8272\u6c47\u603b--\u4f9b\u5e94\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PaletteSummary", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<PaletteSummary>> findByPageForSup(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PaletteSummaryExample example = new PaletteSummaryExample();
        example.setPageView((PageView<PaletteSummary>)new PageView(pageNo, pageSize));
        example.createCriteria().andSupplierSrmCodeEqualTo(CompanyUtils.currentCompany().getCompanyCode()).andOrderStatusNotEqualTo(PaletteSummaryOrderStatus.UNPUBLISH.getCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.paletteSummaryService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4ecePLM\u7cfb\u7edf\u5bfc\u5165\u8272\u677f\u8c03\u8272\u6570\u636e")
    @RequestMapping(value={"front/paletteSummary/importFromPlm/{accessToken}"})
    @ResponseBody
    public ResponseResult<String> importFromPlm(@PathVariable(value="accessToken") String accessToken, @RequestBody List<PaletteSummary> list) {
        this.paletteSummaryService.importFromPlm(list, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6dfb\u52a0\u8272\u677f\u5355\u636e")
    @RequestMapping(value={"service/addBuild"})
    @ResponseBody
    public ResponseResult<String> addBuild(@RequestBody List<PaletteSummary> list) {
        list.forEach(paletteSummary -> {
            if (paletteSummary.getSendToSupSapCodes().contains(",")) {
                throw new CommonException("\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4f9b\u5e94\u5546");
            }
        });
        this.paletteSummaryService.importFromPlm(list, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u8272\u677f")
    @RequestMapping(value={"service/purSendToSupCompany"})
    @ResponseBody
    public ResponseResult<String> purSendToSupCompany(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("paletteSummary data can not be null");
        }
        Company currentCompany = CompanyUtils.currentCompany();
        for (String id : ids) {
            PaletteSummary paletteSummary = (PaletteSummary)this.paletteSummaryService.queryObjById(id);
            this.paletteSummaryService.purSendToSupCompany(paletteSummary, currentCompany, SpringSecurityUtils.getLoginUserId());
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8272\u677f\u4f9b\u5e94\u5546\u6279\u91cf\u786e\u8ba4\u6216\u62d2\u7edd(\u786e\u8ba4\uff1a2 \u62d2\u7edd\uff1a3)")
    @RequestMapping(value={"service/supCompanyConfirmOrRefuse"})
    @ResponseBody
    public ResponseResult<String> supCompanyConfirmOrRefuse(@RequestBody List<ConfirmVo> confirmList) {
        if (CollectionUtils.isEmpty(confirmList)) {
            throw new CommonException("data can not be null");
        }
        this.paletteSummaryService.judgeIsConfirmStatus(confirmList);
        for (ConfirmVo confirmVo : confirmList) {
            this.paletteDetailedService.supCompanyConfirmOrRefuse(confirmVo, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUserId());
            this.paletteSummaryService.changeHeadStatus(confirmVo);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8272\u677f\u4f9b\u5e94\u5546\u53d1\u9001\u81f3\u7f8e\u5de5")
    @RequestMapping(value={"service/supSendToColorer"})
    @ResponseBody
    public ResponseResult<String> supSendToColorer(@RequestBody List<String> sapOrderNoList) {
        if (CollectionUtils.isNotEmpty(sapOrderNoList)) {
            this.paletteDetailedService.judgeIsColorStatus(sapOrderNoList, CompanyUtils.currentCompanyId());
            for (String sapOrderNo : sapOrderNoList) {
                this.paletteDetailedService.supSendToColorer(sapOrderNo, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUserId());
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f8e\u5de5\u6279\u91cf\u8ba4\u5b9a\u4f9b\u5e94\u5546(\u8ba4\u5b9a\uff1a5 \u9a73\u56de\uff1a6)")
    @RequestMapping(value={"service/colorerConfirmOrRefuse"})
    @ResponseBody
    public ResponseResult<String> colorerConfirmOrRefuse(@RequestBody List<ConfirmVo> confirmList) {
        if (CollectionUtils.isEmpty(confirmList)) {
            throw new CommonException("data can not be null");
        }
        this.paletteDetailedService.colorerConfirmOrRefuse(confirmList, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u914d\u673a\u578b")
    @RequestMapping(value={"service/purSetUseModule"})
    @ResponseBody
    public ResponseResult<String> purSetUseModule(@RequestBody List<ConfirmVo> confirmList) {
        if (CollectionUtils.isEmpty(confirmList) || confirmList.size() > 1) {
            throw new CommonException("\u8bf7\u52fe\u9009\u4e00\u6761\u5355\u636e");
        }
        confirmList.forEach(confirmVo -> this.paletteSummaryService.purSetUseModule((ConfirmVo)confirmVo));
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u5355\u636e")
    @RequestMapping(value={"service/purExpiredOrder"})
    @ResponseBody
    public ResponseResult<String> purExpiredOrder(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f5c\u5e9f,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String id : ids) {
            this.paletteSummaryService.purExpiredOrder(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6dfb\u52a0\u53d1\u9001\u8272\u677f")
    @RequestMapping(value={"service/addAndSendToSup"})
    @ResponseBody
    public ResponseResult<String> addAndSendToSup(@RequestBody PaletteSummary paletteSummary) {
        if (paletteSummary.getSendToSupSapCodes().contains(",")) {
            throw new CommonException("\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4f9b\u5e94\u5546");
        }
        ArrayList<PaletteSummary> paletteSummaryList = new ArrayList<PaletteSummary>();
        paletteSummaryList.add(paletteSummary);
        this.paletteSummaryService.importFromPlm(paletteSummaryList, SpringSecurityUtils.getLoginUser());
        Company currentCompany = CompanyUtils.currentCompany();
        this.paletteSummaryService.purSendToSupCompany(paletteSummary, currentCompany, SpringSecurityUtils.getLoginUserId());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5ef6\u671f")
    @RequestMapping(value={"service/purExpiredDate"})
    @ResponseBody
    public ResponseResult<String> purExpiredDate(@RequestBody List<ConfirmVo> confirmList) {
        if (CollectionUtils.isEmpty(confirmList) || confirmList.size() > 1) {
            throw new CommonException("\u8bf7\u52fe\u9009\u4e00\u6761\u5355\u636e");
        }
        confirmList.forEach(confirmVo -> this.paletteDetailedService.purExpiredDate((ConfirmVo)confirmVo));
        return ResponseResult.success();
    }
}

