/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.palette.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.palette.entity.PlasticDetailed;
import com.els.base.palette.entity.PlasticDetailedExample;
import com.els.base.palette.service.PlasticDetailedService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5851\u80f6\u4ef6\u660e\u7ec6")
@Controller
@RequestMapping(value={"plasticDetailed"})
public class PlasticDetailedController {
    @Resource
    protected PlasticDetailedService plasticDetailedService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5851\u80f6\u4ef6\u660e\u7ec6")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PlasticDetailed plasticDetailed) {
        this.plasticDetailedService.addObj(plasticDetailed);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5851\u80f6\u4ef6\u660e\u7ec6")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<PlasticDetailed> plasticDetailedList) {
        if (CollectionUtils.isEmpty(plasticDetailedList)) {
            throw new CommonException("data \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        for (PlasticDetailed plasticDetailed : plasticDetailedList) {
            this.plasticDetailedService.modifyObj(plasticDetailed);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5851\u80f6\u4ef6\u660e\u7ec6")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.plasticDetailedService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5851\u80f6\u4ef6\u660e\u7ec6--\u91c7\u8d2d\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PlasticDetailed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<PlasticDetailed>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PlasticDetailedExample example = new PlasticDetailedExample();
        example.setPageView((PageView<PlasticDetailed>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            PlasticDetailedExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView<PlasticDetailed> pageData = this.plasticDetailedService.queryObjByPageForPur(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5851\u80f6\u4ef6\u660e\u7ec6--\u4f9b\u5e94\u5546\u754c\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PlasticDetailed", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<PlasticDetailed>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PlasticDetailedExample example = new PlasticDetailedExample();
        PlasticDetailedExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        example.setPageView((PageView<PlasticDetailed>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.plasticDetailedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

