/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiFormAndCompanyMapper;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormAndCompanyExample;
import com.els.base.performance.service.KpiFormAndCompanyService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultKpiFormAndCompanyService")
public class KpiFormAndCompanyServiceImpl
implements KpiFormAndCompanyService {
    @Resource
    protected KpiFormAndCompanyMapper kpiFormAndCompanyMapper;

    @Override
    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void addObj(KpiFormAndCompany t) {
        this.kpiFormAndCompanyMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiFormAndCompanyMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiFormAndCompany"}, allEntries=true)
    public void modifyObj(KpiFormAndCompany t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.kpiFormAndCompanyMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"kpiFormAndCompany"}, keyGenerator="redisKeyGenerator")
    public KpiFormAndCompany queryObjById(String id) {
        return this.kpiFormAndCompanyMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"kpiFormAndCompany"}, keyGenerator="redisKeyGenerator")
    public List<KpiFormAndCompany> queryAllObjByExample(KpiFormAndCompanyExample example) {
        return this.kpiFormAndCompanyMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"kpiFormAndCompany"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiFormAndCompany> queryObjByPage(KpiFormAndCompanyExample example) {
        PageView<KpiFormAndCompany> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiFormAndCompanyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<String> queryCompanyIdsByFormCode(String formCode) {
        KpiFormAndCompanyExample companyExample = new KpiFormAndCompanyExample();
        companyExample.createCriteria().andFormCodeEqualTo(formCode);
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.kpiFormAndCompanyMapper.selectByExample(companyExample);
        ArrayList<String> supCompanyIdList = new ArrayList<String>();
        for (int j = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && j < kpiFormAndCompanyList.size(); ++j) {
            supCompanyIdList.add(kpiFormAndCompanyList.get(j).getSupCompanyId());
        }
        return supCompanyIdList;
    }
}

