/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiProjectMapper;
import com.els.base.performance.entity.KpiProject;
import com.els.base.performance.entity.KpiProjectExample;
import com.els.base.performance.service.KpiProjectService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultKpiProjectService")
public class KpiProjectServiceImpl
implements KpiProjectService {
    @Resource
    protected KpiProjectMapper kpiProjectMapper;
    @Resource
    protected GenerateCodeService generateCodeService;

    @Override
    @CacheEvict(value={"kpiProject"}, allEntries=true)
    public void addObj(KpiProject t) {
        t.setProjectCode(this.generateCodeService.getNextCode("KPI_PROJECT_CODE"));
        t.setPurCompanyId(t.company.getId());
        t.setPurCompanyCode(t.company.getCompanyCode());
        t.setPurCompanyName(t.company.getCompanyName());
        t.setPurUserId(t.user.getId());
        t.setPurUserName(t.user.getNickName());
        t.setCreateTime(new Date());
        t.setLastUpdateUser(t.user.getNickName());
        t.setLastUpdateTime(new Date());
        this.kpiProjectMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"kpiProject"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiProjectMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiProject"}, allEntries=true)
    public void modifyObj(KpiProject t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setPurCompanyId(t.company.getId());
        t.setPurCompanyCode(t.company.getCompanyCode());
        t.setPurCompanyName(t.company.getCompanyName());
        t.setPurUserId(t.user.getId());
        t.setPurUserName(t.user.getNickName());
        t.setLastUpdateUser(t.user.getNickName());
        t.setLastUpdateTime(new Date());
        this.kpiProjectMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"kpiProject"}, keyGenerator="redisKeyGenerator")
    public KpiProject queryObjById(String id) {
        return this.kpiProjectMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"kpiProject"}, keyGenerator="redisKeyGenerator")
    public List<KpiProject> queryAllObjByExample(KpiProjectExample example) {
        return this.kpiProjectMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"kpiProject"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiProject> queryObjByPage(KpiProjectExample example) {
        PageView<KpiProject> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiProjectMapper.selectByExampleByPage(example));
        return pageView;
    }
}

