/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Constant;
import com.els.base.performance.dao.KpiSupAuditMapper;
import com.els.base.performance.entity.KpiSupAudit;
import com.els.base.performance.entity.KpiSupAuditExample;
import com.els.base.performance.enums.KpiAdverseEventStatus;
import com.els.base.performance.service.KpiSupAuditService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultKpiSupAuditService")
public class KpiSupAuditServiceImpl
implements KpiSupAuditService {
    @Resource
    protected KpiSupAuditMapper kpiSupAuditMapper;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected DicGroupItemService dicGroupItemService;

    @Override
    @CacheEvict(value={"kpiSupAudit"}, allEntries=true)
    public void addObj(KpiSupAudit t) {
        t.setCreateTime(new Date());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        t.setStatus("0");
        this.kpiSupAuditMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"kpiSupAudit"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiSupAuditMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiSupAudit"}, allEntries=true)
    public void modifyObj(KpiSupAudit t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setLastUpdateTime(new Date());
        t.setLastUpdateUser(t.getUser().getUsername());
        this.kpiSupAuditMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"kpiSupAudit"}, keyGenerator="redisKeyGenerator")
    public KpiSupAudit queryObjById(String id) {
        return this.kpiSupAuditMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"kpiSupAudit"}, keyGenerator="redisKeyGenerator")
    public List<KpiSupAudit> queryAllObjByExample(KpiSupAuditExample example) {
        return this.kpiSupAuditMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"kpiSupAudit"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiSupAudit> queryObjByPage(KpiSupAuditExample example) {
        PageView<KpiSupAudit> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiSupAuditMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiSupAudit"}, allEntries=true)
    public void submit(String id) {
        KpiSupAudit kpiSupAudit = new KpiSupAudit();
        kpiSupAudit.setId(id);
        kpiSupAudit.setStatus("1");
        this.kpiSupAuditMapper.updateByPrimaryKeySelective(kpiSupAudit);
    }

    @Override
    @CacheEvict(value={"kpiSupAudit"}, allEntries=true)
    public void addObject(KpiSupAudit t) {
        DicGroupItem dicItem;
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd");
        try {
            t.setAuditDate(sdf.parse(sdf.format(t.getAuditDate())));
            t.setPlanReviewTime(sdf.parse(sdf.format(t.getPlanReviewTime())));
            t.setShouldSubTime(sdf.parse(sdf.format(t.getShouldSubTime())));
            t.setSubTime(sdf.parse(sdf.format(t.getSubTime())));
            t.setProblemCloseTime(sdf.parse(sdf.format(t.getProblemCloseTime())));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank((String)t.getAuditType()) && t.getAuditType().equals("\u6574\u6539\u5ba1\u6838")) {
            t.setAuditType(Constant.YES_INT.toString());
        } else {
            t.setAuditType(Constant.NO_INT.toString());
        }
        if (StringUtils.isNotBlank((String)t.getQsv()) && t.getQsv().equals("\u662f")) {
            t.setQsv(Constant.YES_INT.toString());
        } else {
            t.setQsv(Constant.NO_INT.toString());
        }
        if (StringUtils.isNotBlank((String)t.getQtp()) && t.getQtp().equals("\u662f")) {
            t.setQtp(Constant.YES_INT.toString());
        } else {
            t.setQtp(Constant.NO_INT.toString());
        }
        t.setCreateTime(new Date());
        t.setStatus(KpiAdverseEventStatus.NO_SEND.getValue());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(t.getSupCompanySrmCode());
        List companies = this.companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isEmpty(companies)) {
            throw new CommonException("\u4f9b\u5e94\u5546SRM\u7f16\u7801:" + t.getSupCompanySrmCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4fee\u6539", "do_not_exists", "\u4f9b\u5e94\u5546SRM\u7f16\u7801:" + t.getSupCompanySrmCode());
        }
        User user = this.companyUserRefService.queryMainUserOfCompany(((Company)companies.get(0)).getId());
        t.setSupUserId(user.getId());
        t.setSupUserName(user.getNickName());
        t.setSupCompanyId(((Company)companies.get(0)).getId());
        t.setSupCompanySapCode(((Company)companies.get(0)).getCompanySapCode());
        t.setSupCompanyName(((Company)companies.get(0)).getCompanyName());
        t.setSupplierAddress(((Company)companies.get(0)).getAddress());
        String serviceType = "";
        serviceType = "1".equals(((Company)companies.get(0)).getFirstCompanyType()) || "2".equals(((Company)companies.get(0)).getFirstCompanyType()) ? "2" : "1";
        t.setServiceType(serviceType);
        t.setServiceCategory(((Company)companies.get(0)).getFirstCompanyType());
        t.setType(((Company)companies.get(0)).getClassificationThree());
        if (StringUtils.isNotBlank((String)((Company)companies.get(0)).getBusinessType()) && (dicItem = this.dicGroupItemService.queryItems("sap_business_type", ((Company)companies.get(0)).getBusinessType())) != null) {
            t.setPurCategory(dicItem.getCode());
        }
        this.kpiSupAuditMapper.insert(t);
    }
}

