/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormAndCompanyExample;
import com.els.base.performance.entity.KpiFormExample;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.entity.ReportQueryParams;
import com.els.base.performance.entity.ReportShow;
import com.els.base.performance.entity.vo.KpiFormVo;
import com.els.base.performance.service.KpiFormAndCompanyService;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiScoreService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u4f30\u8868")
@Controller
@RequestMapping(value={"kpiForm"})
public class KpiFormController {
    @Resource
    protected KpiFormService kpiFormService;
    @Resource
    protected KpiScoreService kpiScoreService;
    @Resource
    protected KpiFormAndCompanyService kpiFormAndCompanyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiForm kpiForm) {
        if (CollectionUtils.isEmpty(kpiForm.getKpiFormAndCompanyList())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        if (kpiForm.getFormStartTime() == null || kpiForm.getFormEndTime() == null) {
            throw new CommonException("\u8bc4\u4f30\u65f6\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u8bc4\u4f30\u65f6\u6bb5");
        }
        List<KpiFormAndCompany> kpiFormAndCompanyList = kpiForm.getKpiFormAndCompanyList();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            KpiFormExample example = new KpiFormExample();
            KpiFormExample.Criteria criteria = example.createCriteria();
            criteria.andFormStartTimeGreaterThanOrEqualTo(kpiForm.getFormStartTime());
            criteria.andFormEndTimeLessThanOrEqualTo(kpiForm.getFormEndTime());
            criteria.andFormStateNotEqualTo("3");
            List kpiList = this.kpiFormService.queryAllObjByExample(example);
            for (int i = 0; CollectionUtils.isNotEmpty(kpiList) && i < kpiList.size(); ++i) {
                KpiFormAndCompanyExample exampleCompany = new KpiFormAndCompanyExample();
                KpiFormAndCompanyExample.Criteria criteriaCompany = exampleCompany.createCriteria();
                criteriaCompany.andSupCompanyIdEqualTo(kpiFormAndCompany.getSupCompanyId());
                criteriaCompany.andKpiFormIdEqualTo(((KpiForm)kpiList.get(i)).getId());
                List formAndCompanyList = this.kpiFormAndCompanyService.queryAllObjByExample(exampleCompany);
                if (!CollectionUtils.isNotEmpty(formAndCompanyList) || formAndCompanyList.size() <= 0) continue;
                String str = "\u4fdd\u5b58\u5931\u8d25\uff01\u4f9b\u5e94\u5546\u7f16\u7801\u3010" + kpiFormAndCompany.getSupCompanySrmCode() + "\u3011\u5df2\u5728\u8bc4\u4f30\u8868\u3010\u8bc4\u4f30\u8868\u7f16\u7801\uff1a" + ((KpiForm)kpiList.get(i)).getFormCode() + "\u3011\u5b58\u5728,\u4e0d\u80fd\u4fdd\u5b58,\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc4\u4f30\u65f6\u95f4\u6bb5\u6216\u8005\u5254\u9664\u4f9b\u5e94\u5546\u3010\u4f9b\u5e94\u5546\u7f16\u7801\uff1a" + kpiFormAndCompany.getSupCompanySrmCode() + "\u3011\uff01";
                throw new CommonException("\u5b9e\u9645\u5ba1\u6838\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", "finish_status", str);
            }
        }
        if (kpiForm.getFormName().getBytes().length > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.addObject(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiForm kpiForm) {
        if (StringUtils.isBlank((String)kpiForm.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (kpiForm.getFormStartTime() == null || kpiForm.getFormEndTime() == null) {
            throw new CommonException("\u8bc4\u4f30\u65f6\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u8bc4\u4f30\u65f6\u6bb5");
        }
        List<KpiFormAndCompany> kpiFormAndCompanyList = kpiForm.getKpiFormAndCompanyList();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            KpiFormExample example = new KpiFormExample();
            KpiFormExample.Criteria criteria = example.createCriteria();
            criteria.andFormStartTimeGreaterThanOrEqualTo(kpiForm.getFormStartTime());
            criteria.andFormEndTimeLessThanOrEqualTo(kpiForm.getFormEndTime());
            criteria.andFormStateNotEqualTo("3");
            List kpiList = this.kpiFormService.queryAllObjByExample(example);
            for (int i = 0; CollectionUtils.isNotEmpty(kpiList) && i < kpiList.size(); ++i) {
                if (kpiForm.getId().equals(((KpiForm)kpiList.get(i)).getId())) continue;
                KpiFormAndCompanyExample exampleCompany = new KpiFormAndCompanyExample();
                KpiFormAndCompanyExample.Criteria criteriaCompany = exampleCompany.createCriteria();
                criteriaCompany.andSupCompanyIdEqualTo(kpiFormAndCompany.getSupCompanyId());
                criteriaCompany.andKpiFormIdEqualTo(((KpiForm)kpiList.get(i)).getId());
                List formAndCompanyList = this.kpiFormAndCompanyService.queryAllObjByExample(exampleCompany);
                if (!CollectionUtils.isNotEmpty(formAndCompanyList) || formAndCompanyList.size() <= 0) continue;
                String str = "\u4fdd\u5b58\u5931\u8d25\uff01\u4f9b\u5e94\u5546\u7f16\u7801\u3010" + kpiFormAndCompany.getSupCompanySrmCode() + "\u3011\u5df2\u5728\u8bc4\u4f30\u8868\u3010\u8bc4\u4f30\u8868\u7f16\u7801\uff1a" + ((KpiForm)kpiList.get(i)).getFormCode() + "\u3011\u5b58\u5728,\u4e0d\u80fd\u4fdd\u5b58,\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc4\u4f30\u65f6\u95f4\u6bb5\u6216\u8005\u5254\u9664\u4f9b\u5e94\u5546\u3010\u4f9b\u5e94\u5546\u7f16\u7801\uff1a" + kpiFormAndCompany.getSupCompanySrmCode() + "\u3011\uff01";
                throw new CommonException("\u5b9e\u9645\u5ba1\u6838\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", "finish_status", str);
            }
        }
        if (kpiForm.getFormName().getBytes().length > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.modifyObject(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiFormService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u8bc4\u4f30\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiForm", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiForm>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiFormExample example = new KpiFormExample();
        KpiFormExample.Criteria criteria = example.createCriteria();
        criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        example.setOrderByClause(" CREATE_TIME DESC ");
        example.setPageView(new PageView<KpiForm>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        ArrayList<String> srmCompanyIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company c : companyList) {
                srmCompanyIdList.add(c.getId());
            }
        }
        List<KpiForm> finalKpiForms = this.kpiFormService.queryfinalKpiForms(srmCompanyIdList, roleCodeList, SpringSecurityUtils.getLoginUser(), this.kpiFormService.queryAllObjByExampleCoustom(example));
        PageView<KpiForm> pageData = new PageView<KpiForm>(pageNo, pageSize);
        pageData.setRowCount(CollectionUtils.isEmpty(finalKpiForms) ? 0 : finalKpiForms.size());
        pageData.setQueryResult(finalKpiForms.subList(pageData.getStartRowNo(), pageData.getEndRowNo()));
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u8bc4\u5206\u8a73\u60c5")
    @RequestMapping(value={"service/lookKpiFormDetails"})
    @ResponseBody
    public ResponseResult<KpiForm> lookKpiFormDetails(@RequestParam String kpiFormId) {
        if (StringUtils.isBlank((String)kpiFormId)) {
            throw new CommonException("\u67e5\u770b\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KpiForm kpiForm = this.kpiFormService.lookKpiFormDetails(kpiFormId);
        return ResponseResult.success(kpiForm);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03")
    @RequestMapping(value={"service/releaseKpiFrom"})
    @ResponseBody
    public ResponseResult<String> releaseKpiFrom(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u53d1\u5e03\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.releaseKpiFrom(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ed3\u6848\u8bc4\u4f30\u8868")
    @RequestMapping(value={"service/finishForm"})
    @ResponseBody
    public ResponseResult<String> finishForm(@RequestBody KpiForm kpiForm) {
        if (StringUtils.isBlank((String)kpiForm.getId())) {
            throw new CommonException("\u8bc4\u4f30\u8868\u4e3b\u952eid\u4e3a\u7a7a\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "base_canot_be_null", "\u8bc4\u4f30\u8868\u4e3b\u952eid");
        }
        if (StringUtils.isBlank((String)kpiForm.getFormCode())) {
            throw new CommonException("\u8bc4\u4f30\u8868\u7f16\u7801\u4e3a\u7a7a\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "base_canot_be_null", "\u8bc4\u4f30\u8868\u7f16\u7801");
        }
        KpiScoreExample kpiScoreExample = new KpiScoreExample();
        KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
        criteria.andFormCodeEqualTo(kpiForm.getFormCode());
        criteria.andScoreStateEqualTo("0");
        List kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
        if (kpiScoreList.size() > 0) {
            throw new CommonException("\u8be5\u8bc4\u4f30\u8868\u8fd8\u6709\u672a\u8bc4\u5206\u7684\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848\u64cd\u4f5c", "finish_status", "\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u8bc4\u4f30\u8868\u3010\u8bc4\u4f30\u8868\u7f16\u7801:" + kpiForm.getFormCode() + "\u3011\u8fd8\u6709\u672a\u63d0\u4ea4\u8bc4\u5206\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848\uff01");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        this.kpiFormService.finishForm(kpiForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u770b\u8bc4\u5206")
    @RequestMapping(value={"service/lookAtTheScore"})
    @ResponseBody
    public ResponseResult<KpiFormVo> lookAtTheScore(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u67e5\u770b\u8bc4\u5206\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        ArrayList<String> srmCompanyIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company c : companyList) {
                srmCompanyIdList.add(c.getId());
            }
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        kpiForm.setPurManageCompanyIdList(srmCompanyIdList);
        KpiFormVo kpiFormVo = this.kpiFormService.lookAtTheScore(kpiForm);
        return ResponseResult.success(kpiFormVo);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u83b7\u53d6SRM\u6570\u636e")
    @RequestMapping(value={"service/importEvaluateSrmData"})
    @ResponseBody
    public ResponseResult<KpiFormVo> importEvaluateSrmData(@RequestBody KpiForm kpiForm) {
        if (kpiForm == null) {
            throw new CommonException("\u67e5\u770b\u8bc4\u5206\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        ArrayList<String> srmCompanyIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company c : companyList) {
                srmCompanyIdList.add(c.getId());
            }
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        List loginUserRoleList = SpringSecurityUtils.getLoginUserRoleList();
        ArrayList<String> roleCodeList = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)loginUserRoleList) && i < loginUserRoleList.size(); ++i) {
            roleCodeList.add(((Role)loginUserRoleList.get(i)).getRoleCode());
        }
        kpiForm.setCompany(company);
        kpiForm.setUser(user);
        kpiForm.setRoleCodeList(roleCodeList);
        kpiForm.setPurManageCompanyIdList(srmCompanyIdList);
        KpiFormVo kpiFormVo = this.kpiFormService.importEvaluateSrmData(kpiForm);
        return ResponseResult.success(kpiFormVo);
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u8bc4\u5206")
    @RequestMapping(value={"service/saveAtTheScore"})
    @ResponseBody
    public ResponseResult<String> saveAtTheScore(@RequestBody KpiFormVo kpiFormVo, @RequestParam String saveOrSubmit) {
        if (kpiFormVo == null) {
            throw new CommonException("\u4fdd\u5b58\u8bc4\u5206\u5931\u8d25,data\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiFormVo.setCompany(company);
        kpiFormVo.setUser(user);
        this.kpiFormService.saveAtTheScore(kpiFormVo, saveOrSubmit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f")
    @RequestMapping(value={"service/toVoidDocument"})
    @ResponseBody
    public ResponseResult<String> toVoidDocument(String id) {
        this.kpiFormService.toVoidDocument(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7b49\u7ea7\u8c03\u6574")
    @RequestMapping(value={"service/rankAdjustMent"})
    @ResponseBody
    public ResponseResult<String> rankAdjustMent(@RequestParam String supplierSrmCode, @RequestParam String classLevel) {
        if (StringUtils.isBlank((String)supplierSrmCode) || StringUtils.isBlank((String)classLevel)) {
            throw new CommonException("\u7b49\u7ea7\u8c03\u6574\u5931\u8d25,supplierSrmCode,classLevel\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiFormService.rankAdjustMent(supplierSrmCode, classLevel);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6708\u5ea6\u62a5\u8868")
    @RequestMapping(value={"service/queryMonthlyReport"})
    @ResponseBody
    public ResponseResult<ReportShow> queryMonthlyReport(@RequestBody ReportQueryParams reportQueryParams) {
        ReportShow monthlyReport = this.kpiFormService.queryMonthlyReport(reportQueryParams);
        return ResponseResult.success(monthlyReport);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5b63\u5ea6\u6216\u5e74\u5ea6\u62a5\u8868")
    @RequestMapping(value={"service/queryQuarterOrYearReport"})
    @ResponseBody
    public ResponseResult<ReportShow> queryQuarterOrYearReport(@RequestBody ReportQueryParams reportQueryParams) {
        ReportShow quarterReportShow = this.kpiFormService.queryQuarterOrYearReport(reportQueryParams);
        return ResponseResult.success(quarterReportShow);
    }
}

