/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiTemplateMapper;
import com.els.base.performance.entity.KpiTemplate;
import com.els.base.performance.entity.KpiTemplateExample;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.entity.KpiTemplateVO;
import com.els.base.performance.entity.KpiTemplateWeight;
import com.els.base.performance.entity.KpiTemplateWeightExample;
import com.els.base.performance.service.KpiTemplateItemService;
import com.els.base.performance.service.KpiTemplateService;
import com.els.base.performance.service.KpiTemplateWeightService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiTemplateService")
public class KpiTemplateServiceImpl
implements KpiTemplateService {
    @Resource
    protected KpiTemplateMapper kpiTemplateMapper;
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;
    @Resource
    protected KpiTemplateWeightService kpiTemplateWeightService;
    @Resource
    protected GenerateCodeService generateCodeService;

    @Override
    @CacheEvict(value={"kpiTemplate"}, allEntries=true)
    public void addObj(KpiTemplate t) {
        this.kpiTemplateMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"kpiTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiTemplateMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiTemplate"}, allEntries=true)
    public void modifyObj(KpiTemplate t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.kpiTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"kpiTemplate"}, keyGenerator="redisKeyGenerator")
    public KpiTemplate queryObjById(String id) {
        return this.kpiTemplateMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"kpiTemplate"}, keyGenerator="redisKeyGenerator")
    public List<KpiTemplate> queryAllObjByExample(KpiTemplateExample example) {
        return this.kpiTemplateMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"kpiTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiTemplate> queryObjByPage(KpiTemplateExample example) {
        PageView<KpiTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiTemplate"}, allEntries=true)
    @Transactional
    public void addKpiTemplate(KpiTemplateVO kpiTemplateVO) {
        List<KpiTemplateItem> kpiTemplateItems;
        if (StringUtils.isBlank((String)kpiTemplateVO.kpiTemplate.getTemplateName())) {
            throw new NullPointerException("\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\u4e0d\u80fd\u4fdd\u5b58");
        }
        String templateCode = this.generateCodeService.getNextCode("KPI_TEMPLATE_CODE");
        kpiTemplateVO.kpiTemplate.setPurCompanyId(kpiTemplateVO.company.getId());
        kpiTemplateVO.kpiTemplate.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
        kpiTemplateVO.kpiTemplate.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
        kpiTemplateVO.kpiTemplate.setPurUserId(kpiTemplateVO.user.getId());
        kpiTemplateVO.kpiTemplate.setPurUserName(kpiTemplateVO.user.getNickName());
        kpiTemplateVO.kpiTemplate.setTemplateCode(templateCode);
        kpiTemplateVO.kpiTemplate.setCreateTime(new Date());
        kpiTemplateVO.kpiTemplate.setLastUpdateUser(kpiTemplateVO.user.getNickName());
        kpiTemplateVO.kpiTemplate.setLastUpdateTime(new Date());
        this.kpiTemplateMapper.insertSelective(kpiTemplateVO.kpiTemplate);
        List<KpiTemplateWeight> kpiTemplateWeights = kpiTemplateVO.getKpiTemplateWeightList();
        if (kpiTemplateWeights != null && kpiTemplateWeights.size() > 0) {
            for (KpiTemplateWeight kpiTemplateWeight : kpiTemplateWeights) {
                kpiTemplateWeight.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateWeight.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateWeight.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateWeight.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateWeight.setPurUserName(kpiTemplateVO.user.getNickName());
                kpiTemplateWeight.setKpiTemplateId(kpiTemplateVO.kpiTemplate.getId());
                kpiTemplateWeight.setTemplateCode(templateCode);
                kpiTemplateWeight.setCreateTime(new Date());
                kpiTemplateWeight.setLastUpdateUser(kpiTemplateVO.user.getNickName());
                kpiTemplateWeight.setLastUpdateTime(new Date());
                this.kpiTemplateWeightService.addObj(kpiTemplateWeight);
            }
        }
        if ((kpiTemplateItems = kpiTemplateVO.getKpiTemplateItemList()) != null && kpiTemplateItems.size() > 0) {
            for (KpiTemplateItem kpiTemplateItem : kpiTemplateItems) {
                kpiTemplateItem.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateItem.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateItem.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateItem.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateItem.setPurUserName(kpiTemplateVO.user.getNickName());
                kpiTemplateItem.setKpiTemplateId(kpiTemplateVO.kpiTemplate.getId());
                kpiTemplateItem.setTemplateCode(templateCode);
                kpiTemplateItem.setCreateTime(new Date());
                kpiTemplateItem.setLastUpdateUser(kpiTemplateVO.user.getNickName());
                kpiTemplateItem.setLastUpdateTime(new Date());
                this.kpiTemplateItemService.addObj(kpiTemplateItem);
            }
        }
    }

    @Override
    @CacheEvict(value={"kpiTemplate"}, allEntries=true)
    @Transactional
    public void editKpiTemplate(KpiTemplateVO kpiTemplateVO, KpiTemplateWeightExample kpiTemplateWeightExample, KpiTemplateItemExample kpiTemplateItemExample) {
        if (StringUtils.isBlank((String)kpiTemplateVO.kpiTemplate.getTemplateCode())) {
            throw new NullPointerException("\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\u4e0d\u80fd\u4fdd\u5b58");
        }
        String templateCode = kpiTemplateVO.kpiTemplate.getTemplateCode();
        KpiTemplate kpiTemplate = new KpiTemplate();
        kpiTemplate.setId(kpiTemplateVO.getKpiTemplate().getId());
        kpiTemplate.setTemplateName(kpiTemplateVO.getKpiTemplate().getTemplateName());
        kpiTemplate.setPurCompanyCategory(kpiTemplateVO.getKpiTemplate().getPurCompanyCategory());
        kpiTemplate.setPurCompanyRank(kpiTemplateVO.getKpiTemplate().getPurCompanyRank());
        kpiTemplate.setLastUpdateUser(kpiTemplateVO.user.getNickName());
        kpiTemplate.setLastUpdateTime(new Date());
        this.kpiTemplateMapper.updateByPrimaryKeySelective(kpiTemplate);
        this.kpiTemplateWeightService.deleteByExample(kpiTemplateWeightExample);
        List<KpiTemplateWeight> kpiTemplateWeights = kpiTemplateVO.getKpiTemplateWeightList();
        if (kpiTemplateWeights != null && kpiTemplateWeights.size() > 0) {
            for (KpiTemplateWeight kpiTemplateWeight : kpiTemplateWeights) {
                kpiTemplateWeight.setTemplateCode(templateCode);
                kpiTemplateWeight.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateWeight.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateWeight.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateWeight.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateWeight.setPurUserName(kpiTemplateVO.user.getNickName());
                kpiTemplateWeight.setCreateTime(new Date());
                kpiTemplateWeight.setLastUpdateUser(kpiTemplateVO.user.getNickName());
                kpiTemplateWeight.setLastUpdateTime(new Date());
                this.kpiTemplateWeightService.addObj(kpiTemplateWeight);
            }
        }
        this.kpiTemplateItemService.deleteByExample(kpiTemplateItemExample);
        List<KpiTemplateItem> kpiTemplateItems = kpiTemplateVO.getKpiTemplateItemList();
        if (kpiTemplateItems != null && kpiTemplateItems.size() > 0) {
            for (KpiTemplateItem kpiTemplateItem : kpiTemplateItems) {
                kpiTemplateItem.setTemplateCode(templateCode);
                kpiTemplateItem.setPurCompanyId(kpiTemplateVO.company.getId());
                kpiTemplateItem.setPurCompanyCode(kpiTemplateVO.company.getCompanyCode());
                kpiTemplateItem.setPurCompanyName(kpiTemplateVO.company.getCompanyName());
                kpiTemplateItem.setPurUserId(kpiTemplateVO.user.getId());
                kpiTemplateItem.setPurUserName(kpiTemplateVO.user.getNickName());
                kpiTemplateItem.setCreateTime(new Date());
                kpiTemplateItem.setLastUpdateUser(kpiTemplateVO.user.getNickName());
                kpiTemplateItem.setLastUpdateTime(new Date());
                this.kpiTemplateItemService.addObj(kpiTemplateItem);
            }
        }
    }

    @Override
    @CacheEvict(value={"kpiTemplate"}, allEntries=true)
    @Transactional
    public void deleteKpiTemplate(KpiTemplateVO kpiTemplateVO, KpiTemplateWeightExample kpiTemplateWeightExample, KpiTemplateItemExample kpiTemplateItemExample) {
        if (StringUtils.isBlank((String)kpiTemplateVO.kpiTemplate.getTemplateCode())) {
            throw new NullPointerException("\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\u4e0d\u80fd\u5220\u9664");
        }
        if (StringUtils.isBlank((String)kpiTemplateVO.getKpiTemplate().getId())) {
            throw new NullPointerException("\u6a21\u677fid\u4e3a\u7a7a\u4e0d\u80fd\u5220\u9664");
        }
        this.kpiTemplateMapper.deleteByPrimaryKey(kpiTemplateVO.getKpiTemplate().getId());
        this.kpiTemplateWeightService.deleteByExample(kpiTemplateWeightExample);
        this.kpiTemplateItemService.deleteByExample(kpiTemplateItemExample);
    }
}

