/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiProject;
import com.els.base.performance.entity.KpiProjectExample;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.service.KpiProjectService;
import com.els.base.performance.service.KpiTemplateItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7ee9\u6548\u7ba1\u7406-\u8bc4\u4f30\u9879\u8868")
@Controller
@RequestMapping(value={"kpiProject"})
public class KpiProjectController {
    @Resource
    protected KpiProjectService kpiProjectService;
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8bc4\u4f30\u9879\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiProject kpiProject) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiProject.getProjectName())) {
            throw new CommonException("\u8bc4\u4f30\u9879\u540d\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u8bc4\u4f30\u9879\u540d\u79f0");
        }
        if (StringUtils.isBlank((String)kpiProject.getProjectTypeName())) {
            throw new CommonException("\u8bc4\u4f30\u9879\u7c7b\u522b\u540d\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u8bc4\u4f30\u9879\u7c7b\u522b\u540d\u79f0");
        }
        if (kpiProject.getProjectName() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectName(), "UTF-8") > 300 || kpiProject.getProjectStandard() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectStandard(), "UTF-8") > 2000 || kpiProject.getProjectInstruction() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectInstruction(), "UTF-8") > 2000 || kpiProject.getProjectMethodParameter() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectMethodParameter(), "UTF-8") > 1000 || kpiProject.getProjectMethodParameterName() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectMethodParameterName(), "UTF-8") > 300) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiProject.setCompany(company);
        kpiProject.setUser(user);
        this.kpiProjectService.addObj(kpiProject);
        return ResponseResult.success();
    }

    public static int getWordCountCode(String str, String code) throws UnsupportedEncodingException {
        return str.getBytes(code).length;
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8bc4\u4f30\u9879\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiProject kpiProject) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)kpiProject.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)kpiProject.getProjectName())) {
            throw new CommonException("\u8bc4\u4f30\u9879\u540d\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u8bc4\u4f30\u9879\u540d\u79f0");
        }
        if (StringUtils.isBlank((String)kpiProject.getProjectTypeName())) {
            throw new CommonException("\u8bc4\u4f30\u9879\u7c7b\u522b\u540d\u79f0\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "base_canot_be_null", "\u8bc4\u4f30\u9879\u7c7b\u522b\u540d\u79f0");
        }
        if (kpiProject.getProjectName() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectName(), "UTF-8") > 300 || kpiProject.getProjectStandard() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectStandard(), "UTF-8") > 2000 || kpiProject.getProjectInstruction() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectInstruction(), "UTF-8") > 2000 || kpiProject.getProjectMethodParameter() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectMethodParameter(), "UTF-8") > 1000 || kpiProject.getProjectMethodParameterName() != null && KpiProjectController.getWordCountCode(kpiProject.getProjectMethodParameterName(), "UTF-8") > 300) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        kpiProject.setCompany(company);
        kpiProject.setUser(user);
        this.kpiProjectService.modifyObj(kpiProject);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8bc4\u4f30\u9879\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiProjectService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5224\u65ad\u8bc4\u4f30\u9879\u662f\u5426\u88ab\u6a21\u677f\u5f15\u7528")
    @RequestMapping(value={"service/selectByIdExists"})
    @ResponseBody
    public ResponseResult<String> selectByIdExists(@RequestParam(required=true) String id, @RequestParam(required=true) String projectCode) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u8bc4\u4f30\u9879id");
        }
        if (StringUtils.isBlank((String)projectCode)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u8bc4\u4f30\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u8bc4\u4f30\u9879\u7f16\u7801");
        }
        KpiTemplateItemExample kpiTemplateItemExample = new KpiTemplateItemExample();
        KpiTemplateItemExample.Criteria criteria = kpiTemplateItemExample.createCriteria();
        criteria.andKpiProjectIdEqualTo(id);
        List kpiTemplateItemList = this.kpiTemplateItemService.queryAllObjByExample(kpiTemplateItemExample);
        if (kpiTemplateItemList.size() > 0) {
            throw new CommonException("\u5df2\u88ab\u5176\u4ed6\u5f15\u7528\u4e0d\u80fd\u64cd\u4f5c", "existing_ref_ass", "\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u8bc4\u4f30\u9879\u3010\u8bc4\u4f30\u9879\u7f16\u7801:" + projectCode + "\u3011", "\u5176\u4ed6\u6a21\u677f\u3010\u6a21\u677f\u7f16\u7801:" + ((KpiTemplateItem)kpiTemplateItemList.get(0)).getTemplateCode() + "\u3011");
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8bc4\u4f30\u9879\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiProject", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiProject>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiProjectExample example = new KpiProjectExample();
        example.setPageView(new PageView<KpiProject>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        KpiProjectExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.kpiProjectService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

