/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.performance.dao.KpiFormMapper;
import com.els.base.performance.entity.KpiAdverseEvent;
import com.els.base.performance.entity.KpiAdverseEventExample;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormAndCompanyExample;
import com.els.base.performance.entity.KpiFormAndPerson;
import com.els.base.performance.entity.KpiFormAndPersonExample;
import com.els.base.performance.entity.KpiFormExample;
import com.els.base.performance.entity.KpiProject;
import com.els.base.performance.entity.KpiProjectExample;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.entity.KpiScore;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.entity.KpiTemplate;
import com.els.base.performance.entity.KpiTemplateExample;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.entity.KpiTemplateWeight;
import com.els.base.performance.entity.KpiTemplateWeightExample;
import com.els.base.performance.entity.ReportQueryParams;
import com.els.base.performance.entity.ReportShow;
import com.els.base.performance.entity.vo.KpiFormVo;
import com.els.base.performance.entity.vo.KpiReport;
import com.els.base.performance.enums.KpiFormStatus;
import com.els.base.performance.service.KpiAdverseEventService;
import com.els.base.performance.service.KpiFormAndCompanyService;
import com.els.base.performance.service.KpiFormAndPersonService;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiProjectService;
import com.els.base.performance.service.KpiRankingService;
import com.els.base.performance.service.KpiScoreService;
import com.els.base.performance.service.KpiTemplateItemService;
import com.els.base.performance.service.KpiTemplateService;
import com.els.base.performance.service.KpiTemplateWeightService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKpiFormService")
public class KpiFormServiceImpl
implements KpiFormService {
    @Resource
    protected KpiFormMapper kpiFormMapper;
    @Resource
    protected KpiFormAndCompanyService kpiFormAndCompanyService;
    @Resource
    protected KpiFormAndPersonService kpiFormAndPersonService;
    @Resource
    protected KpiRankingService kpiRankingService;
    @Resource
    protected KpiTemplateService kpiTemplateService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected KpiScoreService kpiScoreService;
    @Resource
    protected KpiProjectService kpiProjectService;
    @Resource
    protected KpiTemplateItemService kpiTemplateItemService;
    @Resource
    protected KpiTemplateWeightService kpiTemplateWeightService;
    @Resource
    protected UserService userService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiAdverseEventService kpiAdverseEventService;

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void addObj(KpiForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_FORM_CODE");
        t.setFormCode(formCode);
        this.kpiFormMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void modifyObj(KpiForm t) {
        this.kpiFormMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void addObject(KpiForm t) {
        String formCode = this.generateCodeService.getNextCode("KPI_FORM_CODE");
        Company currentCompany = t.getCompany();
        User user = t.getUser();
        t.setPurCompanyId(currentCompany.getId());
        t.setCreateTime(new Date());
        t.setFormState(KpiFormStatus.NEW.getValue());
        t.setFormCalculation(Constant.NO_INT.toString());
        t.setFormCode(formCode);
        t.setPurCompanyId(currentCompany.getId());
        t.setPurCompanyCode(currentCompany.getCompanyCode());
        t.setPurCompanyName(currentCompany.getCompanyName());
        t.setPurUserId(user.getId());
        t.setPurUserName(user.getNickName());
        KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(t.getKpiTemplateId());
        t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
        t.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
        this.kpiFormMapper.insertSelective(t);
        this.addCompanyAndPersonInfo(t);
    }

    private void addCompanyAndPersonInfo(KpiForm t) {
        List<KpiFormAndCompany> kpiFormAndCompanyList = t.getKpiFormAndCompanyList();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            this.addKpiCompany(t, kpiFormAndCompany);
        }
        List<KpiFormAndPerson> kpiFormAndPersonList = t.getKpiFormAndPersonList();
        for (KpiFormAndPerson kpiFormAndPerson : kpiFormAndPersonList) {
            this.addKpiPerson(t, kpiFormAndPerson);
        }
    }

    private void addKpiCompany(KpiForm t, KpiFormAndCompany kpiFormAndCompany) {
        Company currentCompany = t.getCompany();
        User user = t.getUser();
        kpiFormAndCompany.setKpiFormId(t.getId());
        kpiFormAndCompany.setFormCode(t.getFormCode());
        kpiFormAndCompany.setPurCompanyId(currentCompany.getId());
        kpiFormAndCompany.setPurCompanyCode(currentCompany.getCompanyCode());
        kpiFormAndCompany.setPurCompanyName(currentCompany.getCompanyName());
        kpiFormAndCompany.setPurUserId(user.getId());
        kpiFormAndCompany.setPurUserName(user.getNickName());
        kpiFormAndCompany.setLastUpdateTime(t.getLastUpdateTime());
        kpiFormAndCompany.setLastUpdateUser(t.getLastUpdateUser());
        this.kpiFormAndCompanyService.addObj(kpiFormAndCompany);
    }

    private void addKpiPerson(KpiForm t, KpiFormAndPerson kpiFormAndPerson) {
        Company currentCompany = t.getCompany();
        User user = t.getUser();
        kpiFormAndPerson.setKpiFormId(t.getId());
        kpiFormAndPerson.setFormCode(t.getFormCode());
        kpiFormAndPerson.setPurCompanyId(currentCompany.getId());
        kpiFormAndPerson.setPurCompanyCode(currentCompany.getCompanyCode());
        kpiFormAndPerson.setPurCompanyName(currentCompany.getCompanyName());
        kpiFormAndPerson.setPurUserId(user.getId());
        kpiFormAndPerson.setPurUserName(user.getNickName());
        kpiFormAndPerson.setLastUpdateTime(t.getLastUpdateTime());
        kpiFormAndPerson.setLastUpdateUser(t.getLastUpdateUser());
        this.kpiFormAndPersonService.addObj(kpiFormAndPerson);
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deleteKpiCompanyAndPerson(id);
        this.kpiFormMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void modifyObject(KpiForm t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        User user = t.getUser();
        KpiForm kpiForm = this.kpiFormMapper.selectByPrimaryKey(t.getId());
        t.setLastUpdateTime(new Date());
        t.setLastUpdateUser(user.getNickName());
        t.setFormCode(kpiForm.getFormCode());
        this.deleteKpiCompanyAndPerson(t.getId());
        this.addCompanyAndPersonInfo(t);
        this.kpiFormMapper.updateByPrimaryKeySelective(t);
    }

    private void deleteKpiCompanyAndPerson(String kpiId) {
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.queryCompanyInfoByKpiId(kpiId);
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            this.kpiFormAndCompanyService.deleteObjById(kpiFormAndCompany.getId());
        }
        List<KpiFormAndPerson> kpiFormAndPersonList = this.queryPersonInfoByKpiId(kpiId);
        for (KpiFormAndPerson kpiFormAndPerson : kpiFormAndPersonList) {
            this.kpiFormAndPersonService.deleteObjById(kpiFormAndPerson.getId());
        }
    }

    @Override
    @Cacheable(value={"kpiForm"}, keyGenerator="redisKeyGenerator")
    public KpiForm queryObjById(String id) {
        return this.kpiFormMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"kpiForm"}, keyGenerator="redisKeyGenerator")
    public List<KpiForm> queryAllObjByExample(KpiFormExample example) {
        List<KpiForm> kpiFormList = this.kpiFormMapper.selectByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormList) && i < kpiFormList.size(); ++i) {
            KpiForm kpiForm = kpiFormList.get(i);
            kpiForm.setKpiFormAndCompanyList(this.queryCompanyInfoByKpiId(kpiForm.getId()));
            kpiForm.setKpiFormAndPersonList(this.queryPersonInfoByKpiId(kpiForm.getId()));
        }
        return kpiFormList;
    }

    @Override
    public List<KpiForm> queryAllObjByExampleCoustom(KpiFormExample example) {
        return this.kpiFormMapper.selectByExample(example);
    }

    @Override
    public PageView<KpiForm> queryObjByPage(KpiFormExample example) {
        PageView<KpiForm> pageView = example.getPageView();
        List<KpiForm> kpiFormList = this.kpiFormMapper.selectByExampleByPage(example);
        pageView.setQueryResult(kpiFormList);
        return pageView;
    }

    private List<KpiFormAndPerson> queryPersonInfoByKpiId(String kpiFormId) {
        KpiFormAndPersonExample example = new KpiFormAndPersonExample();
        example.createCriteria().andKpiFormIdEqualTo(kpiFormId);
        List<KpiFormAndPerson> kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); ++i) {
            com.els.base.core.entity.user.User user = (com.els.base.core.entity.user.User)this.userService.queryObjById(kpiFormAndPersonList.get(i).getPersonUserId());
            kpiFormAndPersonList.get(i).setLoginName(user.getLoginName());
        }
        return kpiFormAndPersonList;
    }

    @Override
    public List<KpiFormAndCompany> queryCompanyInfoByKpiId(String kpiFormId) {
        KpiFormAndCompanyExample example = new KpiFormAndCompanyExample();
        example.createCriteria().andKpiFormIdEqualTo(kpiFormId);
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.kpiFormAndCompanyService.queryAllObjByExample(example);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && i < kpiFormAndCompanyList.size(); ++i) {
            CompanyExample companyExample = new CompanyExample();
            companyExample.createCriteria().andCompanyCodeEqualTo(kpiFormAndCompanyList.get(i).getSupCompanySrmCode());
            List companyList = this.companyService.queryAllObjByExample(companyExample);
            kpiFormAndCompanyList.get(i).setPurCompanyCategory(((Company)companyList.get(0)).getFirstCompanyType());
            kpiFormAndCompanyList.get(i).setPurCompanyRank(((Company)companyList.get(0)).getGrade());
        }
        return kpiFormAndCompanyList;
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    @Transactional
    public void finishForm(KpiForm kpiForm) {
        KpiForm form = this.queryObjById(kpiForm.getId());
        if (form == null) {
            throw new CommonException("\u5bf9\u5e94\u7684\u8bc4\u4f30\u8868\u6570\u636e\u4e0d\u5b58\u5728\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "do_not_exists", "\u8bc4\u4f30\u8868\u6570\u636e");
        }
        KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(form.getKpiTemplateId());
        if (kpiTemplate == null) {
            throw new CommonException("\u5bf9\u5e94\u7684\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\u4e0d\u80fd\u8fdb\u884c\u7ed3\u6848", "do_not_exists", "\u8bc4\u4f30\u6a21\u677f\u6570\u636e");
        }
        Date date = new Date();
        KpiForm kpiFormVO = new KpiForm();
        kpiFormVO.setId(kpiForm.getId());
        kpiFormVO.setFormCode(kpiForm.getFormCode());
        kpiFormVO.setFormState("2");
        kpiFormVO.setFormFactTime(date);
        kpiFormVO.setLastUpdateUser(kpiForm.getUser().getNickName());
        kpiFormVO.setLastUpdateTime(date);
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiFormVO);
        KpiRankingExample kpiRankingExample = new KpiRankingExample();
        KpiRankingExample.Criteria rankingCriteria = kpiRankingExample.createCriteria();
        rankingCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        rankingCriteria.andFormCodeEqualTo(kpiForm.getFormCode());
        this.kpiRankingService.deleteByExample(kpiRankingExample);
        KpiFormAndCompanyExample kpiFormAndCompanyExample = new KpiFormAndCompanyExample();
        KpiFormAndCompanyExample.Criteria formAndCompanyCriteria = kpiFormAndCompanyExample.createCriteria();
        formAndCompanyCriteria.andKpiFormIdEqualTo(kpiForm.getId());
        formAndCompanyCriteria.andFormCodeEqualTo(kpiForm.getFormCode());
        List kpiFormAndCompany = this.kpiFormAndCompanyService.queryAllObjByExample(kpiFormAndCompanyExample);
        for (KpiFormAndCompany formAndCompany : kpiFormAndCompany) {
            KpiRanking t = new KpiRanking();
            t.setSupCompanyId(formAndCompany.getSupCompanyId());
            t.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            t.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            KpiRanking lastKpiRanking = this.kpiRankingService.selectByCustom(t);
            KpiRanking currKpiRanking = new KpiRanking();
            currKpiRanking.setPurCompanyId(kpiForm.getCompany().getId());
            currKpiRanking.setPurCompanyCode(kpiForm.getCompany().getCompanyCode());
            currKpiRanking.setPurCompanyName(kpiForm.getCompany().getCompanyName());
            currKpiRanking.setPurUserId(kpiForm.getUser().getId());
            currKpiRanking.setPurUserName(kpiForm.getUser().getNickName());
            currKpiRanking.setKpiFormId(form.getId());
            currKpiRanking.setFormName(form.getFormName());
            currKpiRanking.setFormPublishTime(form.getFormStartTime());
            currKpiRanking.setFormFactTime(date);
            currKpiRanking.setSupCompanyId(formAndCompany.getSupCompanyId());
            currKpiRanking.setSupCompanySapCode(formAndCompany.getSupCompanySapCode());
            currKpiRanking.setSupCompanyName(formAndCompany.getSupCompanyName());
            currKpiRanking.setSupUserName(formAndCompany.getSupUserName());
            currKpiRanking.setSupUserId(formAndCompany.getSupUserId());
            currKpiRanking.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            currKpiRanking.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setRankingFormCode(lastKpiRanking == null ? "-" : lastKpiRanking.getFormCode());
            currKpiRanking.setCreateTime(new Date());
            currKpiRanking.setLastUpdateTime(new Date());
            currKpiRanking.setLastUpdateUser(kpiForm.getUser().getNickName());
            currKpiRanking.setFormCode(kpiForm.getFormCode());
            currKpiRanking.setTemplateCode(kpiTemplate.getTemplateCode());
            currKpiRanking.setSupCompanySrmCode(formAndCompany.getSupCompanySrmCode());
            currKpiRanking.setRankingScore(lastKpiRanking == null ? null : lastKpiRanking.getRankingScore());
            this.kpiRankingService.insertCustom(currKpiRanking);
        }
    }

    @Override
    @CacheEvict(value={"kpiForm"}, allEntries=true)
    public void releaseKpiFrom(KpiForm kpiForm) {
        if (kpiForm.getFormState() != null && !kpiForm.getFormState().equals(KpiFormStatus.NEW.getValue())) {
            throw new CommonException("\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u53ef\u91cd\u590d\u64cd\u4f5c", "repeat_release");
        }
        Company currentCompany = kpiForm.getCompany();
        User user = kpiForm.getUser();
        KpiForm form = new KpiForm();
        form.setId(kpiForm.getId());
        form.setFormPlanTime(kpiForm.getFormPlanTime());
        form.setFormState(KpiFormStatus.ONGOING.getValue());
        form.setFormPublishTime(new Date());
        this.kpiFormMapper.updateByPrimaryKeySelective(form);
        List<KpiTemplateItem> kpiTemplateItemList = this.queryKpiTemplateItem(kpiForm.getKpiTemplateId());
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.queryCompanyInfoByKpiId(kpiForm.getId());
        for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndCompanyList) && i < kpiFormAndCompanyList.size(); ++i) {
            KpiScore kpiScore = new KpiScore();
            kpiScore.setPurCompanyId(currentCompany.getId());
            kpiScore.setPurCompanyCode(currentCompany.getCompanyCode());
            kpiScore.setPurCompanyName(currentCompany.getCompanyName());
            kpiScore.setPurUserId(user.getId());
            kpiScore.setPurUserName(user.getUsername());
            kpiScore.setKpiFormId(kpiForm.getId());
            kpiScore.setFormCode(kpiForm.getFormCode());
            kpiScore.setFormName(kpiForm.getFormName());
            kpiScore.setSupCompanyId(kpiFormAndCompanyList.get(i).getSupCompanyId());
            kpiScore.setSupCompanySrmCode(kpiFormAndCompanyList.get(i).getSupCompanySrmCode());
            kpiScore.setSupCompanySapCode(kpiFormAndCompanyList.get(i).getSupCompanySapCode());
            kpiScore.setSupCompanyName(kpiFormAndCompanyList.get(i).getSupCompanyName());
            kpiScore.setSupUserId(kpiFormAndCompanyList.get(i).getSupUserId());
            kpiScore.setSupUserName(kpiFormAndCompanyList.get(i).getSupUserName());
            for (int j = 0; CollectionUtils.isNotEmpty(kpiTemplateItemList) && j < kpiTemplateItemList.size(); ++j) {
                kpiScore.setKpiTemplateId(kpiTemplateItemList.get(j).getKpiTemplateId());
                kpiScore.setTemplateCode(kpiTemplateItemList.get(j).getTemplateCode());
                KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(kpiTemplateItemList.get(j).getKpiTemplateId());
                kpiScore.setTemplateName(kpiTemplate.getTemplateName());
                KpiFormAndPersonExample personExample = new KpiFormAndPersonExample();
                personExample.createCriteria().andFormCodeEqualTo(kpiForm.getFormCode()).andProjectTypeEqualTo(kpiTemplateItemList.get(j).getProjectType());
                List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample(personExample);
                if (CollectionUtils.isNotEmpty(kpiFormAndPersonList)) {
                    kpiScore.setPersonUserId(((KpiFormAndPerson)kpiFormAndPersonList.get(0)).getPersonUserId());
                    kpiScore.setPersonUserName(((KpiFormAndPerson)kpiFormAndPersonList.get(0)).getPersonUserName());
                }
                kpiScore.setKpiProjectId(kpiTemplateItemList.get(j).getKpiProjectId());
                kpiScore.setProjectCode(kpiTemplateItemList.get(j).getProjectCode());
                kpiScore.setProjectName(kpiTemplateItemList.get(j).getProjectName());
                kpiScore.setProjectType(kpiTemplateItemList.get(j).getProjectType());
                kpiScore.setProjectHandlType(kpiTemplateItemList.get(j).getProjectHandlType());
                kpiScore.setProjectMethodType(kpiTemplateItemList.get(j).getProjectMethodType());
                kpiScore.setProjectMethodParameter(kpiTemplateItemList.get(j).getProjectMethodParameter());
                kpiScore.setProjectTypeName(kpiTemplateItemList.get(j).getProjectTypeName());
                kpiScore.setProjectWeight(kpiTemplateItemList.get(j).getProjectWeight());
                kpiScore.setScoreState(Constant.NO_INT.toString());
                kpiScore.setCreateTime(new Date());
                kpiScore.setId(null);
                this.kpiScoreService.addObj(kpiScore);
            }
        }
    }

    @Override
    public KpiFormVo lookAtTheScore(KpiForm kpiForm) {
        KpiFormVo kpiFormVo = new KpiFormVo();
        kpiFormVo.setKpiFormId(kpiForm.getId());
        kpiFormVo.setFormCode(kpiForm.getFormCode());
        kpiFormVo.setFormName(kpiForm.getFormName());
        kpiFormVo.setKpiTemplateId(kpiForm.getKpiTemplateId());
        kpiFormVo.setTemplateCode(kpiForm.getTemplateCode());
        kpiFormVo.setFormStartTime(kpiForm.getFormStartTime());
        kpiFormVo.setFormEndTime(kpiForm.getFormEndTime());
        KpiFormVo stateAndPersonAndWeight = this.queryStateAndPersonAndWeight(kpiForm);
        kpiFormVo.setScoreState(stateAndPersonAndWeight.getScoreState());
        kpiFormVo.setScorePerson(stateAndPersonAndWeight.getScorePerson());
        kpiFormVo.setClassWeight(stateAndPersonAndWeight.getClassWeight());
        kpiFormVo.setCreateTime(kpiForm.getCreateTime());
        kpiFormVo.setFormPlanTime(kpiForm.getFormPlanTime());
        KpiTemplate kpiTemplate = (KpiTemplate)this.kpiTemplateService.queryObjById(kpiForm.getKpiTemplateId());
        if (kpiTemplate != null) {
            kpiFormVo.setPurCompanyCategory(kpiTemplate.getPurCompanyCategory());
            kpiFormVo.setPurCompanyRank(kpiTemplate.getPurCompanyRank());
        }
        KpiFormVo kFormVo = this.assembleKpiFormData(kpiForm, kpiFormVo);
        return kFormVo;
    }

    @Override
    public KpiFormVo importEvaluateSrmData(KpiForm kpiForm) {
        KpiFormVo kpiFormVo = new KpiFormVo();
        kpiFormVo.setKpiFormId(kpiForm.getId());
        kpiFormVo.setFormCode(kpiForm.getFormCode());
        kpiFormVo.setKpiTemplateId(kpiForm.getKpiTemplateId());
        kpiFormVo.setTemplateCode(kpiForm.getTemplateCode());
        kpiFormVo.setFormStartTime(kpiForm.getFormStartTime());
        kpiFormVo.setFormEndTime(kpiForm.getFormEndTime());
        KpiFormVo kFormVo = this.importEvaluateSrmData(kpiForm, kpiFormVo);
        return kFormVo;
    }

    private KpiFormVo queryStateAndPersonAndWeight(KpiForm kpiForm) {
        StringBuffer weightBuffer;
        KpiFormVo kpiFormVo = new KpiFormVo();
        ArrayList<String> scoreStateList = new ArrayList<String>();
        KpiScoreExample kpiScoreExample = new KpiScoreExample();
        KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
        criteria.andFormCodeEqualTo(kpiForm.getFormCode());
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager") && !roleCodeList.contains("supplier") && "0".equals(kpiForm.getIsScoreBySupPower())) {
            criteria.andPersonUserIdEqualTo(kpiForm.getUser().getId());
        }
        List kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
        for (int i = 0; CollectionUtils.isNotEmpty(kpiScoreList) && i < kpiScoreList.size(); ++i) {
            scoreStateList.add(((KpiScore)kpiScoreList.get(i)).getScoreState());
        }
        if (CollectionUtils.isNotEmpty(scoreStateList)) {
            if (Collections.frequency(scoreStateList, "1") == scoreStateList.size()) {
                kpiFormVo.setScoreState(Constant.YES_INT.toString());
            } else {
                kpiFormVo.setScoreState(Constant.NO_INT.toString());
            }
        }
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier"))) {
            kpiFormVo.setScorePerson(kpiForm.getUser().getNickName() == null ? "\u3010" + kpiForm.getUser().getLoginName() + "\u3011" : kpiForm.getUser().getNickName() + "\u3010" + kpiForm.getUser().getLoginName() + "\u3011");
        } else {
            List<KpiFormAndPerson> infoByKpiId = this.queryPersonInfoByKpiId(kpiForm.getId());
            ArrayList<String> stringList = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty(infoByKpiId)) {
                for (KpiFormAndPerson kpiFormAndPerson : infoByKpiId) {
                    com.els.base.core.entity.user.User user = (com.els.base.core.entity.user.User)this.userService.queryObjById(kpiFormAndPerson.getPersonUserId());
                    stringList.add(kpiFormAndPerson.getPersonUserName() == null ? "\u3010" + user.getLoginName() + "\u3011" : kpiFormAndPerson.getPersonUserName() + "\u3010" + user.getLoginName() + "\u3011");
                }
                kpiFormVo.setScorePerson(((Object)stringList).toString().replaceAll("[\\[\\]]", ""));
            }
        }
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier"))) {
            KpiFormAndPersonExample example = new KpiFormAndPersonExample();
            example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId()).andKpiFormIdEqualTo(kpiForm.getId());
            List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample(example);
            weightBuffer = new StringBuffer();
            for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); ++i) {
                KpiTemplateWeightExample weightExample = new KpiTemplateWeightExample();
                weightExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId()).andProjectTypeEqualTo(((KpiFormAndPerson)kpiFormAndPersonList.get(i)).getProjectType());
                List kpiTemplateWeightList = this.kpiTemplateWeightService.queryAllObjByExample(weightExample);
                for (int j = 0; CollectionUtils.isNotEmpty(kpiTemplateWeightList) && j < kpiTemplateWeightList.size(); ++j) {
                    weightBuffer.append("\u3010").append(((KpiTemplateWeight)kpiTemplateWeightList.get(j)).getProjectTypeName()).append("\u3011").append(":").append(((KpiTemplateWeight)kpiTemplateWeightList.get(j)).getProjectTypeWeight()).append(",");
                }
            }
            if (!weightBuffer.toString().equals("")) {
                kpiFormVo.setClassWeight(weightBuffer.deleteCharAt(weightBuffer.length() - 1).toString());
            }
        } else {
            KpiTemplateWeightExample weightExample = new KpiTemplateWeightExample();
            weightExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId());
            List kpiTemplateWeightList = this.kpiTemplateWeightService.queryAllObjByExample(weightExample);
            weightBuffer = new StringBuffer();
            for (int i = 0; CollectionUtils.isNotEmpty(kpiTemplateWeightList) && i < kpiTemplateWeightList.size(); ++i) {
                weightBuffer.append("\u3010").append(((KpiTemplateWeight)kpiTemplateWeightList.get(i)).getProjectTypeName()).append("\u3011").append(":").append(((KpiTemplateWeight)kpiTemplateWeightList.get(i)).getProjectTypeWeight()).append(",");
            }
            if (!weightBuffer.toString().equals("")) {
                kpiFormVo.setClassWeight(weightBuffer.deleteCharAt(weightBuffer.length() - 1).toString());
            }
        }
        return kpiFormVo;
    }

    private KpiFormVo assembleKpiFormData(KpiForm kpiForm, KpiFormVo kpiFormVo) {
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        List<Object> kpiTemplateItemList = new ArrayList();
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier"))) {
            if ("0".equals(kpiForm.getIsScoreBySupPower())) {
                KpiFormAndPersonExample example = new KpiFormAndPersonExample();
                example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId()).andKpiFormIdEqualTo(kpiForm.getId());
                List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample(example);
                for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); ++i) {
                    KpiTemplateItemExample kpiTemplateItemExample = new KpiTemplateItemExample();
                    kpiTemplateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId()).andProjectTypeEqualTo(((KpiFormAndPerson)kpiFormAndPersonList.get(i)).getProjectType());
                    kpiTemplateItemList.addAll(this.kpiTemplateItemService.queryAllObjByExample(kpiTemplateItemExample));
                }
            } else {
                kpiTemplateItemList = this.queryKpiTemplateItem(kpiForm.getKpiTemplateId());
            }
        } else if (CollectionUtils.isEmpty(kpiTemplateItemList)) {
            kpiTemplateItemList = this.queryKpiTemplateItem(kpiForm.getKpiTemplateId());
        }
        ArrayList<Map<String, String>> titles = new ArrayList();
        StringBuffer titleBuffer = new StringBuffer();
        if (CollectionUtils.isNotEmpty(kpiTemplateItemList)) {
            for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
                HashMap<String, String> titleMap = new HashMap<String, String>();
                titleBuffer.setLength(0);
                titleBuffer.append("\u3010").append(kpiTemplateItem.getProjectTypeName()).append("\u3011").append(kpiTemplateItem.getProjectName());
                titleMap.put("projectType", kpiTemplateItem.getProjectType());
                titleMap.put("projectCode", kpiTemplateItem.getProjectCode());
                titleMap.put("projectName", titleBuffer.toString());
                titleMap.put("projectStandard", kpiTemplateItem.getProjectStandard());
                titleMap.put("projectInstruction", kpiTemplateItem.getProjectInstruction());
                titleMap.put("projectWeight", kpiTemplateItem.getProjectWeight());
                KpiProjectExample kpiProjectExample = new KpiProjectExample();
                kpiProjectExample.createCriteria().andProjectCodeEqualTo(kpiTemplateItem.getProjectCode());
                List KpiProjectList = this.kpiProjectService.queryAllObjByExample(kpiProjectExample);
                if (CollectionUtils.isNotEmpty(KpiProjectList) && ((KpiProject)KpiProjectList.get(0)).getProjectHandlType() != null && ((KpiProject)KpiProjectList.get(0)).getProjectHandlType().equals("2")) {
                    titleMap.put("getOfApi", "Y");
                }
                titleMap.put("latitude", ((KpiProject)KpiProjectList.get(0)).getProjectDimension());
                titles.add(titleMap);
            }
        }
        List<KpiFormAndCompany> kpiFormAndCompanyList = this.queryCompanyInfoByKpiId(kpiForm.getId());
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (KpiFormAndCompany kpiFormAndCompany : kpiFormAndCompanyList) {
            HashMap<String, Object> kpiFormVoItem = new HashMap<String, Object>();
            List<KpiScore> scoreList = this.getScore(kpiForm, kpiFormAndCompany, kpiTemplateItemList);
            if (!CollectionUtils.isNotEmpty(scoreList)) continue;
            for (KpiScore score : scoreList) {
                kpiFormVoItem.put("supplierSrmCode", kpiFormAndCompany.getSupCompanySrmCode());
                kpiFormVoItem.put("supplierSrmName", kpiFormAndCompany.getSupCompanyName());
                kpiFormVoItem.put(score.getProjectCode(), score.getScoreScore() == null ? null : new BigDecimal(score.getScoreScore()));
            }
            arrayList.add(kpiFormVoItem);
        }
        titles = titles.stream().sorted(Comparator.comparing(map -> (String)map.get("projectType"))).collect(Collectors.toList());
        kpiFormVo.setTitles(titles);
        kpiFormVo.setKpiFormVoItemList(arrayList);
        return kpiFormVo;
    }

    private KpiFormVo importEvaluateSrmData(KpiForm kpiForm, KpiFormVo kpiFormVo) {
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        List<Object> kpiTemplateItemList = new ArrayList();
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier"))) {
            if ("0".equals(kpiForm.getIsScoreBySupPower())) {
                KpiFormAndPersonExample example = new KpiFormAndPersonExample();
                example.createCriteria().andPersonUserIdEqualTo(kpiForm.getUser().getId()).andKpiFormIdEqualTo(kpiForm.getId());
                List kpiFormAndPersonList = this.kpiFormAndPersonService.queryAllObjByExample(example);
                for (int i = 0; CollectionUtils.isNotEmpty(kpiFormAndPersonList) && i < kpiFormAndPersonList.size(); ++i) {
                    KpiTemplateItemExample kpiTemplateItemExample = new KpiTemplateItemExample();
                    kpiTemplateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiForm.getKpiTemplateId()).andProjectTypeEqualTo(((KpiFormAndPerson)kpiFormAndPersonList.get(i)).getProjectType());
                    kpiTemplateItemList.addAll(this.kpiTemplateItemService.queryAllObjByExample(kpiTemplateItemExample));
                }
            } else {
                kpiTemplateItemList = this.queryKpiTemplateItem(kpiForm.getKpiTemplateId());
            }
        } else if (CollectionUtils.isEmpty(kpiTemplateItemList)) {
            kpiTemplateItemList = this.queryKpiTemplateItem(kpiForm.getKpiTemplateId());
        }
        ArrayList<Map<String, String>> titles = new ArrayList();
        StringBuffer titleBuffer = new StringBuffer();
        if (CollectionUtils.isNotEmpty(kpiTemplateItemList)) {
            for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
                if (kpiTemplateItem.getProjectHandlType() == null || !kpiTemplateItem.getProjectHandlType().equals("2")) continue;
                HashMap<String, String> titleMap = new HashMap<String, String>();
                titleBuffer.setLength(0);
                titleBuffer.append("\u3010").append(kpiTemplateItem.getProjectTypeName()).append("\u3011").append(kpiTemplateItem.getProjectName());
                titleMap.put("projectType", kpiTemplateItem.getProjectType());
                titleMap.put("projectCode", kpiTemplateItem.getProjectCode());
                titleMap.put("projectName", titleBuffer.toString());
                titleMap.put("projectStandard", "");
                titleMap.put("projectInstruction", "");
                titleMap.put("projectWeight", kpiTemplateItem.getProjectWeight());
                titleMap.put("getOfApi", "Y");
                titles.add(titleMap);
            }
        }
        KpiFormAndCompanyExample example = new KpiFormAndCompanyExample();
        example.createCriteria().andKpiFormIdEqualTo(kpiForm.getId());
        List list = this.kpiFormAndCompanyService.queryAllObjByExample(example);
        DecimalFormat df = new DecimalFormat("0.00");
        ArrayList<Map<String, Object>> kpiFormVoItemList = new ArrayList<Map<String, Object>>();
        for (KpiFormAndCompany kpiFormAndCompany : list) {
            HashMap<String, Object> kpiFormVoItem = new HashMap<String, Object>();
            List<KpiScore> scoreList = this.getImportEvaluateSrmScore(kpiForm, kpiFormAndCompany, kpiTemplateItemList);
            for (KpiScore score : scoreList) {
                kpiFormVoItem.put("supplierSrmCode", kpiFormAndCompany.getSupCompanySrmCode());
                kpiFormVoItem.put("supplierSrmName", kpiFormAndCompany.getSupCompanyName());
                KpiAdverseEventExample kpiAdverseEventExample = new KpiAdverseEventExample();
                KpiAdverseEventExample.Criteria criteria = kpiAdverseEventExample.createCriteria();
                criteria.andSupCompanyIdEqualTo(score.getSupCompanyId());
                criteria.andProjectTypeEqualTo(score.getProjectType());
                criteria.andProjectCodeEqualTo(score.getProjectCode());
                criteria.andStartTimeBetween(kpiForm.getFormStartTime(), kpiForm.getFormEndTime());
                ArrayList<String> statusList = new ArrayList<String>();
                statusList.add("0");
                statusList.add("1");
                statusList.add("2");
                statusList.add("3");
                criteria.andStatusIn(statusList);
                List kpiAdverseEvenList = this.kpiAdverseEventService.queryAllObjByExample(kpiAdverseEventExample);
                double sum = kpiAdverseEvenList.stream().mapToDouble(kpi -> Double.valueOf(kpi.getPoints())).sum();
                double scoreScore = Double.valueOf(score.getProjectWeight()) - sum;
                kpiFormVoItem.put(score.getProjectCode(), scoreScore < 0.0 ? 0.0 : scoreScore);
            }
            kpiFormVoItemList.add(kpiFormVoItem);
        }
        titles = titles.stream().sorted(Comparator.comparing(map -> (String)map.get("projectType"))).collect(Collectors.toList());
        kpiFormVo.setTitles(titles);
        kpiFormVo.setKpiFormVoItemList(kpiFormVoItemList);
        return kpiFormVo;
    }

    private List<KpiScore> getScore(KpiForm kpiForm, KpiFormAndCompany kpiFormAndCompany, List<KpiTemplateItem> kpiTemplateItemList) {
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        ArrayList<KpiScore> scoreList = new ArrayList<KpiScore>();
        for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
            criteria.andSupCompanyIdEqualTo(kpiFormAndCompany.getSupCompanyId());
            criteria.andProjectCodeEqualTo(kpiTemplateItem.getProjectCode());
            criteria.andKpiTemplateIdEqualTo(kpiTemplateItem.getKpiTemplateId());
            criteria.andKpiFormIdEqualTo(kpiFormAndCompany.getKpiFormId());
            if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager") && !roleCodeList.contains("supplier") && "1".equals(kpiForm.getIsScoreBySupPower())) {
                criteria.andSupCompanyIdIn((List)kpiForm.getPurManageCompanyIdList());
            }
            List kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
            scoreList.addAll(kpiScoreList);
        }
        return scoreList;
    }

    private List<KpiScore> getImportEvaluateSrmScore(KpiForm kpiForm, KpiFormAndCompany kpiFormAndCompany, List<KpiTemplateItem> kpiTemplateItemList) {
        List<String> roleCodeList = kpiForm.getRoleCodeList();
        ArrayList<KpiScore> scoreList = new ArrayList<KpiScore>();
        for (KpiTemplateItem kpiTemplateItem : kpiTemplateItemList) {
            if (kpiTemplateItem.getProjectHandlType() == null || !kpiTemplateItem.getProjectHandlType().equals("2")) continue;
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            KpiScoreExample.Criteria criteria = kpiScoreExample.createCriteria();
            criteria.andSupCompanyIdEqualTo(kpiFormAndCompany.getSupCompanyId());
            criteria.andProjectCodeEqualTo(kpiTemplateItem.getProjectCode());
            criteria.andKpiTemplateIdEqualTo(kpiTemplateItem.getKpiTemplateId());
            criteria.andKpiFormIdEqualTo(kpiFormAndCompany.getKpiFormId());
            if (!roleCodeList.contains("systemManager") && !roleCodeList.contains("manager") && !roleCodeList.contains("supplier") && "1".equals(kpiForm.getIsScoreBySupPower())) {
                criteria.andSupCompanyIdIn((List)kpiForm.getPurManageCompanyIdList());
            }
            List kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
            scoreList.addAll(kpiScoreList);
        }
        return scoreList;
    }

    @Override
    public List<KpiTemplateItem> queryKpiTemplateItem(String kpiTemplateId) {
        KpiTemplateItemExample templateItemExample = new KpiTemplateItemExample();
        templateItemExample.createCriteria().andKpiTemplateIdEqualTo(kpiTemplateId);
        List<KpiTemplateItem> kpiTemplateItemList = this.kpiTemplateItemService.queryAllObjByExample(templateItemExample);
        return kpiTemplateItemList;
    }

    @Override
    public KpiForm lookKpiFormDetails(String kpiFormId) {
        KpiForm form = this.kpiFormMapper.selectByPrimaryKey(kpiFormId);
        form.setKpiFormAndCompanyList(this.queryCompanyInfoByKpiId(kpiFormId));
        form.setKpiFormAndPersonList(this.queryPersonInfoByKpiId(kpiFormId));
        return form;
    }

    @Override
    public void saveAtTheScore(KpiFormVo kpiFormVo, String saveOrSubmit) {
        List<Map<String, Object>> kpiFormVoItemList = kpiFormVo.getKpiFormVoItemList();
        ArrayList<KpiScore> kpiScores = new ArrayList<KpiScore>();
        for (Map<String, Object> map : kpiFormVoItemList) {
            KpiScore kpiScore = new KpiScore();
            String supplierSrmCode = (String)map.get("supplierSrmCode");
            map.remove("supplierSrmCode");
            map.remove("supplierSrmName");
            kpiScore.setSupCompanySrmCode(supplierSrmCode);
            kpiScore.setFormCode(kpiFormVo.getFormCode());
            for (String key : map.keySet()) {
                kpiScore.setProjectCode(key);
                kpiScore.setScoreScore(map.get(key) == null ? null : map.get(key).toString());
                kpiScore.setLastUpdateUser(kpiFormVo.getUser().getNickName());
                kpiScores.add(kpiScore);
                this.updateKpiScoreData(kpiScores, saveOrSubmit);
            }
        }
    }

    private void updateKpiScoreData(List<KpiScore> kpiScores, String saveOrSubmit) {
        for (int i = 0; CollectionUtils.isNotEmpty(kpiScores) && i < kpiScores.size(); ++i) {
            KpiScoreExample kpiScoreExample = new KpiScoreExample();
            kpiScoreExample.createCriteria().andSupCompanySrmCodeEqualTo(kpiScores.get(i).getSupCompanySrmCode()).andFormCodeEqualTo(kpiScores.get(i).getFormCode()).andProjectCodeEqualTo(kpiScores.get(i).getProjectCode());
            List kpiScoreList = this.kpiScoreService.queryAllObjByExample(kpiScoreExample);
            for (int j = 0; CollectionUtils.isNotEmpty(kpiScoreList) && j < kpiScoreList.size(); ++j) {
                KpiScore kpiScore = new KpiScore();
                kpiScore.setId(((KpiScore)kpiScoreList.get(j)).getId());
                kpiScore.setScoreScore(kpiScores.get(i).getScoreScore());
                kpiScore.setLastUpdateTime(new Date());
                kpiScore.setLastUpdateUser(kpiScores.get(i).getLastUpdateUser());
                if (saveOrSubmit.equals("submit")) {
                    kpiScore.setScoreState(Constant.YES_INT.toString());
                }
                this.kpiScoreService.modifyObj(kpiScore);
            }
        }
    }

    @Override
    @CacheEvict(value={"company"}, allEntries=true)
    public void rankAdjustMent(String supplierSrmCode, String classLevel) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(supplierSrmCode);
        List companyList = this.companyService.queryAllObjByExample(companyExample);
        for (int i = 0; CollectionUtils.isNotEmpty(companyList) && i < companyList.size(); ++i) {
            Company company = new Company();
            company.setId(((Company)companyList.get(i)).getId());
            company.setGrade(classLevel);
            this.companyService.modifyObj(company);
        }
    }

    @Override
    public String getSRMKpiScore(String sapCompanyCode, Date startTime, Date endTime, String projectDimension) {
        KpiAdverseEventExample eventExample = new KpiAdverseEventExample();
        eventExample.createCriteria().andSupplierSapCodeEqualTo(sapCompanyCode).andStartTimeEqualTo(startTime).andEndTimeEqualTo(endTime).andMatterEqualTo(projectDimension);
        List kpiAdverseEventList = this.kpiAdverseEventService.queryAllObjByExample(eventExample);
        int points = 0;
        for (int i = 0; CollectionUtils.isNotEmpty(kpiAdverseEventList) && i < kpiAdverseEventList.size(); ++i) {
            String point = ((KpiAdverseEvent)kpiAdverseEventList.get(i)).getPoints() == null ? "0" : ((KpiAdverseEvent)kpiAdverseEventList.get(i)).getPoints();
            points = Integer.parseInt(point) + points;
        }
        return String.valueOf(points);
    }

    @Override
    public List<KpiForm> queryfinalKpiForms(List<String> srmCompanyIdList, List<String> roleCodeList, User loginUser, List<KpiForm> queryAllObjByExample) {
        ArrayList<KpiForm> finalKpiForms = new ArrayList();
        if (!(roleCodeList.contains("systemManager") || roleCodeList.contains("manager") || roleCodeList.contains("supplier"))) {
            for (int i = 0; CollectionUtils.isNotEmpty(queryAllObjByExample) && i < queryAllObjByExample.size(); ++i) {
                KpiForm kpiForm = queryAllObjByExample.get(i);
                List<String> stringIds = this.kpiFormAndCompanyService.queryCompanyIdsByFormCode(kpiForm.getFormCode());
                boolean anyMatch = stringIds.stream().anyMatch(id -> srmCompanyIdList.stream().anyMatch(id2 -> id2.equals(id)));
                if (StringUtils.isNotBlank((String)kpiForm.getIsScoreBySupPower()) && kpiForm.getIsScoreBySupPower().equals("1") && !anyMatch) continue;
                finalKpiForms.add(kpiForm);
            }
        } else {
            finalKpiForms = queryAllObjByExample;
        }
        return finalKpiForms;
    }

    @Override
    public ReportShow queryMonthlyReport(ReportQueryParams reportQueryParams) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String monthStart = reportQueryParams.getMonthStart() + "-10";
            reportQueryParams.setMonthStart(sdf.format(sdf.parse(monthStart)));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        KpiTemplateExample templateExample = new KpiTemplateExample();
        KpiTemplateExample.Criteria template = templateExample.createCriteria();
        if (StringUtils.isNotBlank((String)reportQueryParams.getTemplateCode())) {
            template.andTemplateCodeEqualTo(reportQueryParams.getTemplateCode());
        }
        templateExample.setOrderByClause("CREATE_TIME DESC");
        List kpiTemplates = this.kpiTemplateService.queryAllObjByExample(templateExample);
        if (CollectionUtils.isEmpty(kpiTemplates)) {
            return new ReportShow();
        }
        reportQueryParams.setTemplateCode(((KpiTemplate)kpiTemplates.get(0)).getTemplateCode());
        List<KpiReport> reportList = this.kpiFormMapper.queryMonthlyReport(reportQueryParams);
        ReportShow monthlyReportShow = new ReportShow();
        ArrayList<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> dataToTypeMapList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            HashMap<String, String> titleMapFristList = new HashMap<String, String>();
            titleMapFristList.put("projectType", reportList.get(i).getProjectType());
            titleMapFristList.put("projectTypeName", reportList.get(i).getProjectTypeName());
            fristTitleList.add(titleMapFristList);
            HashMap<String, String> titleMapSecondList = new HashMap<String, String>();
            titleMapSecondList.put("projectType", reportList.get(i).getProjectType());
            titleMapSecondList.put("projectCode", reportList.get(i).getProjectCode());
            titleMapSecondList.put("projectName", reportList.get(i).getProjectName());
            secondTitleList.add(titleMapSecondList);
            HashMap<String, String> mapFinalData = new HashMap<String, String>();
            mapFinalData.put("projectCode", reportList.get(i).getProjectCode());
            mapFinalData.put("matter", reportList.get(i).getMatter());
            mapFinalData.put("points", reportList.get(i).getPoints());
            mapFinalData.put("supCompanyId", reportList.get(i).getSupCompanyId());
            mapFinalData.put("totalScore", reportList.get(i).getTotalScore());
            dataToTypeMapList.add(mapFinalData);
        }
        monthlyReportShow.setFristTitleList(this.removalOfRepetitionList(fristTitleList, "projectType"));
        monthlyReportShow.setSecondTitleList(this.removalOfRepetitionList(secondTitleList, "projectCode"));
        TreeSet<KpiReport> personSet = new TreeSet<KpiReport>((o1, o2) -> o1.getSupCompanyId().compareTo(o2.getSupCompanyId()));
        personSet.addAll(reportList);
        ArrayList<KpiReport> finalDataList = new ArrayList<KpiReport>(personSet);
        for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String supCompanyId = ((KpiReport)finalDataList.get(i)).getSupCompanyId();
            KpiReport kpiMonthReport = (KpiReport)finalDataList.get(i);
            kpiMonthReport.setDataToTypeMapList(this.selectPointsOfSupCompanyIdScore(supCompanyId, dataToTypeMapList));
        }
        monthlyReportShow.setFinalDataList(finalDataList);
        return monthlyReportShow;
    }

    private List<Map<String, String>> selectPointsOfSupCompanyId(String supCompanyId, List<Map<String, String>> dataToTypeMapList, String isTotalScore) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        for (int j = 0; CollectionUtils.isNotEmpty(dataToTypeMapList) && j < dataToTypeMapList.size(); ++j) {
            Map<String, String> map = dataToTypeMapList.get(j);
            if (StringUtils.isBlank((String)map.get("supCompanyId")) || !map.get("supCompanyId").equals(supCompanyId)) continue;
            maps.add(map);
        }
        if ("Y".equals(isTotalScore)) {
            Double score = maps.stream().filter(line -> !"supRank".equals(line.get("projectType"))).mapToDouble(kpi -> Double.valueOf((String)kpi.get("projectCodeScore"))).sum();
            HashMap<String, String> supScore = new HashMap<String, String>();
            supScore.put("projectType", "supScore");
            supScore.put("projectTypeName", "\u6700\u7ec8\u5f97\u5206");
            supScore.put("projectCodeScore", score + "");
            supScore.put("supCompanyId", supCompanyId);
            maps.add(supScore);
        }
        return maps;
    }

    private List<Map<String, String>> selectPointsOfSupCompanyIdScore(String supCompanyId, List<Map<String, String>> dataToTypeMapList) {
        ArrayList<Map<String, String>> maps = new ArrayList();
        for (int j = 0; CollectionUtils.isNotEmpty(dataToTypeMapList) && j < dataToTypeMapList.size(); ++j) {
            Map<String, String> map = dataToTypeMapList.get(j);
            if (StringUtils.isBlank((String)map.get("supCompanyId")) || !map.get("supCompanyId").equals(supCompanyId)) continue;
            if (StringUtils.isNotBlank((String)map.get("matter"))) {
                maps.add(map);
            }
            if (StringUtils.isBlank((String)map.get("projectCode"))) continue;
            String totalScore = "totalScore";
            boolean isContain = false;
            for (int k = 0; k < maps.size(); ++k) {
                Map newMap = (Map)maps.get(k);
                if (!((String)newMap.get("projectCode")).equals(map.get("projectCode")) || !totalScore.equals(newMap.get("matter"))) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            HashMap<String, String> mapScore = new HashMap<String, String>();
            mapScore.put("projectCode", map.get("projectCode"));
            mapScore.put("matter", totalScore);
            mapScore.put("points", map.get("totalScore"));
            mapScore.put("supCompanyId", map.get("supCompanyId"));
            mapScore.put("totalScore", map.get("totalScore"));
            maps.add(mapScore);
        }
        maps = maps.stream().sorted(Comparator.comparing(KpiFormServiceImpl::comparingByProjectCode).thenComparing(Comparator.comparing(KpiFormServiceImpl::comparingByMatter))).collect(Collectors.toList());
        return maps;
    }

    private static String comparingByProjectCode(Map<String, String> map) {
        return map.get("projectCode");
    }

    private static String comparingByMatter(Map<String, String> map) {
        return map.get("matter") == null ? "0" : map.get("matter");
    }

    private List<Map<String, String>> removalOfRepetitionList(List<Map<String, String>> titleList, String string) {
        ArrayList<Map<String, String>> newList = new ArrayList<Map<String, String>>();
        for (int i = 0; CollectionUtils.isNotEmpty(titleList) && i < titleList.size(); ++i) {
            Map<String, String> oldMap = titleList.get(i);
            if (StringUtils.isBlank((String)oldMap.get(string))) continue;
            if (newList.size() > 0) {
                boolean isContain = false;
                for (int j = 0; j < newList.size(); ++j) {
                    Map newMap = (Map)newList.get(j);
                    if (!((String)newMap.get(string)).equals(oldMap.get(string))) continue;
                    for (String key : oldMap.keySet()) {
                        newMap.put(key, oldMap.get(key));
                    }
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                newList.add(oldMap);
                continue;
            }
            newList.add(oldMap);
        }
        return newList;
    }

    @Override
    public void toVoidDocument(String id) {
        KpiForm kpiForm = new KpiForm();
        kpiForm.setId(id);
        kpiForm.setFormState("3");
        this.kpiFormMapper.updateByPrimaryKeySelective(kpiForm);
    }

    @Override
    public ReportShow queryQuarterOrYearReport(ReportQueryParams reportQueryParams) {
        KpiTemplateExample templateExample = new KpiTemplateExample();
        KpiTemplateExample.Criteria template = templateExample.createCriteria();
        if (StringUtils.isNotBlank((String)reportQueryParams.getTemplateCode())) {
            template.andTemplateCodeEqualTo(reportQueryParams.getTemplateCode());
        }
        templateExample.setOrderByClause("CREATE_TIME DESC");
        List kpiTemplates = this.kpiTemplateService.queryAllObjByExample(templateExample);
        if (CollectionUtils.isEmpty(kpiTemplates)) {
            return new ReportShow();
        }
        reportQueryParams.setTemplateCode(((KpiTemplate)kpiTemplates.get(0)).getTemplateCode());
        ReportShow quarterReportShow = new ReportShow();
        List<Object> reportList = new ArrayList();
        if (StringUtils.isNotBlank((String)reportQueryParams.getYear())) {
            reportList = this.kpiFormMapper.queryYearReport(reportQueryParams);
        } else {
            String quarter = reportQueryParams.getQuarter();
            String monthSrart = null;
            Calendar date = Calendar.getInstance();
            String year = String.valueOf(date.get(1));
            switch (quarter) {
                case "1": {
                    monthSrart = "-02-01";
                    break;
                }
                case "2": {
                    monthSrart = "-05-01";
                    break;
                }
                case "3": {
                    monthSrart = "-08-01";
                    break;
                }
                case "4": {
                    monthSrart = "-11-01";
                }
            }
            reportQueryParams.setQuarterAnyDay(year + monthSrart);
            reportList = this.kpiFormMapper.queryQuarterReport(reportQueryParams);
        }
        ArrayList<Map<String, String>> fristTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> secondTitleList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> supStatusList = new ArrayList<Map<String, String>>();
        ArrayList supStatusDevelList = new ArrayList();
        for (int i = 0; CollectionUtils.isNotEmpty(reportList) && i < reportList.size(); ++i) {
            KpiReport kpiquarterReport = (KpiReport)reportList.get(i);
            String projectType = kpiquarterReport.getProjectType();
            String projectCode = kpiquarterReport.getProjectCode();
            HashMap<String, String> titleMapFristList = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)projectType)) {
                titleMapFristList.put("projectType", projectType);
                titleMapFristList.put("projectTypeName", kpiquarterReport.getProjectTypeName());
                fristTitleList.add(titleMapFristList);
            }
            HashMap<String, String> titleMapSecondList = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)projectCode)) {
                titleMapSecondList.put("projectType", projectType);
                titleMapSecondList.put("projectCode", projectCode);
                titleMapSecondList.put("projectName", kpiquarterReport.getProjectName());
                titleMapSecondList.put("projectCodeScore", kpiquarterReport.getProjectCodeScore());
                titleMapSecondList.put("supCompanyId", kpiquarterReport.getSupCompanyId());
                secondTitleList.add(titleMapSecondList);
            }
            HashMap<String, String> supStatusType = new HashMap<String, String>();
            if (StringUtils.isBlank((String)projectCode) && StringUtils.isNotBlank((String)projectType)) {
                supStatusType.put("projectType", projectType);
                supStatusType.put("projectTypeName", kpiquarterReport.getProjectTypeName());
                supStatusType.put("projectCodeScore", kpiquarterReport.getProjectCodeScore());
                supStatusType.put("supCompanyId", kpiquarterReport.getSupCompanyId());
                supStatusList.add(supStatusType);
            }
            HashMap<String, String> supStatusDevel = new HashMap<String, String>();
            HashMap<String, String> supRank = new HashMap<String, String>();
            if (!StringUtils.isBlank((String)projectCode) || !StringUtils.isBlank((String)projectType)) continue;
            supStatusDevel.put("devel", kpiquarterReport.getProjectCodeScore());
            supStatusDevel.put("supCompanyId", kpiquarterReport.getSupCompanyId());
            supStatusDevelList.add(supStatusDevel);
            supRank.put("projectType", "supRank");
            supRank.put("projectTypeName", "\u7b49\u7ea7");
            supRank.put("projectCodeScore", kpiquarterReport.getProjectCodeScore());
            supRank.put("supCompanyId", kpiquarterReport.getSupCompanyId());
            supStatusList.add(supRank);
        }
        quarterReportShow.setFristTitleList(this.removalOfRepetitionList(fristTitleList, "projectType"));
        TreeSet<Object> personSet = new TreeSet<Object>((o1, o2) -> o1.getSupCompanyId().compareTo(o2.getSupCompanyId()));
        personSet.addAll(reportList);
        ArrayList<KpiReport> finalDataList = new ArrayList<KpiReport>(personSet);
        block13: for (int i = 0; CollectionUtils.isNotEmpty(finalDataList) && i < finalDataList.size(); ++i) {
            String supCompanyId = ((KpiReport)finalDataList.get(i)).getSupCompanyId();
            KpiReport kpiquarterReport = (KpiReport)finalDataList.get(i);
            kpiquarterReport.setDataToTypeMapList(this.selectPointsOfSupCompanyId(supCompanyId, secondTitleList, "N"));
            kpiquarterReport.setProjectTypeList(this.selectPointsOfSupCompanyId(supCompanyId, supStatusList, "Y"));
            for (int j = 0; CollectionUtils.isNotEmpty(supStatusDevelList) && j < supStatusDevelList.size(); ++j) {
                if (!supCompanyId.equals(((Map)supStatusDevelList.get(j)).get("supCompanyId"))) continue;
                kpiquarterReport.setDevel((String)((Map)supStatusDevelList.get(j)).get("devel"));
                continue block13;
            }
        }
        quarterReportShow.setFinalDataList(finalDataList);
        return quarterReportShow;
    }
}

