/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiScoreMapper;
import com.els.base.performance.entity.KpiScore;
import com.els.base.performance.entity.KpiScoreExample;
import com.els.base.performance.service.KpiScoreService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultKpiScoreService")
public class KpiScoreServiceImpl
implements KpiScoreService {
    @Resource
    protected KpiScoreMapper kpiScoreMapper;

    @Override
    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void addObj(KpiScore t) {
        this.kpiScoreMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiScoreMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiScore"}, allEntries=true)
    public void modifyObj(KpiScore t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.kpiScoreMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"kpiScore"}, keyGenerator="redisKeyGenerator")
    public KpiScore queryObjById(String id) {
        return this.kpiScoreMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"kpiScore"}, keyGenerator="redisKeyGenerator")
    public List<KpiScore> queryAllObjByExample(KpiScoreExample example) {
        return this.kpiScoreMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"kpiScore"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiScore> queryObjByPage(KpiScoreExample example) {
        PageView<KpiScore> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiScoreMapper.selectByExampleByPage(example));
        return pageView;
    }
}

