/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.entity.vo.KpiRankingVo;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiRankingService;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7ee9\u6548\u7ba1\u7406-\u6392\u540d\u8868")
@Controller
@RequestMapping(value={"kpiRanking"})
public class KpiRankingController {
    @Resource
    protected KpiRankingService kpiRankingService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected KpiFormService kpiFormService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6392\u540d\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiRanking kpiRanking) {
        this.kpiRankingService.addObj(kpiRanking);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6392\u540d\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiRanking kpiRanking) {
        if (StringUtils.isBlank((String)kpiRanking.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.kpiRankingService.modifyObj(kpiRanking);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6392\u540d\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.kpiRankingService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u6392\u540d\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiRanking", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiRanking>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        example.setOrderByClause(" FORM_CODE DESC,CREATE_TIME DESC  ");
        example.setPageView(new PageView<KpiRanking>(pageNo, pageSize));
        KpiRankingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.kpiRankingService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u6392\u540d\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiRanking", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/supFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiRanking>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiRankingExample example = new KpiRankingExample();
        example.setPageView(new PageView<KpiRanking>(pageNo, pageSize));
        KpiRankingExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andSupCompanySrmCodeEqualTo(CompanyUtils.currentCompany().getCompanyCode());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.kpiRankingService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u65b9\u67e5\u8be2\u6392\u540d\u8868\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiRanking", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/purFindByRanking"})
    @ResponseBody
    public ResponseResult<Map<String, Object>> purFindByRanking(@RequestBody(required=false) QueryParamWapper wapper) throws JsonParseException, JsonMappingException, IOException {
        KpiRankingExample example = new KpiRankingExample();
        KpiRankingExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List kpiRanking = this.kpiRankingService.queryAllObjByExample(example);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        HashMap<String, Cloneable> mapRanking = new HashMap<String, Cloneable>();
        if (CollectionUtils.isNotEmpty(kpiRanking)) {
            for (KpiRanking r : kpiRanking) {
                KpiForm form = (KpiForm)this.kpiFormService.queryObjById(r.getKpiFormId());
                map.put("formPlanTime", form.getFormPlanTime());
                map.put("formStartTime", form.getFormStartTime());
                map.put("formEndTime", form.getFormEndTime());
                map.put("createTime", form.getCreateTime());
                map.put("formCode", r.getFormCode());
                map.put("formName", r.getFormName());
                map.put("formPublishTime", r.getFormPublishTime());
                map.put("formFactTime", r.getFormFactTime());
                map.put("supCompanySrmCode", r.getSupCompanySrmCode());
                map.put("supCompanyName", r.getSupCompanyName());
                map.put("purCompanyCategory", r.getPurCompanyCategory());
                map.put("purCompanyRank", r.getPurCompanyRank());
                String[] sourceStrArray = r.getProjectTypeScore().split("\\|");
                for (int j = 0; j < sourceStrArray.length; ++j) {
                    String jsonMessage = sourceStrArray[j];
                    KpiRankingVo kpi = (KpiRankingVo)JsonUtils.convertValue((String)jsonMessage, KpiRankingVo.class);
                    map.put(kpi.getCode(), kpi.getScore());
                    HashMap<String, String> mapTitle = new HashMap<String, String>();
                    mapTitle.put("projectCode", kpi.getCode());
                    mapTitle.put("projectName", kpi.getName());
                    list.add(mapTitle);
                }
                map.put("rankingScore", r.getRankingScore());
                map.put("ranking", r.getRanking());
                Company company = (Company)this.companyService.queryObjById(r.getSupCompanyId());
                map.put("classificationThree", company.getClassificationThree());
                String secondCompanyType = company.getSecondCompanyType();
                if (!StringUtils.isNotBlank((String)secondCompanyType)) continue;
                String[] classType = secondCompanyType.split(",");
                map.put("secondCompanyType", classType[0]);
            }
        }
        mapRanking.put("kpiRankingList", map);
        mapRanking.put("titles", list);
        return ResponseResult.success(mapRanking);
    }
}

