
-- 基础数据表
-- 评估项类别(价格、质量、服务) 来源于字典表
--类别分组编码：evaluateType
--类别编码：price(价格)、deliver(交付)、service(服务)、quality(质量)
--来源编码：sourceType 0(SAP)、1(SRM)

-- 评估项操作类型(1-加分,2-减分,3-取值)来源于字典表
--操作类型分组编码：evaluateHandlType
--操作类型(1-人工评分,2-接口获取)

-- 评估项取值方式(1-接口、2-存储过程、3-SQL语句)
--取值方式分组编码：evaluateMethodType
--取值方式(1-接口、2-存储过程、3-SQL语句)

-- 供应商分类(电子、包装) 来源于字典表
-- 供应商等级(A、B、C、D) 来源于供应商表
--supplier_grade

--不良登记
--事项badItem
--类别badType



/*DECLARE num NUMBER; 
BEGIN 
SELECT COUNT(1) INTO num FROM USER_TABLES WHERE TABLE_NAME = UPPER('T_BASE_KPI_EVALUATION_PROJECT') ; 
IF num > 0 THEN 
EXECUTE IMMEDIATE 'DROP TABLE T_BASE_KPI_PROJECT' ; 
END IF; 
END;*/

--评估项
--drop table T_BASE_KPI_PROJECT;
CREATE TABLE T_BASE_KPI_PROJECT
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  PROJECT_CODE      NVARCHAR2(50),
  PROJECT_NAME VARCHAR(100),

  PROJECT_TYPE      NVARCHAR2(20),
  PROJECT_TYPE_NAME NVARCHAR2(50),
  PROJECT_HANDL_TYPE NVARCHAR2(1),
  PROJECT_METHOD_TYPE NVARCHAR2(20),
  PROJECT_METHOD_PARAMETER NVARCHAR2(1000),
  PROJECT_STANDARD VARCHAR(500),
  PROJECT_INSTRUCTION VARCHAR(500),
      
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_PROJECT ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_PROJECT IS '评估项';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_CODE IS '评估项编码';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_NAME IS '评估项名称';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_TYPE IS '评估项类别编码';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_TYPE_NAME IS '评估项类别名称';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_HANDL_TYPE IS '操作类型  1-人工评分,2-接口获取';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_METHOD_TYPE IS '取值方式  1-接口,2-存储过程,3-SQL语句)';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_METHOD_PARAMETER IS '具体参数';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_STANDARD IS '评分标准';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_INSTRUCTION IS '评分说明';

COMMENT ON COLUMN T_BASE_KPI_PROJECT.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_PROJECT.LAST_UPDATE_USER IS '最后修改人';



--评估模板表
--drop table T_BASE_KPI_TEMPLATE;
CREATE TABLE T_BASE_KPI_TEMPLATE
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  TEMPLATE_CODE      NVARCHAR2(50),
  TEMPLATE_NAME VARCHAR(100),
  PUR_COMPANY_CATEGORY      NVARCHAR2(20),
  PUR_COMPANY_RANK NVARCHAR2(20),
  
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_TEMPLATE ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_TEMPLATE IS '评估模板';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.TEMPLATE_CODE IS '模板编码';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.TEMPLATE_NAME IS '模板名称';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.PUR_COMPANY_CATEGORY IS '供应商类别编码';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.PUR_COMPANY_RANK IS '供应商等级';

COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE.LAST_UPDATE_USER IS '最后修改人';


--评估模板评估项类别权重 
--drop table  T_BASE_KPI_TEMPLATE_WEIGHT;
CREATE TABLE T_BASE_KPI_TEMPLATE_WEIGHT
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  KPI_TEMPLATE_ID NVARCHAR2(50),
  TEMPLATE_CODE      NVARCHAR2(50),
  PROJECT_TYPE      NVARCHAR2(20),
  PROJECT_TYPE_NAME NVARCHAR2(50),
  PROJECT_TYPE_WEIGHT    NVARCHAR2(20),
  
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_TEMPLATE_WEIGHT ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_TEMPLATE_WEIGHT IS '评估模板评估项类别权重';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.KPI_TEMPLATE_ID IS '模板编码ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.TEMPLATE_CODE IS '模板编码';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PROJECT_TYPE IS '评估项类别编码';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PROJECT_TYPE_NAME IS '评估项类别名称';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.PROJECT_TYPE_WEIGHT IS '评估项类别权重';

COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_WEIGHT.LAST_UPDATE_USER IS '最后修改人';


--评估模板明细表     
--drop table T_BASE_KPI_TEMPLATE_ITEM;     
CREATE TABLE T_BASE_KPI_TEMPLATE_ITEM
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  KPI_TEMPLATE_ID NVARCHAR2(50),
  TEMPLATE_CODE      NVARCHAR2(50),
  KPI_PROJECT_ID NVARCHAR2(50),
  PROJECT_CODE      NVARCHAR2(50),
  PROJECT_NAME VARCHAR(100),
  PROJECT_HANDL_TYPE NVARCHAR2(1),
  PROJECT_METHOD_TYPE NVARCHAR2(20),
  PROJECT_METHOD_PARAMETER NVARCHAR2(1000),
  PROJECT_STANDARD VARCHAR(500),
  PROJECT_INSTRUCTION VARCHAR(500),
  PROJECT_TYPE      NVARCHAR2(20),
  PROJECT_TYPE_NAME NVARCHAR2(50),
  PROJECT_WEIGHT    NVARCHAR2(20),
  
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_TEMPLATE_ITEM ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_TEMPLATE_ITEM IS '评估模板明细';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.KPI_TEMPLATE_ID IS '模板编码ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.TEMPLATE_CODE IS '模板编码';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.KPI_PROJECT_ID IS '评估项ID';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_CODE IS '评估项编码';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_NAME IS '评估项名称';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_HANDL_TYPE IS '操作类型  1-人工评分,2-接口获取';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_METHOD_TYPE IS '取值方式  1-接口,2-存储过程,3-SQL语句)';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_METHOD_PARAMETER IS '具体参数';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_STANDARD IS '评分标准';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_INSTRUCTION IS '评分说明';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_TYPE IS '评估项类别编码';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_TYPE_NAME IS '评估项类别名称';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.PROJECT_WEIGHT IS '评估项权重';

COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_TEMPLATE_ITEM.LAST_UPDATE_USER IS '最后修改人';


--评估表   
--drop table T_BASE_KPI_FORM;         
CREATE TABLE T_BASE_KPI_FORM
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  FORM_CODE      NVARCHAR2(50),
  FORM_NAME      NVARCHAR2(100),
  FORM_STATE    NVARCHAR2(2),
  KPI_TEMPLATE_ID NVARCHAR2(50),
  TEMPLATE_CODE      NVARCHAR2(50),
  TEMPLATE_NAME VARCHAR(100),
  FORM_PUBLISH_TIME  DATE,
  FORM_PLAN_TIME  DATE,
  FORM_FACT_TIME  DATE,
  FORM_START_TIME  DATE,
  FORM_END_TIME  DATE,
  FORM_CALCULATION  NVARCHAR2(2),   
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);

--新建主键
ALTER TABLE T_BASE_KPI_FORM ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_FORM IS '评估表';
COMMENT ON COLUMN T_BASE_KPI_FORM.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_FORM.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_FORM.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_FORM.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_FORM.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_FORM.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_CODE IS '评估表编号';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_NAME IS '评估表名称';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_STATE IS '状态  0-新建,1-进行中,2-已完成';
COMMENT ON COLUMN T_BASE_KPI_FORM.KPI_TEMPLATE_ID IS '模板编码ID';
COMMENT ON COLUMN T_BASE_KPI_FORM.TEMPLATE_CODE IS '模板编码';
COMMENT ON COLUMN T_BASE_KPI_FORM.TEMPLATE_NAME IS '模板名称';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_PUBLISH_TIME IS '发布时间';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_PLAN_TIME IS '预估完成时间';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_FACT_TIME IS '实际完成时间';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_START_TIME IS '评估开始时间';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_END_TIME IS '评估结束时间';
COMMENT ON COLUMN T_BASE_KPI_FORM.FORM_CALCULATION IS '是否已计算，1：已计算，0或NULL为未计算';

COMMENT ON COLUMN T_BASE_KPI_FORM.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_FORM.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_FORM.LAST_UPDATE_USER IS '最后修改人';



--评估表与供应商关系表    
--drop table  T_BASE_KPI_FORM_AND_COMPANY;
CREATE TABLE T_BASE_KPI_FORM_AND_COMPANY
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  KPI_FORM_ID          NVARCHAR2(50),
  FORM_CODE      NVARCHAR2(50),
 
  SUP_COMPANY_ID           NVARCHAR2(32),
  SUP_COMPANY_SRM_CODE     NVARCHAR2(100),
  SUP_COMPANY_SAP_CODE     NVARCHAR2(100),
  SUP_COMPANY_NAME         NVARCHAR2(255),
  SUP_USER_NAME            NVARCHAR2(255),
  SUP_USER_ID              NVARCHAR2(32),
    
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_FORM_AND_COMPANY ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_FORM_AND_COMPANY IS '评估表与供应商关系';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.KPI_FORM_ID IS '评估表ID';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.FORM_CODE IS '评估表编号';

comment on column T_BASE_KPI_FORM_AND_COMPANY.SUP_COMPANY_ID is '供应商企业id';
comment on column T_BASE_KPI_FORM_AND_COMPANY.SUP_COMPANY_SRM_CODE is '供应商SRM编码';
comment on column T_BASE_KPI_FORM_AND_COMPANY.SUP_COMPANY_SAP_CODE is '供应商SAP编码';
comment on column T_BASE_KPI_FORM_AND_COMPANY.SUP_COMPANY_NAME is '供应商企业名称';
comment on column T_BASE_KPI_FORM_AND_COMPANY.SUP_USER_NAME is '销售方负责人';
comment on column T_BASE_KPI_FORM_AND_COMPANY.SUP_USER_ID is '供应商负责人id';
  
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_COMPANY.LAST_UPDATE_USER IS '最后修改人';


--drop table T_BASE_KPI_FORM_AND_PERSON;
--评估表与评估人关系表         
CREATE TABLE T_BASE_KPI_FORM_AND_PERSON
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  KPI_FORM_ID NVARCHAR2(50),
  FORM_CODE      NVARCHAR2(50),
  PROJECT_TYPE      NVARCHAR2(20), 
  PERSON_USER_ID          NVARCHAR2(32),
  PERSON_USER_NAME        NVARCHAR2(255),
    
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_FORM_AND_PERSON ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_FORM_AND_PERSON IS '评估表与评估人关系表';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.KPI_FORM_ID IS '评估表ID';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.FORM_CODE IS '评估表编号';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PROJECT_TYPE IS '评估项类别编码';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PERSON_USER_ID IS '评估人ID';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.PERSON_USER_NAME IS '评估人名称';
  
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_FORM_AND_PERSON.LAST_UPDATE_USER IS '最后修改人';


--评分表         
--drop table T_BASE_KPI_SCORE;
CREATE TABLE T_BASE_KPI_SCORE
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  KPI_FORM_ID    NVARCHAR2(50),
  FORM_CODE      NVARCHAR2(50),
  FORM_NAME      NVARCHAR2(100),
  PERSON_USER_ID          NVARCHAR2(32),
  PERSON_USER_NAME        NVARCHAR2(255), 
  
  SUP_COMPANY_ID           NVARCHAR2(32),
  SUP_COMPANY_SRM_CODE         NVARCHAR2(100),
  SUP_COMPANY_SAP_CODE     NVARCHAR2(100),
  SUP_COMPANY_NAME         NVARCHAR2(255),
  SUP_USER_NAME            NVARCHAR2(255),
  SUP_USER_ID              NVARCHAR2(32),
    
  KPI_TEMPLATE_ID NVARCHAR2(50),
  TEMPLATE_CODE      NVARCHAR2(50),
  TEMPLATE_NAME VARCHAR(100),
  KPI_PROJECT_ID  NVARCHAR2(50),
  PROJECT_CODE      NVARCHAR2(50),
  PROJECT_NAME VARCHAR(100),
  PROJECT_TYPE      NVARCHAR2(20),
  PROJECT_TYPE_NAME     NVARCHAR2(20),
  PROJECT_HANDL_TYPE NVARCHAR2(1),
  PROJECT_METHOD_TYPE NVARCHAR2(20),
  PROJECT_METHOD_PARAMETER NVARCHAR2(1000),
  PROJECT_WEIGHT    NVARCHAR2(20),
  SCORE_SCORE    NVARCHAR2(20),   
  SCORE_STATE    NVARCHAR2(2),
   
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_SCORE ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_SCORE IS '评分表';
COMMENT ON COLUMN T_BASE_KPI_SCORE.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_SCORE.KPI_FORM_ID IS '评估表ID';
COMMENT ON COLUMN T_BASE_KPI_SCORE.FORM_CODE IS '评估表编号';
COMMENT ON COLUMN T_BASE_KPI_SCORE.FORM_NAME IS '评估表名称';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PERSON_USER_ID IS '评估人ID';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PERSON_USER_NAME IS '评估人名称';

comment on column T_BASE_KPI_SCORE.SUP_COMPANY_ID is '供应商企业id';
comment on column T_BASE_KPI_SCORE.SUP_COMPANY_SRM_CODE is '供应商SRM编码';
comment on column T_BASE_KPI_SCORE.SUP_COMPANY_SAP_CODE is '供应商SAP编码';
comment on column T_BASE_KPI_SCORE.SUP_COMPANY_NAME is '供应商企业名称';
comment on column T_BASE_KPI_SCORE.SUP_USER_NAME is '销售方负责人';
comment on column T_BASE_KPI_SCORE.SUP_USER_ID is '供应商id';

COMMENT ON COLUMN T_BASE_KPI_SCORE.KPI_TEMPLATE_ID IS '模板编码ID';
COMMENT ON COLUMN T_BASE_KPI_SCORE.TEMPLATE_CODE IS '模板编码';
COMMENT ON COLUMN T_BASE_KPI_SCORE.TEMPLATE_NAME IS '模板名称';
COMMENT ON COLUMN T_BASE_KPI_SCORE.KPI_PROJECT_ID IS '评估项ID';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_CODE IS '评估项编码';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_NAME IS '评估项名称';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_TYPE IS '评估项类别编码';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_TYPE_NAME IS '评估项类别名称';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_HANDL_TYPE IS '操作类型   1-加分,2-减分,3-公式';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_METHOD_TYPE IS '取值方式  1-接口,2-存储过程,3-SQL语句)';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_METHOD_PARAMETER IS '具体参数';
COMMENT ON COLUMN T_BASE_KPI_SCORE.PROJECT_WEIGHT IS '评估项权重';
COMMENT ON COLUMN T_BASE_KPI_SCORE.SCORE_SCORE IS '得分';
COMMENT ON COLUMN T_BASE_KPI_SCORE.SCORE_STATE IS '状态: 1 未提交，2 已提交';

COMMENT ON COLUMN T_BASE_KPI_SCORE.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_SCORE.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_SCORE.LAST_UPDATE_USER IS '最后修改人';



--排名表         
--drop table T_BASE_KPI_RANKING;
CREATE TABLE T_BASE_KPI_RANKING
(
  ID               NVARCHAR2(50) NOT NULL,
  PUR_COMPANY_ID       NVARCHAR2(32),
  PUR_COMPANY_CODE     NVARCHAR2(255),
  PUR_COMPANY_NAME     NVARCHAR2(255),
  PUR_USER_ID          NVARCHAR2(32),
  PUR_USER_NAME        NVARCHAR2(255),
  
  RANKING_CODE      NVARCHAR2(50),
  
  KPI_FORM_ID NVARCHAR2(50),
  FORM_CODE      NVARCHAR2(50),
  FORM_NAME      NVARCHAR2(100),
  FORM_PUBLISH_TIME  DATE,
  FORM_FACT_TIME  DATE,  
 
  SUP_COMPANY_ID           NVARCHAR2(32),
  SUP_COMPANY_SRM_CODE         NVARCHAR2(100),
  SUP_COMPANY_SAP_CODE     NVARCHAR2(100),
  SUP_COMPANY_NAME         NVARCHAR2(255),
  SUP_USER_NAME            NVARCHAR2(255),
  SUP_USER_ID              NVARCHAR2(32),
   
  PUR_COMPANY_CATEGORY      NVARCHAR2(20),
  PUR_COMPANY_RANK NVARCHAR2(20),
  RANKING_SCORE    NVARCHAR2(20),  
  PROJECT_TYPE_SCORE    NVARCHAR2(500),    
  RANKING      NVARCHAR2(20),
  RANKING_FORM_CODE  NVARCHAR2(50),
   
  CREATE_TIME      DATE DEFAULT SYSDATE,
  LAST_UPDATE_TIME DATE DEFAULT SYSDATE,
  LAST_UPDATE_USER NVARCHAR2(255)
);
--新建主键
ALTER TABLE T_BASE_KPI_RANKING ADD PRIMARY KEY (ID);
--备注  
COMMENT ON TABLE T_BASE_KPI_RANKING IS '排名表';
COMMENT ON COLUMN T_BASE_KPI_RANKING.ID IS '主键';
COMMENT ON COLUMN T_BASE_KPI_RANKING.PUR_COMPANY_ID IS '采购员公司ID';
COMMENT ON COLUMN T_BASE_KPI_RANKING.PUR_COMPANY_CODE IS '客户编号';
COMMENT ON COLUMN T_BASE_KPI_RANKING.PUR_COMPANY_NAME IS '客户名称';
COMMENT ON COLUMN T_BASE_KPI_RANKING.PUR_USER_ID IS '采购员ID';
COMMENT ON COLUMN T_BASE_KPI_RANKING.PUR_USER_NAME IS '采购负责人';

COMMENT ON COLUMN T_BASE_KPI_RANKING.RANKING_CODE IS '排名编码或单据号';

COMMENT ON COLUMN T_BASE_KPI_RANKING.KPI_FORM_ID IS '评估表ID';
COMMENT ON COLUMN T_BASE_KPI_RANKING.FORM_CODE IS '评估表编号';
COMMENT ON COLUMN T_BASE_KPI_RANKING.FORM_NAME IS '评估表名称';
COMMENT ON COLUMN T_BASE_KPI_RANKING.FORM_PUBLISH_TIME IS '发布时间';
COMMENT ON COLUMN T_BASE_KPI_RANKING.FORM_FACT_TIME IS '实际完成时间';

comment on column T_BASE_KPI_RANKING.SUP_COMPANY_ID is '供应商企业id';
comment on column T_BASE_KPI_RANKING.SUP_COMPANY_SRM_CODE is '供应商SRM编码';
comment on column T_BASE_KPI_RANKING.SUP_COMPANY_SAP_CODE is '供应商SAP编码';
comment on column T_BASE_KPI_RANKING.SUP_COMPANY_NAME is '供应商企业名称';
comment on column T_BASE_KPI_RANKING.SUP_USER_NAME is '销售方负责人';
comment on column T_BASE_KPI_RANKING.SUP_USER_ID is '供应商id';

COMMENT ON COLUMN T_BASE_KPI_RANKING.PUR_COMPANY_CATEGORY IS '供应商类别编码';
COMMENT ON COLUMN T_BASE_KPI_RANKING.PUR_COMPANY_RANK IS '供应商等级';
COMMENT ON COLUMN T_BASE_KPI_RANKING.RANKING_SCORE IS '得分';
COMMENT ON COLUMN T_BASE_KPI_RANKING.PROJECT_TYPE_SCORE IS '评估项类别分数';
COMMENT ON COLUMN T_BASE_KPI_RANKING.RANKING IS '对比最近一次排名结果是否升降，1：升，2：降，3：平';
COMMENT ON COLUMN T_BASE_KPI_RANKING.RANKING_FORM_CODE IS '对比的评估表编码';

COMMENT ON COLUMN T_BASE_KPI_RANKING.CREATE_TIME IS '创建时间';
COMMENT ON COLUMN T_BASE_KPI_RANKING.LAST_UPDATE_TIME IS '最后更新时间';
COMMENT ON COLUMN T_BASE_KPI_RANKING.LAST_UPDATE_USER IS '最后修改人';


--增加字段
alter table T_BASE_KPI_PROJECT add PROJECT_METHOD_PARAMETER_NAME NVARCHAR2(300);
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_METHOD_PARAMETER_NAME IS '接口名称';
alter table T_BASE_KPI_PROJECT add PROJECT_DIMENSION NVARCHAR2(300);
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_DIMENSION IS '评估维度';
alter table T_BASE_KPI_PROJECT add PROJECT_SOURCE NVARCHAR2(300);
COMMENT ON COLUMN T_BASE_KPI_PROJECT.PROJECT_SOURCE IS '接口数据来源，0：SAP，1:SRM';

--修改字段长度
alter table T_BASE_KPI_PROJECT modify PROJECT_NAME NVARCHAR2(300);
alter table T_BASE_KPI_PROJECT modify PROJECT_TYPE_NAME NVARCHAR2(150);
alter table T_BASE_KPI_PROJECT modify PROJECT_STANDARD NVARCHAR2(2000);
alter table T_BASE_KPI_PROJECT modify PROJECT_INSTRUCTION NVARCHAR2(2000);

alter table T_BASE_KPI_TEMPLATE_ITEM modify PROJECT_NAME NVARCHAR2(300);
alter table T_BASE_KPI_TEMPLATE_ITEM modify PROJECT_TYPE_NAME NVARCHAR2(150);
alter table T_BASE_KPI_TEMPLATE_ITEM modify PROJECT_STANDARD NVARCHAR2(2000);
alter table T_BASE_KPI_TEMPLATE_ITEM modify PROJECT_INSTRUCTION NVARCHAR2(2000);

--评估表
ALTER TABLE T_BASE_KPI_FORM ADD ( PUR_COMPANY_CATEGORY NVARCHAR2(255) NULL );
ALTER TABLE T_BASE_KPI_FORM ADD ( PUR_COMPANY_RANK NVARCHAR2(255) NULL );
COMMENT ON COLUMN T_BASE_KPI_FORM.PUR_COMPANY_CATEGORY IS '供应商类别编码';
COMMENT ON COLUMN T_BASE_KPI_FORM.PUR_COMPANY_RANK IS '供应商等级';

--评分表
alter table T_BASE_KPI_SCORE modify PROJECT_NAME NVARCHAR2(300);
alter table T_BASE_KPI_SCORE modify PROJECT_TYPE_NAME NVARCHAR2(150);



--select *from T_BASE_GENERATE_CODE for update;
--设置评估项编码规则
insert into T_BASE_GENERATE_CODE (ID, NAME, TARGET_CODE, STRATEGY, PREFIX, SUFFIX, CURRENT_CODE, START_CODE, MAX_CODE, CREATE_TIME, UPDATE_TIME)
values ('20170620113016-983abd8161253d40', '评估项编码', 'KPI_PROJECT_CODE', 'com.els.base.codegenerator.service.impl.AutoIncrementStrategy', '', '', '1000', '1001', '', sysdate, sysdate);

--设置评估模板编码规则
insert into T_BASE_GENERATE_CODE (ID, NAME, TARGET_CODE, STRATEGY, PREFIX, SUFFIX, CURRENT_CODE, START_CODE, MAX_CODE, CREATE_TIME, UPDATE_TIME)
values ('20170620113026-983abd8161253d40', '评估模板编码', 'KPI_TEMPLATE_CODE', 'com.els.base.codegenerator.service.impl.DateIncrementStrategy', '', '', '201712150000001', '1', '', sysdate, sysdate);

-- 设置i18n
insert into t_base_i18n (IS_ENABLE, I18N_CODE, ZH_CN, ZH_TW, EN, JA, KO, ID)
values (1, 'finish_status', '{0}', '', '', '', '', '20171128054630-57a65e000c6445909');
