/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.performance.dao.KpiRankingMapper;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiRanking;
import com.els.base.performance.entity.KpiRankingExample;
import com.els.base.performance.service.KpiFormService;
import com.els.base.performance.service.KpiRankingService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultKpiRankingService")
public class KpiRankingServiceImpl
implements KpiRankingService {
    @Resource
    protected KpiRankingMapper kpiRankingMapper;
    @Resource
    protected KpiFormService kpiFormService;

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void addObj(KpiRanking t) {
        this.kpiRankingMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void insertCustom(KpiRanking t) {
        this.kpiRankingMapper.insertCustom(t);
    }

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void deleteObjById(String id) {
        this.kpiRankingMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void modifyObj(KpiRanking t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.kpiRankingMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"kpiRanking"}, keyGenerator="redisKeyGenerator")
    public KpiRanking queryObjById(String id) {
        return this.kpiRankingMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"kpiRanking"}, keyGenerator="redisKeyGenerator")
    public List<KpiRanking> queryAllObjByExample(KpiRankingExample example) {
        return this.kpiRankingMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"kpiRanking"}, keyGenerator="redisKeyGenerator")
    public PageView<KpiRanking> queryObjByPage(KpiRankingExample example) {
        PageView<KpiRanking> pageView = example.getPageView();
        List<Object> kpiRanking = new ArrayList();
        kpiRanking = this.kpiRankingMapper.selectByExampleByPage(example);
        for (KpiRanking kpiRanking2 : kpiRanking) {
            KpiForm form = (KpiForm)this.kpiFormService.queryObjById(kpiRanking2.getKpiFormId());
            kpiRanking2.setKipForm(form);
        }
        pageView.setQueryResult(kpiRanking);
        return pageView;
    }

    @Override
    @CacheEvict(value={"kpiRanking"}, allEntries=true)
    public void deleteByExample(KpiRankingExample exampl) {
        this.kpiRankingMapper.deleteByExample(exampl);
    }

    @Override
    public KpiRanking selectByCustom(KpiRanking t) {
        return this.kpiRankingMapper.selectByCustom(t);
    }
}

