/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.performance.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.performance.entity.KpiSupAudit;
import com.els.base.performance.entity.KpiSupAuditExample;
import com.els.base.performance.service.KpiSupAuditService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868")
@Controller
@RequestMapping(value={"kpiSupAudit"})
public class KpiSupAuditController {
    @Resource
    protected KpiSupAuditService kpiSupAuditService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KpiSupAudit kpiSupAudit) {
        kpiSupAudit.setUser(SpringSecurityUtils.getLoginUser());
        kpiSupAudit.setCompany(CompanyUtils.currentCompany());
        this.kpiSupAuditService.addObj(kpiSupAudit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KpiSupAudit kpiSupAudit) {
        Assert.isNotBlank(kpiSupAudit.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        kpiSupAudit.setUser(SpringSecurityUtils.getLoginUser());
        this.kpiSupAuditService.modifyObj(kpiSupAudit);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiSupAuditService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868")
    @RequestMapping(value={"service/deleteByIdBatch"})
    @ResponseBody
    public ResponseResult<String> deleteByIdBatch(@RequestBody List<String> idList) {
        for (String id : idList) {
            Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
            this.kpiSupAuditService.deleteObjById(id);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiSupAudit", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<KpiSupAudit>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiSupAuditExample example = new KpiSupAuditExample();
        example.setPageView(new PageView<KpiSupAudit>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.kpiSupAuditService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868")
    @RequestMapping(value={"service/submit"})
    @ResponseBody
    public ResponseResult<String> submit(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u63d0\u4ea4\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.kpiSupAuditService.submit(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 KpiSupAudit", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<KpiSupAudit>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        KpiSupAuditExample example = new KpiSupAuditExample();
        example.setPageView(new PageView<KpiSupAudit>(pageNo, pageSize));
        example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andStatusEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.kpiSupAuditService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868\u5bfc\u51faexcel")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u8fc7\u7a0b\u5e74\u5ea6\u5ba1\u6838\u7ba1\u7406\u8868excel\u5bfc\u5165", httpMethod="POST")
    @RequestMapping(value={"service/uploadExcel"})
    @ResponseBody
    public ResponseResult<String> uploadExcel(MultipartHttpServletRequest request) {
        int i;
        List importExcelDataToMap = new ArrayList();
        try {
            Map fileMap = request.getFileMap();
            MultipartFile file = this.vaildFile(fileMap);
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys();
            importExcelDataToMap = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, KpiSupAudit.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        for (i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) && i < importExcelDataToMap.size(); ++i) {
            String str;
            KpiSupAudit t = (KpiSupAudit)importExcelDataToMap.get(i);
            if (StringUtils.isBlank((String)t.getAuditType())) {
                str = "\u5bfc\u5165\u5931\u8d25\uff01\u7b2c" + (i + 2) + "\u884c\u7684\u5ba1\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u6838\u5bf9\u540e\u518d\u5bfc\u5165\uff01";
                throw new CommonException("\u5ba1\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", "finish_status", str);
            }
            if (!t.getAuditType().equals("\u8fc7\u7a0b\u5ba1\u6838") && !t.getAuditType().equals("\u6574\u6539\u5ba1\u6838")) {
                str = "\u5bfc\u5165\u5931\u8d25\uff01\u7b2c" + (i + 2) + "\u884c\u7684\u5ba1\u6838\u7c7b\u578b\u53ea\u80fd\u662f\u3010\u8fc7\u7a0b\u5ba1\u6838\u3011\u6216\u3010\u6574\u6539\u5ba1\u6838\u3011,\u8bf7\u6838\u5bf9\u540e\u518d\u5bfc\u5165\uff01";
                throw new CommonException("\u5ba1\u6838\u7c7b\u578b\u53ea\u80fd\u662f\u8fc7\u7a0b\u5ba1\u6838\u6216\u6574\u6539\u5ba1\u6838", "finish_status", str);
            }
            if (t.getAuditDate() == null) {
                str = "\u5bfc\u5165\u5931\u8d25\uff01\u7b2c" + (i + 2) + "\u884c\u7684\u5b9e\u9645\u5ba1\u6838\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u6838\u5bf9\u540e\u518d\u5bfc\u5165\uff01";
                throw new CommonException("\u5b9e\u9645\u5ba1\u6838\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", "finish_status", str);
            }
            if (StringUtils.isNotBlank((String)t.getQsv()) && !t.getQsv().equals("\u662f") && !t.getQsv().equals("\u5426")) {
                str = "\u5bfc\u5165\u5931\u8d25\uff01\u7b2c" + (i + 2) + "\u884c\u7684\u8d28\u91cf\u4fdd\u8bc1\u534f\u8bae\u8981\u4e48\u4e0d\u8f93\u5165\uff0c\u5426\u5219\u53ea\u80fd\u4e3a\u3010\u662f\u3011\u6216\u3010\u5426\u3011,\u8bf7\u6838\u5bf9\u540e\u518d\u5bfc\u5165\uff01";
                throw new CommonException("\u8d28\u91cf\u4fdd\u8bc1\u534f\u8bae\u8981\u4e48\u4e0d\u8f93\u5165\uff0c\u5426\u5219\u53ea\u80fd\u4e3a\u3010\u662f\u3011\u6216\u3010\u5426\u3011", "finish_status", str);
            }
            if (!StringUtils.isNotBlank((String)t.getQtp()) || t.getQtp().equals("\u662f") || t.getQtp().equals("\u5426")) continue;
            str = "\u5bfc\u5165\u5931\u8d25\uff01\u7b2c" + (i + 2) + "\u884c\u7684\u8d28\u91cf\u76ee\u6807\u534f\u8bae\u8981\u4e48\u4e0d\u8f93\u5165\uff0c\u5426\u5219\u53ea\u80fd\u4e3a\u3010\u662f\u3011\u6216\u3010\u5426\u3011,\u8bf7\u6838\u5bf9\u540e\u518d\u5bfc\u5165\uff01";
            throw new CommonException("\u8d28\u91cf\u76ee\u6807\u534f\u8bae\u8981\u4e48\u4e0d\u8f93\u5165\uff0c\u5426\u5219\u53ea\u80fd\u4e3a\u3010\u662f\u3011\u6216\u3010\u5426\u3011", "finish_status", str);
        }
        for (i = 0; CollectionUtils.isNotEmpty(importExcelDataToMap) && i < importExcelDataToMap.size(); ++i) {
            KpiSupAudit kpiSupAudit = (KpiSupAudit)importExcelDataToMap.get(i);
            kpiSupAudit.setCompany(CompanyUtils.currentCompany());
            kpiSupAudit.setUser(SpringSecurityUtils.getLoginUser());
            this.kpiSupAuditService.addObject(kpiSupAudit);
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        return file;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba1\u6838\u7c7b\u578b", (String)"auditType"));
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u5ba1\u6838\u65e5\u671f", (String)"auditDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801", (String)"supCompanySrmCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d28\u91cf\u4fdd\u8bc1\u534f\u8bae", (String)"qsv"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d28\u91cf\u76ee\u6807\u534f\u8bae", (String)"qtp"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"SQE\u8d23\u4efb\u4eba", (String)"seqPerson"));
        TitleAndModelKey titleAndModelKey1 = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u5212\u5ba1\u6838\u65f6\u95f4", (String)"planReviewTime");
        titleAndModelKey1.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey1.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey1);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba1\u6838\u4eba\u5458", (String)"auditor"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b26\u5408\u7a0b\u5ea6", (String)"degreeOfFit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba1\u6838\u7b49\u7ea7", (String)"auditGrade"));
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey((String)"\u5e94\u63d0\u4ea4\u6539\u5584\u63aa\u65bd\u65f6\u95f4", (String)"shouldSubTime");
        titleAndModelKey2.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey2.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey2);
        TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey((String)"\u63d0\u4ea4\u6539\u5584\u63aa\u65bd\u65f6\u95f4", (String)"subTime");
        titleAndModelKey3.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey3.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey3);
        TitleAndModelKey titleAndModelKey4 = ExcelUtils.createTitleAndModelKey((String)"\u95ee\u9898\u5173\u95ed\u6548\u679c\u786e\u8ba4", (String)"problemCloseTime");
        titleAndModelKey4.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey4.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey4);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }
}

