package com.els.base.performance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;

@ApiModel(value = "不良事件")
public class KpiAdverseEvent implements Serializable {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("企业id")
    private String purCompanyId;

    @ApiModelProperty("企业名称")
    private String purCompanyName;

    @ApiModelProperty("公司srm代码")
    private String purCompanySrmCode;

    @ApiModelProperty("公司sap代码")
    private String purCompanySapCode;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("供应商companyid")
    private String supCompanyId;
    
    private String supCompanySrmCode;
    
    private String supCompanySapCode;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商用户id")
    private String supUserId;

    @ApiModelProperty("供应商用户名称")
    private String supUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("采购备注")
    private String remark;

    @ApiModelProperty("单号")
    private String adverseEventNo;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("供应商srm代码")
    private String supplierSrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supplierSapCode;

    @ApiModelProperty("供应商sap名称")
    private String supplierSapName;

    @ApiModelProperty("供应商srm名称")
    private String supplierSrmName;

    @ApiModelProperty("事项简述")
    private String briefResume;

    @ApiModelProperty("供应商简称")
    private String supplierNickName;

    @ApiModelProperty("事项")
    private String matter;

    @ApiModelProperty("类别(影响/服务)")
    private String type;

    @ApiModelProperty("扣分")
    private String points;

    public Company company;// 公司信息

    public User user;// 用户信息
    
    @ApiModelProperty("供应商备注")
    private String supRemark;

    @ApiModelProperty("状态 0-未发送,1-已发送,2-申诉中,3-拒绝申诉,4-作废")
    private String status;
    
    private String currentUserCreate;// 标单是否当前登录用户创建 0:否 1:是
    
    @ApiModelProperty("评估项编码")
    private String projectCode;

    @ApiModelProperty("评估项名称")
    private String projectName;

    @ApiModelProperty("评估项类别编码")
    private String projectType;

    @ApiModelProperty("评估项类别名称")
    private String projectTypeName;
    
    @ApiModelProperty("提起申诉时手动输入的原因")
    private String reasonRemark;

    public String getReasonRemark() {
        return reasonRemark;
    }

    public void setReasonRemark(String reasonRemark) {
        this.reasonRemark = reasonRemark;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getCurrentUserCreate() {
        return currentUserCreate;
    }

    public void setCurrentUserCreate(String currentUserCreate) {
        this.currentUserCreate = currentUserCreate;
    }

    public String getSupRemark() {
        return supRemark;
    }

    public void setSupRemark(String supRemark) {
        this.supRemark = supRemark;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Company getCompany() {
        return company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    private static final long serialVersionUID = 1L;

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode;
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getAdverseEventNo() {
        return adverseEventNo;
    }

    public void setAdverseEventNo(String adverseEventNo) {
        this.adverseEventNo = adverseEventNo == null ? null : adverseEventNo.trim();
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getSupplierSrmCode() {
        return supplierSrmCode;
    }

    public void setSupplierSrmCode(String supplierSrmCode) {
        this.supplierSrmCode = supplierSrmCode == null ? null : supplierSrmCode.trim();
    }

    public String getSupplierSapCode() {
        return supplierSapCode;
    }

    public void setSupplierSapCode(String supplierSapCode) {
        this.supplierSapCode = supplierSapCode == null ? null : supplierSapCode.trim();
    }

    public String getSupplierSapName() {
        return supplierSapName;
    }

    public void setSupplierSapName(String supplierSapName) {
        this.supplierSapName = supplierSapName == null ? null : supplierSapName.trim();
    }

    public String getSupplierSrmName() {
        return supplierSrmName;
    }

    public void setSupplierSrmName(String supplierSrmName) {
        this.supplierSrmName = supplierSrmName == null ? null : supplierSrmName.trim();
    }

    public String getBriefResume() {
        return briefResume;
    }

    public void setBriefResume(String briefResume) {
        this.briefResume = briefResume == null ? null : briefResume.trim();
    }

    public String getSupplierNickName() {
        return supplierNickName;
    }

    public void setSupplierNickName(String supplierNickName) {
        this.supplierNickName = supplierNickName == null ? null : supplierNickName.trim();
    }

    public String getMatter() {
        return matter;
    }

    public void setMatter(String matter) {
        this.matter = matter == null ? null : matter.trim();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public String getPoints() {
        return points;
    }

    public void setPoints(String points) {
        this.points = points == null ? null : points.trim();
    }
}