package com.els.base.performance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;

@ApiModel(value = "评估表")
public class KpiForm implements Serializable {
    /********** 以下为非自动生成代码，请勿覆盖 *************/
    private List<KpiFormAndCompany> kpiFormAndCompanyList;

    private List<KpiFormAndPerson> kpiFormAndPersonList;

    public Company company;// 公司信息

    public User user;// 用户信息

    private List<String> roleCodeList;//角色信息

    public List<String> getRoleCodeList() {
        return roleCodeList;
    }

    public void setRoleCodeList(List<String> roleCodeList) {
        this.roleCodeList = roleCodeList;
    }

    public Company getCompany() {
        return company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public List<KpiFormAndCompany> getKpiFormAndCompanyList() {
        return kpiFormAndCompanyList;
    }

    public void setKpiFormAndCompanyList(List<KpiFormAndCompany> kpiFormAndCompanyList) {
        this.kpiFormAndCompanyList = kpiFormAndCompanyList;
    }

    public List<KpiFormAndPerson> getKpiFormAndPersonList() {
        return kpiFormAndPersonList;
    }

    public void setKpiFormAndPersonList(List<KpiFormAndPerson> kpiFormAndPersonList) {
        this.kpiFormAndPersonList = kpiFormAndPersonList;
    }

    /***********************/
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购员公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("采购员ID")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("评估表编号")
    private String formCode;

    @ApiModelProperty("评估表名称")
    private String formName;

    @ApiModelProperty("状态  0-新建,1-正在评分,2-已完成    3 :作废")
    private String formState;

    @ApiModelProperty("模板编码ID")
    private String kpiTemplateId;

    @ApiModelProperty("模板编码")
    private String templateCode;

    @ApiModelProperty("模板名称")
    private String templateName;

    @ApiModelProperty("发布时间")
    private Date formPublishTime;

    @ApiModelProperty("预估完成时间")
    private Date formPlanTime;

    @ApiModelProperty("实际完成时间")
    private Date formFactTime;

    @ApiModelProperty("评估开始时间")
    private Date formStartTime;

    @ApiModelProperty("评估结束时间")
    private Date formEndTime;

    @ApiModelProperty("是否已计算，1：已计算，0或NULL为未计算")
    private String formCalculation;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("供应商类别编码")
    private String purCompanyCategory;

    @ApiModelProperty("供应商等级")
    private String purCompanyRank;
    
    @ApiModelProperty("是否按照分配供应商权限评分 0:否 1:是")
    private String isScoreBySupPower;

    private static final long serialVersionUID = 1L;

    public String getIsScoreBySupPower() {
        return isScoreBySupPower;
    }

    public void setIsScoreBySupPower(String isScoreBySupPower) {
        this.isScoreBySupPower = isScoreBySupPower;
    }

    public String getPurCompanyCategory() {
        return purCompanyCategory;
    }

    public void setPurCompanyCategory(String purCompanyCategory) {
        this.purCompanyCategory = purCompanyCategory;
    }

    public String getPurCompanyRank() {
        return purCompanyRank;
    }

    public void setPurCompanyRank(String purCompanyRank) {
        this.purCompanyRank = purCompanyRank;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getFormCode() {
        return formCode;
    }

    public void setFormCode(String formCode) {
        this.formCode = formCode == null ? null : formCode.trim();
    }

    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName == null ? null : formName.trim();
    }

    public String getFormState() {
        return formState;
    }

    public void setFormState(String formState) {
        this.formState = formState == null ? null : formState.trim();
    }

    public String getKpiTemplateId() {
        return kpiTemplateId;
    }

    public void setKpiTemplateId(String kpiTemplateId) {
        this.kpiTemplateId = kpiTemplateId == null ? null : kpiTemplateId.trim();
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode == null ? null : templateCode.trim();
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName == null ? null : templateName.trim();
    }

    public Date getFormPublishTime() {
        return formPublishTime;
    }

    public void setFormPublishTime(Date formPublishTime) {
        this.formPublishTime = formPublishTime;
    }

    public Date getFormPlanTime() {
        return formPlanTime;
    }

    public void setFormPlanTime(Date formPlanTime) {
        this.formPlanTime = formPlanTime;
    }

    public Date getFormFactTime() {
        return formFactTime;
    }

    public void setFormFactTime(Date formFactTime) {
        this.formFactTime = formFactTime;
    }

    public Date getFormStartTime() {
        return formStartTime;
    }

    public void setFormStartTime(Date formStartTime) {
        this.formStartTime = formStartTime;
    }

    public Date getFormEndTime() {
        return formEndTime;
    }

    public void setFormEndTime(Date formEndTime) {
        this.formEndTime = formEndTime;
    }

    public String getFormCalculation() {
        return formCalculation;
    }

    public void setFormCalculation(String formCalculation) {
        this.formCalculation = formCalculation == null ? null : formCalculation.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }
}