package com.els.base.performance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;

@ApiModel(value="评估项表")
public class KpiProject implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购员公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("采购员ID")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("评估项编码")
    private String projectCode;

    @ApiModelProperty("评估项名称")
    private String projectName;

    @ApiModelProperty("评分标准")
    private String projectStandard;

    @ApiModelProperty("评分说明")
    private String projectInstruction;

    @ApiModelProperty("评估项类别编码")
    private String projectType;

    @ApiModelProperty("评估项类别名称")
    private String projectTypeName;

    @ApiModelProperty("操作类型  1-人工评分,2-系统计算")
    private String projectHandlType;

    @ApiModelProperty("文件名称")
    private String projectHandlTaxon;

    @ApiModelProperty("命名空间")
    private String projectHandlNamespace;

    @ApiModelProperty("取值方式  1-接口,2-存储过程,3-SQL语句)")
    private String projectMethodType;
    
    @ApiModelProperty("具体参数")
    private String projectMethodParameter;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;
    
    @ApiModelProperty("接口名称")
    private String projectMethodParameterName;
    
    @ApiModelProperty("评估维度")
    private String projectDimension;

    @ApiModelProperty("接口数据来源，0：SAP，1:SRM")
    private String projectSource;
    
    public Company company;//公司信息
	public User user;//用户信息
	
	public Company getCompany() {
		return company;
	}
	public void setCompany(Company company) {
		this.company = company;
	}
	public User getUser() {
		return user;
	}
	public void setUser(User user) {
		this.user = user;
	}

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode == null ? null : projectCode.trim();
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName == null ? null : projectName.trim();
    }

    public String getProjectStandard() {
        return projectStandard;
    }

    public void setProjectStandard(String projectStandard) {
        this.projectStandard = projectStandard == null ? null : projectStandard.trim();
    }

    public String getProjectInstruction() {
        return projectInstruction;
    }

    public void setProjectInstruction(String projectInstruction) {
        this.projectInstruction = projectInstruction == null ? null : projectInstruction.trim();
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType == null ? null : projectType.trim();
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName == null ? null : projectTypeName.trim();
    }

    public String getProjectHandlType() {
        return projectHandlType;
    }

    public void setProjectHandlType(String projectHandlType) {
        this.projectHandlType = projectHandlType == null ? null : projectHandlType.trim();
    }

    public String getProjectHandlTaxon() {
        return projectHandlTaxon;
    }

    public void setProjectHandlTaxon(String projectHandlTaxon) {
        this.projectHandlTaxon = projectHandlTaxon == null ? null : projectHandlTaxon.trim();
    }

    public String getProjectHandlNamespace() {
        return projectHandlNamespace;
    }

    public void setProjectHandlNamespace(String projectHandlNamespace) {
        this.projectHandlNamespace = projectHandlNamespace == null ? null : projectHandlNamespace.trim();
    }

    public String getProjectMethodType() {
        return projectMethodType;
    }

    public void setProjectMethodType(String projectMethodType) {
        this.projectMethodType = projectMethodType == null ? null : projectMethodType.trim();
    }

    public String getProjectMethodParameter() {
        return projectMethodParameter;
    }

    public void setProjectMethodParameter(String projectMethodParameter) {
        this.projectMethodParameter = projectMethodParameter == null ? null : projectMethodParameter.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }
    
    public String getProjectMethodParameterName() {
        return projectMethodParameterName;
    }

    public void setProjectMethodParameterName(String projectMethodParameterName) {
        this.projectMethodParameterName = projectMethodParameterName == null ? null : projectMethodParameterName.trim();
    }
    
    public String getProjectDimension() {
        return projectDimension;
    }

    public void setProjectDimension(String projectDimension) {
        this.projectDimension = projectDimension == null ? null : projectDimension.trim();
    }
    
    public String getProjectSource() {
        return projectSource;
    }

    public void setProjectSource(String projectSource) {
        this.projectSource = projectSource == null ? null : projectSource.trim();
    }
}