package com.els.base.performance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="排名表")
public class KpiRanking implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购员公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("采购员ID")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("模板编码")
    private String templateCode;

    @ApiModelProperty("评估表ID")
    private String kpiFormId;

    @ApiModelProperty("评估表编号")
    private String formCode;

    @ApiModelProperty("评估表名称")
    private String formName;

    @ApiModelProperty("发布时间")
    private Date formPublishTime;

    @ApiModelProperty("实际完成时间")
    private Date formFactTime;

    @ApiModelProperty("供应商企业id")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商企业名称")
    private String supCompanyName;

    @ApiModelProperty("销售方负责人")
    private String supUserName;

    @ApiModelProperty("供应商id")
    private String supUserId;

    @ApiModelProperty("供应商类别编码")
    private String purCompanyCategory;

    @ApiModelProperty("供应商等级")
    private String purCompanyRank;

    @ApiModelProperty("得分")
    private String rankingScore;

    @ApiModelProperty("对比最近一次排名结果是否升降，1：升，2：降，3：平")
    private String ranking;

    @ApiModelProperty("对比的评估表编码")
    private String rankingFormCode;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("评估项类别分数")
    private String projectTypeScore;

    @ApiModelProperty("排名编码或单据号")
    private String rankingCode;

    @ApiModelProperty("考核等级")
    private String purCheckRank;

    @ApiModelProperty("供应商分类")
    private String categoryName;

    @ApiModelProperty("名次")
    private Integer rankingCount;

    @ApiModelProperty("参评家数(参加排名的供应商数量)")
    private Integer companyNumber;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode == null ? null : templateCode.trim();
    }

    public String getKpiFormId() {
        return kpiFormId;
    }

    public void setKpiFormId(String kpiFormId) {
        this.kpiFormId = kpiFormId == null ? null : kpiFormId.trim();
    }

    public String getFormCode() {
        return formCode;
    }

    public void setFormCode(String formCode) {
        this.formCode = formCode == null ? null : formCode.trim();
    }

    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName == null ? null : formName.trim();
    }

    public Date getFormPublishTime() {
        return formPublishTime;
    }

    public void setFormPublishTime(Date formPublishTime) {
        this.formPublishTime = formPublishTime;
    }

    public Date getFormFactTime() {
        return formFactTime;
    }

    public void setFormFactTime(Date formFactTime) {
        this.formFactTime = formFactTime;
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getPurCompanyCategory() {
        return purCompanyCategory;
    }

    public void setPurCompanyCategory(String purCompanyCategory) {
        this.purCompanyCategory = purCompanyCategory == null ? null : purCompanyCategory.trim();
    }

    public String getPurCompanyRank() {
        return purCompanyRank;
    }

    public void setPurCompanyRank(String purCompanyRank) {
        this.purCompanyRank = purCompanyRank == null ? null : purCompanyRank.trim();
    }

    public String getRankingScore() {
        return rankingScore;
    }

    public void setRankingScore(String rankingScore) {
        this.rankingScore = rankingScore == null ? null : rankingScore.trim();
    }

    public String getRanking() {
        return ranking;
    }

    public void setRanking(String ranking) {
        this.ranking = ranking == null ? null : ranking.trim();
    }

    public String getRankingFormCode() {
        return rankingFormCode;
    }

    public void setRankingFormCode(String rankingFormCode) {
        this.rankingFormCode = rankingFormCode == null ? null : rankingFormCode.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getProjectTypeScore() {
        return projectTypeScore;
    }

    public void setProjectTypeScore(String projectTypeScore) {
        this.projectTypeScore = projectTypeScore == null ? null : projectTypeScore.trim();
    }

    public String getRankingCode() {
        return rankingCode;
    }

    public void setRankingCode(String rankingCode) {
        this.rankingCode = rankingCode == null ? null : rankingCode.trim();
    }

    public String getPurCheckRank() {
        return purCheckRank;
    }

    public void setPurCheckRank(String purCheckRank) {
        this.purCheckRank = purCheckRank == null ? null : purCheckRank.trim();
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName == null ? null : categoryName.trim();
    }

    public Integer getRankingCount() {
        return rankingCount;
    }

    public void setRankingCount(Integer rankingCount) {
        this.rankingCount = rankingCount;
    }

    public Integer getCompanyNumber() {
        return companyNumber;
    }

    public void setCompanyNumber(Integer companyNumber) {
        this.companyNumber = companyNumber;
    }
}