package com.els.base.performance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="评分表")
public class KpiScore implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购员公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("采购员ID")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("评估表ID")
    private String kpiFormId;

    @ApiModelProperty("评估表编号")
    private String formCode;

    @ApiModelProperty("评估表名称")
    private String formName;

    @ApiModelProperty("评估人ID")
    private String personUserId;

    @ApiModelProperty("评估人名称")
    private String personUserName;

    @ApiModelProperty("供应商企业id")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商企业名称")
    private String supCompanyName;

    @ApiModelProperty("销售方负责人")
    private String supUserName;

    @ApiModelProperty("供应商id")
    private String supUserId;

    @ApiModelProperty("模板编码ID")
    private String kpiTemplateId;

    @ApiModelProperty("模板编码")
    private String templateCode;

    @ApiModelProperty("模板名称")
    private String templateName;

    @ApiModelProperty("评估项ID")
    private String kpiProjectId;

    @ApiModelProperty("评估项编码")
    private String projectCode;

    @ApiModelProperty("评估项名称")
    private String projectName;

    @ApiModelProperty("评估项类别编码")
    private String projectType;

    @ApiModelProperty("评估项类别名称")
    private String projectTypeName;

    @ApiModelProperty("操作类型   1-加分,2-减分,3-公式")
    private String projectHandlType;

    @ApiModelProperty("取值方式  1-接口,2-存储过程,3-SQL语句)")
    private String projectMethodType;

    @ApiModelProperty("具体参数")
    private String projectMethodParameter;

    @ApiModelProperty("评估项权重")
    private String projectWeight;

    @ApiModelProperty("原始值")
    private String originalValue;

    @ApiModelProperty("修正值")
    private String correctionValue;

    @ApiModelProperty("得分")
    private String scoreScore;

    @ApiModelProperty("状态: 0 未提交，1 已提交")
    private String scoreState;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getKpiFormId() {
        return kpiFormId;
    }

    public void setKpiFormId(String kpiFormId) {
        this.kpiFormId = kpiFormId == null ? null : kpiFormId.trim();
    }

    public String getFormCode() {
        return formCode;
    }

    public void setFormCode(String formCode) {
        this.formCode = formCode == null ? null : formCode.trim();
    }

    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName == null ? null : formName.trim();
    }

    public String getPersonUserId() {
        return personUserId;
    }

    public void setPersonUserId(String personUserId) {
        this.personUserId = personUserId == null ? null : personUserId.trim();
    }

    public String getPersonUserName() {
        return personUserName;
    }

    public void setPersonUserName(String personUserName) {
        this.personUserName = personUserName == null ? null : personUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getKpiTemplateId() {
        return kpiTemplateId;
    }

    public void setKpiTemplateId(String kpiTemplateId) {
        this.kpiTemplateId = kpiTemplateId == null ? null : kpiTemplateId.trim();
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode == null ? null : templateCode.trim();
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName == null ? null : templateName.trim();
    }

    public String getKpiProjectId() {
        return kpiProjectId;
    }

    public void setKpiProjectId(String kpiProjectId) {
        this.kpiProjectId = kpiProjectId == null ? null : kpiProjectId.trim();
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode == null ? null : projectCode.trim();
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName == null ? null : projectName.trim();
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType == null ? null : projectType.trim();
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName == null ? null : projectTypeName.trim();
    }

    public String getProjectHandlType() {
        return projectHandlType;
    }

    public void setProjectHandlType(String projectHandlType) {
        this.projectHandlType = projectHandlType == null ? null : projectHandlType.trim();
    }

    public String getProjectMethodType() {
        return projectMethodType;
    }

    public void setProjectMethodType(String projectMethodType) {
        this.projectMethodType = projectMethodType == null ? null : projectMethodType.trim();
    }

    public String getProjectMethodParameter() {
        return projectMethodParameter;
    }

    public void setProjectMethodParameter(String projectMethodParameter) {
        this.projectMethodParameter = projectMethodParameter == null ? null : projectMethodParameter.trim();
    }

    public String getProjectWeight() {
        return projectWeight;
    }

    public void setProjectWeight(String projectWeight) {
        this.projectWeight = projectWeight == null ? null : projectWeight.trim();
    }

    public String getOriginalValue() {
        return originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue == null ? null : originalValue.trim();
    }

    public String getCorrectionValue() {
        return correctionValue;
    }

    public void setCorrectionValue(String correctionValue) {
        this.correctionValue = correctionValue == null ? null : correctionValue.trim();
    }

    public String getScoreScore() {
        return scoreScore;
    }

    public void setScoreScore(String scoreScore) {
        this.scoreScore = scoreScore == null ? null : scoreScore.trim();
    }

    public String getScoreState() {
        return scoreState;
    }

    public void setScoreState(String scoreState) {
        this.scoreState = scoreState == null ? null : scoreState.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }
}