package com.els.base.performance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="供应商服务原始数据")
public class KpiService implements Serializable {
    private String id;

    @ApiModelProperty("单据ID")
    private String formId;

    @ApiModelProperty("单据号")
    private String formNo;

    @ApiModelProperty("单据状态 0 新增 1发布 2完成 3 作废")
    private Integer status;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商企业名称")
    private String supCompanyName;

    @ApiModelProperty("类别")
    private String category;

    @ApiModelProperty("关键程度 ")
    private String criticality;

    @ApiModelProperty("合作关系")
    private String symbiosis;

    @ApiModelProperty("产品重要")
    private String productImportance;

    @ApiModelProperty("重点标识")
    private String importantFlag;

    @ApiModelProperty("业务员")
    private String salesMan;

    @ApiModelProperty("开发经理")
    private String developmentManager;

    @ApiModelProperty("年份")
    private String year;

    @ApiModelProperty("月份")
    private String month;

    @ApiModelProperty("不及时次数")
    private Integer laterCount;

    @ApiModelProperty("服务分数")
    private BigDecimal score;

    @ApiModelProperty("打分状态0未打分1保存2提交")
    private Integer scoreStatus;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getFormId() {
        return formId;
    }

    public void setFormId(String formId) {
        this.formId = formId == null ? null : formId.trim();
    }

    public String getFormNo() {
        return formNo;
    }

    public void setFormNo(String formNo) {
        this.formNo = formNo == null ? null : formNo.trim();
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category == null ? null : category.trim();
    }

    public String getCriticality() {
        return criticality;
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality == null ? null : criticality.trim();
    }

    public String getSymbiosis() {
        return symbiosis;
    }

    public void setSymbiosis(String symbiosis) {
        this.symbiosis = symbiosis == null ? null : symbiosis.trim();
    }

    public String getProductImportance() {
        return productImportance;
    }

    public void setProductImportance(String productImportance) {
        this.productImportance = productImportance == null ? null : productImportance.trim();
    }

    public String getImportantFlag() {
        return importantFlag;
    }

    public void setImportantFlag(String importantFlag) {
        this.importantFlag = importantFlag == null ? null : importantFlag.trim();
    }

    public String getSalesMan() {
        return salesMan;
    }

    public void setSalesMan(String salesMan) {
        this.salesMan = salesMan == null ? null : salesMan.trim();
    }

    public String getDevelopmentManager() {
        return developmentManager;
    }

    public void setDevelopmentManager(String developmentManager) {
        this.developmentManager = developmentManager == null ? null : developmentManager.trim();
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year == null ? null : year.trim();
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month == null ? null : month.trim();
    }

    public Integer getLaterCount() {
        return laterCount;
    }

    public void setLaterCount(Integer laterCount) {
        this.laterCount = laterCount;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public Integer getScoreStatus() {
        return scoreStatus;
    }

    public void setScoreStatus(Integer scoreStatus) {
        this.scoreStatus = scoreStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}
