package com.els.base.performance.entity;

import io.swagger.annotations.ApiModel;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value = "供应商过程年度审核管理表")
public class KpiSupAudit implements Serializable {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("企业id")
    private String purCompanyId;

    @ApiModelProperty("企业名称")
    private String purCompanyName;

    @ApiModelProperty("公司srm代码")
    private String purCompanySrmCode;

    @ApiModelProperty("公司sap代码")
    private String purCompanySapCode;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("供应商companyid")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商srm代码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商sap代码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商地址")
    private String supplierAddress;

    @ApiModelProperty("供应商用户id")
    private String supUserId;

    @ApiModelProperty("供应商用户名称")
    private String supUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    private String remark;

    @ApiModelProperty("审核类型 0:过程审核 1:整改审核")
    private String auditType;

    @ApiModelProperty("实际审核日期")
    private Date auditDate;

    @ApiModelProperty("采购类别")
    private String purCategory;

    @ApiModelProperty("服务类别")
    private String serviceCategory;

    @ApiModelProperty("服务器件类型")
    private String serviceType;

    @ApiModelProperty("类别")
    private String type;

    @ApiModelProperty("质量保证协议")
    private String qsv;

    @ApiModelProperty("质量目标协议")
    private String qtp;

    @ApiModelProperty("SQE责任人")
    private String seqPerson;

    @ApiModelProperty("计划审核时间")
    private Date planReviewTime;

    @ApiModelProperty("审核人员")
    private String auditor;

    @ApiModelProperty("符合程度")
    private String degreeOfFit;

    @ApiModelProperty("审核等级")
    private String auditGrade;

    @ApiModelProperty("应提交改善措施时间")
    private Date shouldSubTime;

    @ApiModelProperty("提交改善措施时间")
    private Date subTime;

    @ApiModelProperty("问题关闭效果确认")
    private Date problemCloseTime;

    @JsonSerialize(using = UploadSupportJsonSerializer.class)
    @JsonDeserialize(using = UploadSupportJsonDeserializer.class)
    @ApiModelProperty("附件")
    private String attachment;

    @ApiModelProperty("1:已提交 0:未提交")
    private String status;

    private User user;

    private Company company;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Company getCompany() {
        return company;
    }

    public String getQtp() {
        return qtp;
    }

    public void setQtp(String qtp) {
        this.qtp = qtp;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress == null ? null : supplierAddress.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getAuditType() {
        return auditType;
    }

    public void setAuditType(String auditType) {
        this.auditType = auditType == null ? null : auditType.trim();
    }

    public Date getAuditDate() {
        return auditDate;
    }

    public void setAuditDate(Date auditDate) {
        this.auditDate = auditDate;
    }

    public String getPurCategory() {
        return purCategory;
    }

    public void setPurCategory(String purCategory) {
        this.purCategory = purCategory == null ? null : purCategory.trim();
    }

    public String getServiceCategory() {
        return serviceCategory;
    }

    public void setServiceCategory(String serviceCategory) {
        this.serviceCategory = serviceCategory == null ? null : serviceCategory.trim();
    }

    public String getServiceType() {
        return serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType == null ? null : serviceType.trim();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public String getQsv() {
        return qsv;
    }

    public void setQsv(String qsv) {
        this.qsv = qsv == null ? null : qsv.trim();
    }

    public String getSeqPerson() {
        return seqPerson;
    }

    public void setSeqPerson(String seqPerson) {
        this.seqPerson = seqPerson == null ? null : seqPerson.trim();
    }

    public Date getPlanReviewTime() {
        return planReviewTime;
    }

    public void setPlanReviewTime(Date planReviewTime) {
        this.planReviewTime = planReviewTime;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor == null ? null : auditor.trim();
    }

    public String getDegreeOfFit() {
        return degreeOfFit;
    }

    public void setDegreeOfFit(String degreeOfFit) {
        this.degreeOfFit = degreeOfFit == null ? null : degreeOfFit.trim();
    }

    public String getAuditGrade() {
        return auditGrade;
    }

    public void setAuditGrade(String auditGrade) {
        this.auditGrade = auditGrade == null ? null : auditGrade.trim();
    }

    public Date getShouldSubTime() {
        return shouldSubTime;
    }

    public void setShouldSubTime(Date shouldSubTime) {
        this.shouldSubTime = shouldSubTime;
    }

    public Date getSubTime() {
        return subTime;
    }

    public void setSubTime(Date subTime) {
        this.subTime = subTime;
    }

    public Date getProblemCloseTime() {
        return problemCloseTime;
    }

    public void setProblemCloseTime(Date problemCloseTime) {
        this.problemCloseTime = problemCloseTime;
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }
}