package com.els.base.performance.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="供应商待改善")
public class KpiSupplierImprove implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    @ApiModelProperty("待改善单据号")
    private String improveNo;

    @ApiModelProperty("待改善类型 交货 质量")
    private String improveType;

    @ApiModelProperty("绩效考核报告单")
    private String kpiFromNo;

    @ApiModelProperty("供应商代码")
    private String supCompanyCode;

    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("图号、名称")
    private String drawingNo;

    @ApiModelProperty("改善内容")
    private String improveContent;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("附件")
    private String attachment;

    @ApiModelProperty("汇总人ID")
    private String summaryUserid;

    @ApiModelProperty("汇总人名称")
    private String summaryUsername;

    @ApiModelProperty("汇总日期")
    private Date summaryDate;

    @ApiModelProperty("原因分析")
    private String causeAnalysis;

    @ApiModelProperty("纠正措施")
    private String correctiveAction;

    @ApiModelProperty("措施实施计划")
    private String implementationPlan;

    @ApiModelProperty("对实施情况的检查")
    private String inspectionOfImplementation;

    @ApiModelProperty("措施固化")
    private String measuresFixedLine;

    @ApiModelProperty("确认意见")
    private String confirmationOpinions;

    @ApiModelProperty("发送状态 0未发送 1已发送")
    private Integer sendStatus;

    @ApiModelProperty(" 单据状态  1新增 2 发布给供应商  3 供方回复 4确认回复 5 驳回")
    private Integer status;

    @ApiModelProperty("供应商回复时间")
    private Date supplierResponseTime;

    @ApiModelProperty("供应商回复")
    private String supplierReply;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除")
    private Integer isEnable;

    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    @ApiModelProperty("工艺流程")
    private String processFlow;

    @ApiModelProperty("流出原因")
    private String outOfReason;

    @ApiModelProperty("生产原因")
    private String productionReason;

    @ApiModelProperty("防止流出")
    private String preventOutflow;

    @ApiModelProperty("防止发生")
    private String prevent;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getImproveNo() {
        return improveNo;
    }

    public void setImproveNo(String improveNo) {
        this.improveNo = improveNo == null ? null : improveNo.trim();
    }

    public String getImproveType() {
        return improveType;
    }

    public void setImproveType(String improveType) {
        this.improveType = improveType == null ? null : improveType.trim();
    }

    public String getKpiFromNo() {
        return kpiFromNo;
    }

    public void setKpiFromNo(String kpiFromNo) {
        this.kpiFromNo = kpiFromNo == null ? null : kpiFromNo.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getDrawingNo() {
        return drawingNo;
    }

    public void setDrawingNo(String drawingNo) {
        this.drawingNo = drawingNo == null ? null : drawingNo.trim();
    }

    public String getImproveContent() {
        return improveContent;
    }

    public void setImproveContent(String improveContent) {
        this.improveContent = improveContent == null ? null : improveContent.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getSummaryUserid() {
        return summaryUserid;
    }

    public void setSummaryUserid(String summaryUserid) {
        this.summaryUserid = summaryUserid == null ? null : summaryUserid.trim();
    }

    public String getSummaryUsername() {
        return summaryUsername;
    }

    public void setSummaryUsername(String summaryUsername) {
        this.summaryUsername = summaryUsername == null ? null : summaryUsername.trim();
    }

    public Date getSummaryDate() {
        return summaryDate;
    }

    public void setSummaryDate(Date summaryDate) {
        this.summaryDate = summaryDate;
    }

    public String getCauseAnalysis() {
        return causeAnalysis;
    }

    public void setCauseAnalysis(String causeAnalysis) {
        this.causeAnalysis = causeAnalysis == null ? null : causeAnalysis.trim();
    }

    public String getCorrectiveAction() {
        return correctiveAction;
    }

    public void setCorrectiveAction(String correctiveAction) {
        this.correctiveAction = correctiveAction == null ? null : correctiveAction.trim();
    }

    public String getImplementationPlan() {
        return implementationPlan;
    }

    public void setImplementationPlan(String implementationPlan) {
        this.implementationPlan = implementationPlan == null ? null : implementationPlan.trim();
    }

    public String getInspectionOfImplementation() {
        return inspectionOfImplementation;
    }

    public void setInspectionOfImplementation(String inspectionOfImplementation) {
        this.inspectionOfImplementation = inspectionOfImplementation == null ? null : inspectionOfImplementation.trim();
    }

    public String getMeasuresFixedLine() {
        return measuresFixedLine;
    }

    public void setMeasuresFixedLine(String measuresFixedLine) {
        this.measuresFixedLine = measuresFixedLine == null ? null : measuresFixedLine.trim();
    }

    public String getConfirmationOpinions() {
        return confirmationOpinions;
    }

    public void setConfirmationOpinions(String confirmationOpinions) {
        this.confirmationOpinions = confirmationOpinions == null ? null : confirmationOpinions.trim();
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getSupplierResponseTime() {
        return supplierResponseTime;
    }

    public void setSupplierResponseTime(Date supplierResponseTime) {
        this.supplierResponseTime = supplierResponseTime;
    }

    public String getSupplierReply() {
        return supplierReply;
    }

    public void setSupplierReply(String supplierReply) {
        this.supplierReply = supplierReply == null ? null : supplierReply.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo == null ? null : memo.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }

    public String getProcessFlow() {
        return processFlow;
    }

    public void setProcessFlow(String processFlow) {
        this.processFlow = processFlow == null ? null : processFlow.trim();
    }

    public String getOutOfReason() {
        return outOfReason;
    }

    public void setOutOfReason(String outOfReason) {
        this.outOfReason = outOfReason == null ? null : outOfReason.trim();
    }

    public String getProductionReason() {
        return productionReason;
    }

    public void setProductionReason(String productionReason) {
        this.productionReason = productionReason == null ? null : productionReason.trim();
    }

    public String getPreventOutflow() {
        return preventOutflow;
    }

    public void setPreventOutflow(String preventOutflow) {
        this.preventOutflow = preventOutflow == null ? null : preventOutflow.trim();
    }

    public String getPrevent() {
        return prevent;
    }

    public void setPrevent(String prevent) {
        this.prevent = prevent == null ? null : prevent.trim();
    }
}
