package com.els.base.performance.enums;

/**
 * KpiFormStatus
 * 
 * @author Huangwei
 * @date 2017年12月19日 下午5:34:59
 * @version 1.0
 */
public enum KpiFormStatus {
    // 状态 0-新建,1-正在评分,2-已完成
    NEW("0", "新建"), 
    ONGOING("1", "正在评分"), 
    DONE("2", "已完成"),
    APPROVING("3", "审批中"),
    APPROVED("4", "审批完成"),
    REFUSED("5", "审批拒绝");
    
    KpiFormStatus(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private final String value;

    private final String desc;

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
