package com.els.base.performance.service;

import java.util.Date;
import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.core.service.BaseService;
import com.els.base.performance.entity.KpiForm;
import com.els.base.performance.entity.KpiFormAndCompany;
import com.els.base.performance.entity.KpiFormExample;
import com.els.base.performance.entity.KpiTemplateItem;
import com.els.base.performance.entity.ReportQueryParams;
import com.els.base.performance.entity.ReportShow;
import com.els.base.performance.entity.vo.KpiFormVo;

public interface KpiFormService extends BaseService<KpiForm, KpiFormExample, String> {
    void finishForm(KpiForm kpiForm);

    void releaseKpiFrom(KpiForm kpiForm);

    KpiFormVo lookAtTheScore(KpiForm kpiForm);

//    KpiFormVo lookAtTheScoreAll(KpiForm kpiForm);

    KpiForm lookKpiFormDetails(String kpiFormId);

    void saveAtTheScore(KpiFormVo kpiFormVo, String saveOrSubmit);

    void addObject(KpiForm kpiForm);

    void modifyObject(KpiForm kpiForm);

    void rankAdjustMent(String supplierSrmCode, String classLevel);

    List<KpiForm> queryAllObjByExampleCoustom(KpiFormExample example);

    List<KpiFormAndCompany> queryCompanyInfoByKpiId(String kpiFormId);

    List<KpiTemplateItem> queryKpiTemplateItem(String kpiTemplateId);

    String getSRMKpiScore(String sapCompanyCode, Date startTime, Date endTime, String projectDimension);

    List<KpiForm> queryfinalKpiForms(List<String> srmCompanyIdList, List<String> roleCodeList,
                                     User loginUser, List<KpiForm> queryAllObjByExample);

    ReportShow queryMonthlyReport(ReportQueryParams reportQueryParams);

    void toVoidDocument(String id);

    ReportShow queryQuarterOrYearReport(ReportQueryParams reportQueryParams);

    void sendToSing(String id);

    List<String> queryCompanySapCode(String year,String month);
}
