package com.els.base.performance.service;

import com.els.base.core.service.BaseService;
import com.els.base.performance.entity.KpiTemplate;
import com.els.base.performance.entity.KpiTemplateExample;
import com.els.base.performance.entity.KpiTemplateItemExample;
import com.els.base.performance.entity.KpiTemplateVO;
import com.els.base.performance.entity.KpiTemplateWeightExample;

public interface KpiTemplateService extends BaseService<KpiTemplate, KpiTemplateExample, String> {

	/**
	 * 保存模板表，模板的评估项类别权重，模板明细
	 * @param kpiTemplate
	 */
	void addKpiTemplate(KpiTemplateVO kpiTemplateVO);
	
	/**
	 * 删除模板表，模板的评估项类别权重，模板明细
	 * @param kpiTemplateItemExample 
	 * @param kpiTemplateWeightExample 
	 * @param kpiTemplate
	 */
	void deleteKpiTemplate(KpiTemplateVO kpiTemplateVO, KpiTemplateWeightExample kpiTemplateWeightExample, KpiTemplateItemExample kpiTemplateItemExample);
	
	/**
	 * 更新模板表，模板的评估项类别权重，模板明细
	 * @param kpiTemplateItemExample 
	 * @param kpiTemplateWeightExample 
	 * @param kpiTemplate
	 */
	void editKpiTemplate(KpiTemplateVO kpiTemplateVO, KpiTemplateWeightExample kpiTemplateWeightExample,KpiTemplateItemExample kpiTemplateItemExample);

}