package com.els.base.performance.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.performance.dao.KpiAdverseEventMapper;
import com.els.base.performance.entity.KpiAdverseEvent;
import com.els.base.performance.entity.KpiAdverseEventExample;
import com.els.base.performance.enums.KpiAdverseEventStatus;
import com.els.base.performance.service.KpiAdverseEventService;

@Service("defaultKpiAdverseEventService")
public class KpiAdverseEventServiceImpl implements KpiAdverseEventService {
    @Resource
    protected KpiAdverseEventMapper kpiAdverseEventMapper;

    @Resource
    protected GenerateCodeService generateCodeService;

    @Resource
    protected CompanyUserRefService companyUserRefService;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected DicGroupItemService dicGroupItemService;

    @CacheEvict(value = { "kpiAdverseEvent" }, allEntries = true)
    @Override
    public void addObj(KpiAdverseEvent t) {
        String code = this.generateCodeService.getNextCode("KPI_ADVERSE_EVENT_CODE");
        t.setAdverseEventNo(code);
        t.setCreateTime(new Date());
        t.setStatus(KpiAdverseEventStatus.NO_SEND.getValue());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());
        User user = this.companyUserRefService.queryMainUserOfCompany(t.getSupCompanyId());// 供应商的角色info
        t.setSupUserId(user.getId());
        t.setSupUserName(user.getNickName());
        this.kpiAdverseEventMapper.insertSelective(t);
    }

    @Override
    public void addObject(KpiAdverseEvent t) {
        // 判断输入的参数是否为正数，如果不是，则设为null
        if (StringUtils.isNotBlank(t.getPoints())) {
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
            boolean matches = pattern.matcher(t.getPoints()).matches();
            if (matches) {
                t.setPoints(Double.valueOf(t.getPoints()) < 0 ? null : t.getPoints());
            } else {
                t.setPoints(null);
            }
        }

        // 时间格式修改
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd");
        try {
            t.setStartTime(sdf.parse(sdf.format(t.getStartTime())));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        // 判断事项和类别是否有在数据字典组中匹配，如果否，则设为空
        if (!isExistDicGroupItem("20180124102514-4669af894eb8445a9", t.getMatter())) {
            t.setMatter(null);
        } else {
            t.setMatter(getDicGroupItemCode("20180124102514-4669af894eb8445a9", t.getMatter()));
        }
        if (!isExistDicGroupItem("20180124102855-af11e44985874913a", t.getType())) {
            t.setType(null);
        } else {
            t.setType(getDicGroupItemCode("20180124102855-af11e44985874913a", t.getType()));
        }

        String code = this.generateCodeService.getNextCode("KPI_ADVERSE_EVENT_CODE");
        t.setAdverseEventNo(code);
        t.setCreateTime(new Date());
        t.setStatus(KpiAdverseEventStatus.NO_SEND.getValue());
        t.setPurCompanyId(t.getCompany().getId());
        t.setPurCompanyName(t.getCompany().getCompanyName());
        t.setPurCompanySrmCode(t.getCompany().getCompanyCode());
        t.setPurCompanySapCode(t.getCompany().getCompanySapCode());
        t.setPurUserId(t.getUser().getId());
        t.setPurUserName(t.getUser().getUsername());

        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(t.getSupCompanySrmCode());
        List<Company> companies = this.companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isEmpty(companies)) {
            throw new CommonException("供应商SRM编码:" + t.getSupCompanySrmCode() + "不存在，请确认修改", "do_not_exists",
                    "供应商SRM编码:" + t.getSupCompanySrmCode());
        }
        User user = this.companyUserRefService.queryMainUserOfCompany(companies.get(0).getId());// 供应商的角色info
        t.setSupUserId(user.getId());
        t.setSupUserName(user.getNickName());
        t.setSupCompanyId(companies.get(0).getId());
        t.setSupCompanySapCode(companies.get(0).getCompanySapCode());
        t.setSupCompanyName(companies.get(0).getCompanyFullName());
        t.setSupplierSrmName(companies.get(0).getCompanyFullName());
        t.setSupplierNickName(companies.get(0).getCompanyName());
        t.setSupRemark(companies.get(0).getRemark());
        this.kpiAdverseEventMapper.insertSelective(t);

    }

    private String getDicGroupItemCode(String groupItemId, String matter) {
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdEqualTo(groupItemId).andNameEqualTo(matter);
        List<DicGroupItem> dicGroupItemMatterList = this.dicGroupItemService
                .queryAllObjByExample(dicGroupItemExample);
        String code = null;
        if (CollectionUtils.isNotEmpty(dicGroupItemMatterList)) {
            code = dicGroupItemMatterList.get(0).getCode();
        }
        return code;
    }

    private boolean isExistDicGroupItem(String groupItemId, String string) {
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdEqualTo(groupItemId);
        List<DicGroupItem> dicGroupItemMatterList = this.dicGroupItemService
                .queryAllObjByExample(dicGroupItemExample);
        List<String> dicGroupItemMatters = new ArrayList<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(dicGroupItemMatterList)
                && i < dicGroupItemMatterList.size(); i++) {
            dicGroupItemMatters.add(dicGroupItemMatterList.get(i).getName());
        }
        if (!dicGroupItemMatters.contains(string)) {
            return false;
        }
        return true;
    }

    @CacheEvict(value = { "kpiAdverseEvent" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.kpiAdverseEventMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "kpiAdverseEvent" }, allEntries = true)
    @Override
    public void modifyObj(KpiAdverseEvent t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        t.setLastUpdateTime(new Date());
        t.setLastUpdateUser(t.getUser().getUsername());
        this.kpiAdverseEventMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "kpiAdverseEvent", keyGenerator = "redisKeyGenerator")
    @Override
    public KpiAdverseEvent queryObjById(String id) {
        return this.kpiAdverseEventMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "kpiAdverseEvent", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KpiAdverseEvent> queryAllObjByExample(KpiAdverseEventExample example) {
        return this.kpiAdverseEventMapper.selectByExample(example);
    }

    // @Cacheable(value = "kpiAdverseEvent", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KpiAdverseEvent> queryObjByPage(KpiAdverseEventExample example) {
        PageView<KpiAdverseEvent> pageView = example.getPageView();
        pageView.setQueryResult(this.kpiAdverseEventMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void supSubmitAppeal(KpiAdverseEvent kpiAdverseEvent, String type) {
        KpiAdverseEvent adverseEvent = new KpiAdverseEvent();
        adverseEvent.setId(kpiAdverseEvent.getId());
        String code = null;
        String receiverId = null;
        switch (type) {
        // 0:采购方发送不良事件登记单 1:供应商提起不良事件申诉 2:采购方不良事件登记单拒绝申诉 3:作废
        case "0":// ADVERSE_EVENT_SEND
            adverseEvent.setStatus(KpiAdverseEventStatus.IS_SEND.getValue());
            code = "ADVERSE_EVENT_SEND";
            receiverId = kpiAdverseEvent.getSupUserId();
            break;
        case "1":// ADVERSE_EVENT_SUP_SUBMIT
            adverseEvent.setStatus(KpiAdverseEventStatus.APPEALING.getValue());
            code = "ADVERSE_EVENT_SUP_SUBMIT";
            receiverId = kpiAdverseEvent.getPurUserId();
            break;
        case "2":// ADVERSE_EVENT_REFUSE
            adverseEvent.setStatus(KpiAdverseEventStatus.REFUSE_APPEAL.getValue());
            code = "ADVERSE_EVENT_REFUSE";
            receiverId = kpiAdverseEvent.getSupUserId();
            break;
        case "3":
            adverseEvent.setStatus(KpiAdverseEventStatus.TO_VOID.getValue());
        }
        this.kpiAdverseEventMapper.updateByPrimaryKeySelective(adverseEvent);
        // 发送通知
        if (StringUtils.isNotBlank(code)) {
            Message<KpiAdverseEvent> message = Message.init(kpiAdverseEvent) // 传入数据
                    .setBusinessTypeCode(code) // 业务编码
                    .setCompanyCode(kpiAdverseEvent.getCompany().getCompanyCode()) // 发送的企业srm编码
                    .setMsgLevel(MessageLevelEnum.HIGH) // 消息等级
                    .setSenderId(kpiAdverseEvent.getUser().getId()) // 发送人的userid
                    .addReceiverId(receiverId); // 收件人 userid
            MessageSendUtils.sendMessage(message);
        }

    }
}